/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.TestUtil;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class NetworkEquivalenceTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final String E11 = "1-1";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E13 = "1-3";
    private final TestUtil.EdgeType edgeType;
    private final MutableNetwork<Integer, String> network;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({TestUtil.EdgeType.UNDIRECTED}, {TestUtil.EdgeType.DIRECTED});
    }

    public NetworkEquivalenceTest(TestUtil.EdgeType edgeType) {
        this.edgeType = edgeType;
        this.network = NetworkEquivalenceTest.createNetwork(edgeType);
    }

    private static MutableNetwork<Integer, String> createNetwork(TestUtil.EdgeType edgeType) {
        switch (edgeType) {
            case UNDIRECTED: {
                return NetworkBuilder.undirected().allowsSelfLoops(true).build();
            }
            case DIRECTED: {
                return NetworkBuilder.directed().allowsSelfLoops(true).build();
            }
        }
        throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)edgeType));
    }

    private static TestUtil.EdgeType oppositeType(TestUtil.EdgeType edgeType) {
        switch (edgeType) {
            case UNDIRECTED: {
                return TestUtil.EdgeType.DIRECTED;
            }
            case DIRECTED: {
                return TestUtil.EdgeType.UNDIRECTED;
            }
        }
        throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)edgeType));
    }

    @Test
    public void equivalent_nodeSetsDiffer() {
        this.network.addNode((Object)N1);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(this.edgeType);
        g2.addNode((Object)N2);
        Truth.assertThat(this.network).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_edgeSetsDiffer() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(this.edgeType);
        g2.addEdge((Object)N1, (Object)N2, (Object)E13);
        Truth.assertThat(this.network).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_directedVsUndirected() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(NetworkEquivalenceTest.oppositeType(this.edgeType));
        g2.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat(this.network).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_selfLoop_directedVsUndirected() {
        this.network.addEdge((Object)N1, (Object)N1, (Object)E11);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(NetworkEquivalenceTest.oppositeType(this.edgeType));
        g2.addEdge((Object)N1, (Object)N1, (Object)E11);
        Truth.assertThat(this.network).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_connectionsDiffer() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        this.network.addEdge((Object)N1, (Object)N3, (Object)E13);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(this.edgeType);
        g2.addEdge((Object)N1, (Object)N2, (Object)E13);
        g2.addEdge((Object)N1, (Object)N3, (Object)E12);
        Truth.assertThat(this.network).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_propertiesDiffer() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        MutableNetwork g2 = NetworkBuilder.from(this.network).allowsParallelEdges(!this.network.allowsParallelEdges()).allowsSelfLoops(!this.network.allowsSelfLoops()).build();
        g2.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat(this.network).isEqualTo((Object)g2);
    }

    @Test
    public void equivalent_edgeAddOrdersDiffer() {
        NetworkBuilder builder = NetworkBuilder.from(this.network).allowsParallelEdges(true);
        MutableNetwork g1 = builder.build();
        MutableNetwork g2 = builder.build();
        g1.addEdge((Object)N1, (Object)N2, (Object)E12);
        g1.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        g2.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        g2.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat((Object)g1).isEqualTo((Object)g2);
    }

    @Test
    public void equivalent_edgeDirectionsDiffer() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        MutableNetwork<Integer, String> g2 = NetworkEquivalenceTest.createNetwork(this.edgeType);
        g2.addEdge((Object)N2, (Object)N1, (Object)E12);
        switch (this.edgeType) {
            case UNDIRECTED: {
                Truth.assertThat(this.network).isEqualTo(g2);
                break;
            }
            case DIRECTED: {
                Truth.assertThat(this.network).isNotEqualTo(g2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)this.edgeType));
            }
        }
    }
}

