/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractNetworkTest;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class NetworkMutationTest {
    private static final int NUM_TRIALS = 25;
    private static final int NUM_NODES = 100;
    private static final int NUM_EDGES = 1000;
    private static final int NODE_POOL_SIZE = 1000;

    @Test
    public void directedNetwork() {
        NetworkMutationTest.testNetworkMutation((NetworkBuilder<? super Integer, Object>)NetworkBuilder.directed());
    }

    @Test
    public void undirectedNetwork() {
        NetworkMutationTest.testNetworkMutation((NetworkBuilder<? super Integer, Object>)NetworkBuilder.undirected());
    }

    private static void testNetworkMutation(NetworkBuilder<? super Integer, Object> networkBuilder) {
        Random gen = new Random(42L);
        for (int trial = 0; trial < 25; ++trial) {
            int i;
            MutableNetwork network = networkBuilder.allowsParallelEdges(true).allowsSelfLoops(true).build();
            Truth.assertThat((Iterable)network.nodes()).isEmpty();
            Truth.assertThat((Iterable)network.edges()).isEmpty();
            AbstractNetworkTest.validateNetwork(network);
            while (network.nodes().size() < 100) {
                network.addNode((Object)gen.nextInt(1000));
            }
            ArrayList nodeList = new ArrayList(network.nodes());
            for (int i2 = 0; i2 < 1000; ++i2) {
                Truth.assertThat((Boolean)network.addEdge(NetworkMutationTest.getRandomElement(nodeList, gen), NetworkMutationTest.getRandomElement(nodeList, gen), new Object())).isTrue();
            }
            ArrayList edgeList = new ArrayList(network.edges());
            Truth.assertThat((Iterable)network.nodes()).hasSize(100);
            Truth.assertThat((Iterable)network.edges()).hasSize(1000);
            AbstractNetworkTest.validateNetwork(network);
            Collections.shuffle(edgeList, gen);
            int numEdgesToRemove = gen.nextInt(1000);
            for (int i3 = 0; i3 < numEdgesToRemove; ++i3) {
                Object edge = edgeList.get(i3);
                Truth.assertThat((Boolean)network.removeEdge(edge)).isTrue();
            }
            Truth.assertThat((Iterable)network.nodes()).hasSize(100);
            Truth.assertThat((Iterable)network.edges()).hasSize(1000 - numEdgesToRemove);
            AbstractNetworkTest.validateNetwork(network);
            Collections.shuffle(nodeList, gen);
            int numNodesToRemove = gen.nextInt(100);
            for (i = 0; i < numNodesToRemove; ++i) {
                Truth.assertThat((Boolean)network.removeNode(nodeList.get(i))).isTrue();
            }
            Truth.assertThat((Iterable)network.nodes()).hasSize(100 - numNodesToRemove);
            AbstractNetworkTest.validateNetwork(network);
            for (i = numNodesToRemove; i < 100; ++i) {
                Truth.assertThat((Boolean)network.removeNode(nodeList.get(i))).isTrue();
            }
            Truth.assertThat((Iterable)network.nodes()).isEmpty();
            Truth.assertThat((Iterable)network.edges()).isEmpty();
            AbstractNetworkTest.validateNetwork(network);
            Collections.shuffle(nodeList, gen);
            for (Integer node : nodeList) {
                Truth.assertThat((Boolean)network.addNode((Object)node)).isTrue();
            }
            Collections.shuffle(edgeList, gen);
            for (Object edge : edgeList) {
                Truth.assertThat((Boolean)network.addEdge(NetworkMutationTest.getRandomElement(nodeList, gen), NetworkMutationTest.getRandomElement(nodeList, gen), edge)).isTrue();
            }
            Truth.assertThat((Iterable)network.nodes()).hasSize(100);
            Truth.assertThat((Iterable)network.edges()).hasSize(1000);
            AbstractNetworkTest.validateNetwork(network);
        }
    }

    private static <L extends List<T> & RandomAccess, T> T getRandomElement(L list, Random gen) {
        return list.get(gen.nextInt(list.size()));
    }
}

