/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.primitives.Chars;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TraverserTest {
    private static final SuccessorsFunction<Character> JAVADOC_GRAPH = TraverserTest.createUndirectedGraph("ba", "ad", "be", "ac", "ec", "cf");
    private static final SuccessorsFunction<Character> DIAMOND_GRAPH = TraverserTest.createDirectedGraph("ab", "ac", "bd", "cd");
    private static final SuccessorsFunction<Character> MULTI_GRAPH = TraverserTest.createDirectedGraph("aa", "dd", "ab", "ac", "ca", "cd", "bd");
    private static final SuccessorsFunction<Character> CYCLE_GRAPH = TraverserTest.createDirectedGraph("ab", "bc", "cd", "da");
    private static final SuccessorsFunction<Character> TWO_CYCLES_GRAPH = TraverserTest.createDirectedGraph("ab", "ac", "bc", "cd", "da");
    private static final SuccessorsFunction<Character> TREE = TraverserTest.createDirectedGraph("hd", "he", "hg", "da", "db", "dc", "gf");
    private static final SuccessorsFunction<Character> TWO_TREES = TraverserTest.createDirectedGraph("ab", "cd");
    private static final SuccessorsFunction<Character> SINGLE_ROOT = TraverserTest.createSingleRootGraph();
    private static final SuccessorsFunction<Character> CYCLIC_GRAPH_CONTAINING_TREE = TraverserTest.createDirectedGraph("ab", "bc", "bd", "ed", "ef", "fe");
    private static final SuccessorsFunction<Character> GRAPH_CONTAINING_TREE_AND_DIAMOND = TraverserTest.createDirectedGraph("ab", "fe", "fg", "bc", "bd", "ed", "eh", "gh");

    @Test
    public void forGraph_breadthFirst_javadocExample_canBeIteratedMultipleTimes() {
        Iterable result = Traverser.forGraph(JAVADOC_GRAPH).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "abcdef");
        TraverserTest.assertEqualCharNodes(result, "abcdef");
    }

    @Test
    public void forGraph_breadthFirst_diamond() {
        Traverser traverser = Traverser.forGraph(DIAMOND_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('c')), "cd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_breadthFirst_multiGraph() {
        Traverser traverser = Traverser.forGraph(MULTI_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('c')), "cadb");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_breadthFirst_cycle() {
        Traverser traverser = Traverser.forGraph(CYCLE_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bcda");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('c')), "cdab");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "dabc");
    }

    @Test
    public void forGraph_breadthFirst_twoCycles() {
        Traverser traverser = Traverser.forGraph(TWO_CYCLES_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bcda");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('c')), "cdab");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "dabc");
    }

    @Test
    public void forGraph_breadthFirst_tree() throws Exception {
        Traverser traverser = Traverser.forGraph(TREE);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('h')), "hdegabcf");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "dabc");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forGraph_breadthFirst_twoTrees() {
        Iterable result = Traverser.forGraph(TWO_TREES).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ab");
    }

    @Test
    public void forGraph_breadthFirst_singleRoot() {
        Iterable result = Traverser.forGraph(SINGLE_ROOT).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forGraph_breadthFirst_emptyGraph() {
        try {
            Traverser.forGraph(TraverserTest.createDirectedGraph(new String[0])).breadthFirst((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forGraph_breadthFirst_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(DIAMOND_GRAPH);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('b')});
    }

    @Test
    public void forGraph_depthFirstPreOrder_javadocExample_canBeIteratedMultipleTimes() {
        Iterable result = Traverser.forGraph(JAVADOC_GRAPH).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "abecfd");
        TraverserTest.assertEqualCharNodes(result, "abecfd");
    }

    @Test
    public void forGraph_depthFirstPreOrder_diamond() {
        Traverser traverser = Traverser.forGraph(DIAMOND_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abdc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('c')), "cd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_depthFirstPreOrder_multigraph() {
        Traverser traverser = Traverser.forGraph(MULTI_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abdc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('c')), "cabd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_depthFirstPreOrder_cycle() {
        Traverser traverser = Traverser.forGraph(CYCLE_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bcda");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('c')), "cdab");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "dabc");
    }

    @Test
    public void forGraph_depthFirstPreOrder_twoCycles() {
        Traverser traverser = Traverser.forGraph(TWO_CYCLES_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bcda");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('c')), "cdab");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "dabc");
    }

    @Test
    public void forGraph_depthFirstPreOrder_tree() throws Exception {
        Traverser traverser = Traverser.forGraph(TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('h')), "hdabcegf");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "dabc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forGraph_depthFirstPreOrder_twoTrees() {
        Iterable result = Traverser.forGraph(TWO_TREES).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ab");
    }

    @Test
    public void forGraph_depthFirstPreOrder_singleRoot() {
        Iterable result = Traverser.forGraph(SINGLE_ROOT).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forGraph_depthFirstPreOrder_emptyGraph() {
        try {
            Traverser.forGraph(TraverserTest.createDirectedGraph(new String[0])).depthFirstPreOrder((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forGraph_depthFirstPreOrder_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(DIAMOND_GRAPH);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('d')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('b'), Character.valueOf('d'), Character.valueOf('d')});
    }

    @Test
    public void forGraph_depthFirstPostOrder_javadocExample_canBeIteratedMultipleTimes() {
        Iterable result = Traverser.forGraph(JAVADOC_GRAPH).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "fcebda");
        TraverserTest.assertEqualCharNodes(result, "fcebda");
    }

    @Test
    public void forGraph_depthFirstPostOrder_diamond() {
        Traverser traverser = Traverser.forGraph(DIAMOND_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "dbca");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "db");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('c')), "dc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_depthFirstPostOrder_multigraph() {
        Traverser traverser = Traverser.forGraph(MULTI_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "dbca");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "db");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('c')), "dbac");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forGraph_depthFirstPostOrder_cycle() {
        Traverser traverser = Traverser.forGraph(CYCLE_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "dcba");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "adcb");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('c')), "badc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "cbad");
    }

    @Test
    public void forGraph_depthFirstPostOrder_twoCycles() {
        Traverser traverser = Traverser.forGraph(TWO_CYCLES_GRAPH);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "dcba");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "adcb");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('c')), "badc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "cbad");
    }

    @Test
    public void forGraph_depthFirstPostOrder_tree() throws Exception {
        Traverser traverser = Traverser.forGraph(TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('h')), "abcdefgh");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forGraph_depthFirstPostOrder_twoTrees() {
        Iterable result = Traverser.forGraph(TWO_TREES).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ba");
    }

    @Test
    public void forGraph_depthFirstPostOrder_singleRoot() {
        Iterable result = Traverser.forGraph(SINGLE_ROOT).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forGraph_depthFirstPostOrder_emptyGraph() {
        try {
            Traverser.forGraph(TraverserTest.createDirectedGraph(new String[0])).depthFirstPostOrder((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forGraph_depthFirstPostOrder_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(DIAMOND_GRAPH);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "db");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('d')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "db");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('b'), Character.valueOf('d'), Character.valueOf('d')});
    }

    @Test
    public void forTree_acceptsDirectedGraph() throws Exception {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.putEdge((Object)"a", (Object)"b");
        Traverser.forTree((SuccessorsFunction)graph);
    }

    @Test
    public void forTree_withUndirectedGraph_throws() throws Exception {
        MutableGraph graph = GraphBuilder.undirected().build();
        graph.putEdge((Object)"a", (Object)"b");
        try {
            Traverser.forTree((SuccessorsFunction)graph);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_acceptsDirectedValueGraph() throws Exception {
        MutableValueGraph valueGraph = ValueGraphBuilder.directed().build();
        valueGraph.putEdgeValue((Object)"a", (Object)"b", (Object)11);
        Traverser.forTree((SuccessorsFunction)valueGraph);
    }

    @Test
    public void forTree_withUndirectedValueGraph_throws() throws Exception {
        MutableValueGraph valueGraph = ValueGraphBuilder.undirected().build();
        valueGraph.putEdgeValue((Object)"a", (Object)"b", (Object)11);
        try {
            Traverser.forTree((SuccessorsFunction)valueGraph);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_acceptsDirectedNetwork() throws Exception {
        MutableNetwork network = NetworkBuilder.directed().build();
        network.addEdge((Object)"a", (Object)"b", (Object)11);
        Traverser.forTree((SuccessorsFunction)network);
    }

    @Test
    public void forTree_withUndirectedNetwork_throws() throws Exception {
        MutableNetwork network = NetworkBuilder.undirected().build();
        network.addEdge((Object)"a", (Object)"b", (Object)11);
        try {
            Traverser.forTree((SuccessorsFunction)network);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_breadthFirst_tree() throws Exception {
        Traverser traverser = Traverser.forTree(TREE);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('h')), "hdegabcf");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "dabc");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forTree_breadthFirst_cyclicGraphContainingTree() throws Exception {
        Traverser traverser = Traverser.forTree(CYCLIC_GRAPH_CONTAINING_TREE);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_breadthFirst_graphContainingTreeAndDiamond() throws Exception {
        Traverser traverser = Traverser.forTree(GRAPH_CONTAINING_TREE_AND_DIAMOND);
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('b')), "bcd");
        TraverserTest.assertEqualCharNodes(traverser.breadthFirst((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_breadthFirst_twoTrees() {
        Iterable result = Traverser.forTree(TWO_TREES).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ab");
    }

    @Test
    public void forTree_breadthFirst_singleRoot() {
        Iterable result = Traverser.forTree(SINGLE_ROOT).breadthFirst((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forTree_breadthFirst_emptyGraph() {
        try {
            Traverser.forTree(TraverserTest.createDirectedGraph(new String[0])).breadthFirst((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_breadthFirst_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(TREE);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).breadthFirst((Object)Character.valueOf('h'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "hd");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "hd");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('d')});
    }

    @Test
    public void forTree_depthFirstPreOrder_tree() throws Exception {
        Traverser traverser = Traverser.forTree(TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('h')), "hdabcegf");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "dabc");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forTree_depthFirstPreOrder_cyclicGraphContainingTree() throws Exception {
        Traverser traverser = Traverser.forTree(CYCLIC_GRAPH_CONTAINING_TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_depthFirstPreOrder_graphContainingTreeAndDiamond() throws Exception {
        Traverser traverser = Traverser.forTree(GRAPH_CONTAINING_TREE_AND_DIAMOND);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('a')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('b')), "bcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPreOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_depthFirstPreOrder_twoTrees() {
        Iterable result = Traverser.forTree(TWO_TREES).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ab");
    }

    @Test
    public void forTree_depthFirstPreOrder_singleRoot() {
        Iterable result = Traverser.forTree(SINGLE_ROOT).depthFirstPreOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forTree_depthFirstPreOrder_emptyGraph() {
        try {
            Traverser.forTree(TraverserTest.createDirectedGraph(new String[0])).depthFirstPreOrder((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_depthFirstPreOrder_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(TREE);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).depthFirstPreOrder((Object)Character.valueOf('h'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "hd");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('a')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "hd");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('d'), Character.valueOf('a'), Character.valueOf('a')});
    }

    @Test
    public void forTree_depthFirstPostOrder_tree() throws Exception {
        Traverser traverser = Traverser.forTree(TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('h')), "abcdefgh");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "abcd");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "a");
    }

    @Test
    public void forTree_depthFirstPostOrder_cyclicGraphContainingTree() throws Exception {
        Traverser traverser = Traverser.forTree(CYCLIC_GRAPH_CONTAINING_TREE);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "cdba");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "cdb");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_depthFirstPostOrder_graphContainingTreeAndDiamond() throws Exception {
        Traverser traverser = Traverser.forTree(GRAPH_CONTAINING_TREE_AND_DIAMOND);
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('a')), "cdba");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('b')), "cdb");
        TraverserTest.assertEqualCharNodes(traverser.depthFirstPostOrder((Object)Character.valueOf('d')), "d");
    }

    @Test
    public void forTree_depthFirstPostOrder_twoTrees() {
        Iterable result = Traverser.forTree(TWO_TREES).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "ba");
    }

    @Test
    public void forTree_depthFirstPostOrder_singleRoot() {
        Iterable result = Traverser.forTree(SINGLE_ROOT).depthFirstPostOrder((Object)Character.valueOf('a'));
        TraverserTest.assertEqualCharNodes(result, "a");
    }

    @Test
    public void forTree_depthFirstPostOrder_emptyGraph() {
        try {
            Traverser.forTree(TraverserTest.createDirectedGraph(new String[0])).depthFirstPostOrder((Object)Character.valueOf('a'));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void forTree_depthFirstPostOrder_iterableIsLazy() {
        RequestSavingGraph graph = new RequestSavingGraph(TREE);
        Iterable result = Traverser.forGraph((SuccessorsFunction)graph).depthFirstPostOrder((Object)Character.valueOf('h'));
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('a'), Character.valueOf('b')});
        TraverserTest.assertEqualCharNodes(Iterables.limit((Iterable)result, (int)2), "ab");
        Truth.assertThat(graph.requestedNodes).containsExactly(new Object[]{Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('d'), Character.valueOf('a'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('b')});
    }

    private static SuccessorsFunction<Character> createDirectedGraph(String ... edges) {
        return TraverserTest.createGraph(true, edges);
    }

    private static SuccessorsFunction<Character> createUndirectedGraph(String ... edges) {
        return TraverserTest.createGraph(false, edges);
    }

    private static SuccessorsFunction<Character> createGraph(boolean directed, String ... edges) {
        ImmutableMultimap.Builder graphMapBuilder = ImmutableMultimap.builder();
        for (String edge : edges) {
            Preconditions.checkArgument((edge.length() == 2 ? 1 : 0) != 0, (String)"Expecting each edge to consist of 2 characters but got %s", (Object)edge);
            char node1 = edge.charAt(0);
            char node2 = edge.charAt(1);
            graphMapBuilder.put((Object)Character.valueOf(node1), (Object)Character.valueOf(node2));
            if (directed) continue;
            graphMapBuilder.put((Object)Character.valueOf(node2), (Object)Character.valueOf(node1));
        }
        final ImmutableMultimap graphMap = graphMapBuilder.build();
        return new SuccessorsFunction<Character>(){

            public Iterable<? extends Character> successors(Character node) {
                Preconditions.checkArgument((graphMap.containsKey((Object)node) || graphMap.containsValue((Object)node) ? 1 : 0) != 0, (String)"Node %s is not an element of this graph", (Object)node);
                return Ordering.natural().immutableSortedCopy((Iterable)graphMap.get((Object)node));
            }
        };
    }

    private static ImmutableGraph<Character> createSingleRootGraph() {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.addNode((Object)Character.valueOf('a'));
        return ImmutableGraph.copyOf((Graph)graph);
    }

    private static void assertEqualCharNodes(Iterable<Character> result, String expectedCharacters) {
        Truth.assertThat((Iterable)ImmutableList.copyOf(result)).containsExactlyElementsIn((Iterable)Chars.asList((char[])expectedCharacters.toCharArray())).inOrder();
    }

    private static class RequestSavingGraph
    implements SuccessorsFunction<Character> {
        private final SuccessorsFunction<Character> delegate;
        final Multiset<Character> requestedNodes = HashMultiset.create();

        RequestSavingGraph(SuccessorsFunction<Character> delegate) {
            this.delegate = (SuccessorsFunction)Preconditions.checkNotNull(delegate);
        }

        public Iterable<? extends Character> successors(Character node) {
            this.requestedNodes.add((Object)node);
            return this.delegate.successors((Object)node);
        }
    }
}

