/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.TestUtil;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ValueGraphTest {
    private static final String DEFAULT = "default";
    MutableValueGraph<Integer, String> graph;

    @After
    public void validateGraphState() {
        TestUtil.assertStronglyEquivalent(this.graph, Graphs.copyOf(this.graph));
        TestUtil.assertStronglyEquivalent(this.graph, ImmutableValueGraph.copyOf(this.graph));
        Graph asGraph = this.graph.asGraph();
        AbstractGraphTest.validateGraph(asGraph);
        Truth.assertThat((Iterable)this.graph.nodes()).isEqualTo((Object)asGraph.nodes());
        Truth.assertThat((Iterable)this.graph.edges()).isEqualTo((Object)asGraph.edges());
        Truth.assertThat((Object)this.graph.nodeOrder()).isEqualTo((Object)asGraph.nodeOrder());
        Truth.assertThat((Boolean)this.graph.isDirected()).isEqualTo((Object)asGraph.isDirected());
        Truth.assertThat((Boolean)this.graph.allowsSelfLoops()).isEqualTo((Object)asGraph.allowsSelfLoops());
        for (Integer node : this.graph.nodes()) {
            Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)node)).isEqualTo((Object)asGraph.adjacentNodes((Object)node));
            Truth.assertThat((Iterable)this.graph.predecessors((Object)node)).isEqualTo((Object)asGraph.predecessors((Object)node));
            Truth.assertThat((Iterable)this.graph.successors((Object)node)).isEqualTo((Object)asGraph.successors((Object)node));
            Truth.assertThat((Integer)this.graph.degree((Object)node)).isEqualTo((Object)asGraph.degree((Object)node));
            Truth.assertThat((Integer)this.graph.inDegree((Object)node)).isEqualTo((Object)asGraph.inDegree((Object)node));
            Truth.assertThat((Integer)this.graph.outDegree((Object)node)).isEqualTo((Object)asGraph.outDegree((Object)node));
            for (Integer otherNode : this.graph.nodes()) {
                boolean hasEdge = this.graph.hasEdgeConnecting((Object)node, (Object)otherNode);
                Truth.assertThat((Boolean)hasEdge).isEqualTo((Object)asGraph.hasEdgeConnecting((Object)node, (Object)otherNode));
                Truth.assertThat((Boolean)(this.graph.edgeValueOrDefault((Object)node, (Object)otherNode, null) != null ? 1 : 0)).isEqualTo((Object)hasEdge);
                Truth.assertThat((Boolean)(!((String)this.graph.edgeValueOrDefault((Object)node, (Object)otherNode, (Object)DEFAULT)).equals(DEFAULT) ? 1 : 0)).isEqualTo((Object)hasEdge);
            }
        }
    }

    @Test
    public void directedGraph() {
        this.graph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        this.graph.putEdgeValue((Object)4, (Object)4, (Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, null))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, null))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)3, null))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)4, (Object)4, null))).isEqualTo((Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)DEFAULT))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)DEFAULT))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)3, (Object)DEFAULT))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)4, (Object)4, (Object)DEFAULT))).isEqualTo((Object)"valueD");
        String toString = this.graph.toString();
        Truth.assertThat((String)toString).contains((CharSequence)"valueA");
        Truth.assertThat((String)toString).contains((CharSequence)"valueB");
        Truth.assertThat((String)toString).contains((CharSequence)"valueC");
        Truth.assertThat((String)toString).contains((CharSequence)"valueD");
    }

    @Test
    public void undirectedGraph() {
        this.graph = ValueGraphBuilder.undirected().allowsSelfLoops(true).build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        this.graph.putEdgeValue((Object)4, (Object)4, (Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, null))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, null))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)3, null))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)4, (Object)4, null))).isEqualTo((Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)DEFAULT))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)DEFAULT))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)3, (Object)DEFAULT))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)4, (Object)4, (Object)DEFAULT))).isEqualTo((Object)"valueD");
        String toString = this.graph.toString();
        Truth.assertThat((String)toString).doesNotContain((CharSequence)"valueA");
        Truth.assertThat((String)toString).contains((CharSequence)"valueB");
        Truth.assertThat((String)toString).contains((CharSequence)"valueC");
        Truth.assertThat((String)toString).contains((CharSequence)"valueD");
    }

    @Test
    public void putEdgeValue_directed() {
        this.graph = ValueGraphBuilder.directed().build();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueC"))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueD"))).isEqualTo((Object)"valueB");
    }

    @Test
    public void putEdgeValue_undirected() {
        this.graph = ValueGraphBuilder.undirected().build();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB"))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueC"))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueD"))).isEqualTo((Object)"valueC");
    }

    @Test
    public void removeEdge_directed() {
        this.graph = ValueGraphBuilder.directed().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isNull();
    }

    @Test
    public void removeEdge_undirected() {
        this.graph = ValueGraphBuilder.undirected().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isNull();
    }

    @Test
    public void edgeValue_missing() {
        this.graph = ValueGraphBuilder.directed().build();
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)DEFAULT))).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)DEFAULT))).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)this.graph.edgeValue((Object)1, (Object)2).orElse(DEFAULT)).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)this.graph.edgeValue((Object)2, (Object)1).orElse(DEFAULT)).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, null))).isNull();
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, null))).isNull();
        Truth.assertThat((String)this.graph.edgeValue((Object)1, (Object)2).orElse(null)).isNull();
        Truth.assertThat((String)this.graph.edgeValue((Object)2, (Object)1).orElse(null)).isNull();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)DEFAULT))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)DEFAULT))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, null))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, null))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)1, (Object)2).get())).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)1).get())).isEqualTo((Object)"valueB");
        this.graph.removeEdge((Object)1, (Object)2);
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)DEFAULT))).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)DEFAULT))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)this.graph.edgeValue((Object)1, (Object)2).orElse(DEFAULT)).isEqualTo((Object)DEFAULT);
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, null))).isNull();
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, null))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)this.graph.edgeValue((Object)1, (Object)2).orElse(null)).isNull();
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)1).get())).isEqualTo((Object)"valueC");
    }

    @Test
    public void equivalence_considersEdgeValue() {
        this.graph = ValueGraphBuilder.undirected().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        MutableValueGraph otherGraph = ValueGraphBuilder.undirected().build();
        otherGraph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        Truth.assertThat(this.graph).isEqualTo((Object)otherGraph);
        otherGraph.putEdgeValue((Object)1, (Object)2, (Object)"valueB");
        Truth.assertThat(this.graph).isNotEqualTo((Object)otherGraph);
    }
}

