/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;

public class AbstractNonStreamingHashFunctionTest
extends TestCase {
    public void testExhaustive() {
        int i;
        ImmutableList hashers = ImmutableList.of((Object)new StreamingVersion().newHasher(), (Object)new StreamingVersion().newHasher(52), (Object)new NonStreamingVersion().newHasher(), (Object)new NonStreamingVersion().newHasher(123));
        Random random = new Random(0L);
        for (int i2 = 0; i2 < 200; ++i2) {
            HashTestUtils.RandomHasherAction.pickAtRandom(random).performAction(random, (Iterable<? extends PrimitiveSink>)hashers);
        }
        HashCode[] codes = new HashCode[hashers.size()];
        for (i = 0; i < hashers.size(); ++i) {
            codes[i] = ((Hasher)hashers.get(i)).hash();
        }
        for (i = 1; i < codes.length; ++i) {
            AbstractNonStreamingHashFunctionTest.assertEquals((Object)codes[i - 1], (Object)codes[i]);
        }
    }

    public void testPutStringWithLowSurrogate() {
        AbstractNonStreamingHashFunctionTest.assertPutString(new char[]{'p', HashTestUtils.randomLowSurrogate(new Random())});
    }

    public void testPutStringWithHighSurrogate() {
        AbstractNonStreamingHashFunctionTest.assertPutString(new char[]{'p', HashTestUtils.randomHighSurrogate(new Random())});
    }

    public void testPutStringWithLowHighSurrogate() {
        AbstractNonStreamingHashFunctionTest.assertPutString(new char[]{HashTestUtils.randomLowSurrogate(new Random()), HashTestUtils.randomHighSurrogate(new Random())});
    }

    public void testPutStringWithHighLowSurrogate() {
        AbstractNonStreamingHashFunctionTest.assertPutString(new char[]{HashTestUtils.randomHighSurrogate(new Random()), HashTestUtils.randomLowSurrogate(new Random())});
    }

    private static void assertPutString(char[] chars) {
        Hasher h1 = new NonStreamingVersion().newHasher();
        Hasher h2 = new NonStreamingVersion().newHasher();
        String s = new String(chars);
        for (int i = 0; i < s.length(); ++i) {
            h1.putChar(s.charAt(i));
        }
        h2.putUnencodedChars((CharSequence)s);
        AbstractNonStreamingHashFunctionTest.assertEquals((Object)h1.hash(), (Object)h2.hash());
    }

    static class NonStreamingVersion
    extends AbstractNonStreamingHashFunction {
        NonStreamingVersion() {
        }

        public int bits() {
            return 32;
        }

        public HashCode hashBytes(byte[] input, int off, int len) {
            return HashCode.fromBytes((byte[])Arrays.copyOfRange(input, off, off + len));
        }
    }

    static class StreamingVersion
    extends AbstractHashFunction {
        StreamingVersion() {
        }

        public int bits() {
            return 32;
        }

        public Hasher newHasher() {
            return new AbstractStreamingHasher(4, 4){
                final ByteArrayOutputStream out;
                {
                    super(x0, x1);
                    this.out = new ByteArrayOutputStream();
                }

                protected HashCode makeHash() {
                    return HashCode.fromBytes((byte[])this.out.toByteArray());
                }

                protected void process(ByteBuffer bb) {
                    while (bb.hasRemaining()) {
                        this.out.write(bb.get());
                    }
                }

                protected void processRemaining(ByteBuffer bb) {
                    while (bb.hasRemaining()) {
                        this.out.write(bb.get());
                    }
                }
            };
        }
    }
}

