/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.truth.Truth;
import java.util.Arrays;
import junit.framework.TestCase;

public class FarmHashFingerprint64Test
extends TestCase {
    private static final HashFunction HASH_FN = Hashing.farmHashFingerprint64();

    public void testReallySimpleFingerprints() {
        FarmHashFingerprint64Test.assertEquals((long)8581389452482819506L, (long)FarmHashFingerprint64Test.fingerprint("test".getBytes(Charsets.UTF_8)));
        FarmHashFingerprint64Test.assertEquals((long)-4196240717365766262L, (long)FarmHashFingerprint64Test.fingerprint(Strings.repeat((String)"test", (int)8).getBytes(Charsets.UTF_8)));
        FarmHashFingerprint64Test.assertEquals((long)3500507768004279527L, (long)FarmHashFingerprint64Test.fingerprint(Strings.repeat((String)"test", (int)64).getBytes(Charsets.UTF_8)));
    }

    public void testStringsConsistency() {
        for (String s : Arrays.asList("", "some", "test", "strings", "to", "try")) {
            FarmHashFingerprint64Test.assertEquals((Object)HASH_FN.newHasher().putUnencodedChars((CharSequence)s).hash(), (Object)HASH_FN.hashUnencodedChars((CharSequence)s));
        }
    }

    public void testUtf8() {
        char[] charsA = new char[128];
        char[] charsB = new char[128];
        for (int i = 0; i < charsA.length; ++i) {
            if (i < 100) {
                charsA[i] = 97;
                charsB[i] = 97;
                continue;
            }
            charsA[i] = (char)(384 + i);
            charsB[i] = (char)(640 + i);
        }
        String stringA = new String(charsA);
        String stringB = new String(charsB);
        Truth.assertThat((String)stringA).isNotEqualTo((Object)stringB);
        Truth.assertThat((Object)HASH_FN.hashUnencodedChars((CharSequence)stringA)).isNotEqualTo((Object)HASH_FN.hashUnencodedChars((CharSequence)stringB));
        Truth.assertThat((Long)FarmHashFingerprint64Test.fingerprint(stringA.getBytes(Charsets.UTF_8))).isNotEqualTo((Object)FarmHashFingerprint64Test.fingerprint(stringB.getBytes(Charsets.UTF_8)));
        FarmHashFingerprint64Test.assertEquals((long)FarmHashFingerprint64Test.fingerprint(stringA.getBytes(Charsets.ISO_8859_1)), (long)FarmHashFingerprint64Test.fingerprint(stringB.getBytes(Charsets.ISO_8859_1)));
    }

    public void testPutNonChars() {
        Hasher hasher = HASH_FN.newHasher();
        hasher.putBoolean(true).putBoolean(true).putBoolean(false).putBoolean(true).putBoolean(false).putBoolean(false).putBoolean(false).putBoolean(false);
        long hashCode = hasher.hash().asLong();
        hasher = HASH_FN.newHasher();
        hasher.putByte((byte)1).putByte((byte)1).putByte((byte)0).putByte((byte)1).putByte((byte)0).putByte((byte)0).putByte((byte)0).putByte((byte)0);
        FarmHashFingerprint64Test.assertEquals((long)hashCode, (long)hasher.hash().asLong());
        hasher = HASH_FN.newHasher();
        hasher.putChar('\u0101').putChar('\u0100').putChar('\u0000').putChar('\u0000');
        FarmHashFingerprint64Test.assertEquals((long)hashCode, (long)hasher.hash().asLong());
        hasher = HASH_FN.newHasher();
        hasher.putBytes(new byte[]{1, 1, 0, 1, 0, 0, 0, 0});
        FarmHashFingerprint64Test.assertEquals((long)hashCode, (long)hasher.hash().asLong());
        hasher = HASH_FN.newHasher();
        hasher.putLong(0x1000101L);
        FarmHashFingerprint64Test.assertEquals((long)hashCode, (long)hasher.hash().asLong());
        hasher = HASH_FN.newHasher();
        hasher.putShort((short)257).putShort((short)256).putShort((short)0).putShort((short)0);
        FarmHashFingerprint64Test.assertEquals((long)hashCode, (long)hasher.hash().asLong());
    }

    public void testHashFloatIsStable() {
        Hasher hasher = HASH_FN.newHasher();
        hasher.putFloat(2.6843958E8f).putFloat(0.0f);
        FarmHashFingerprint64Test.assertEquals((long)5330522045688978216L, (long)hasher.hash().asLong());
        hasher = HASH_FN.newHasher();
        hasher.putDouble(2.68439581E8);
        FarmHashFingerprint64Test.assertEquals((long)4075450455484226751L, (long)hasher.hash().asLong());
    }

    private static long fingerprint(byte[] bytes) {
        return FarmHashFingerprint64Test.fingerprint(bytes, bytes.length);
    }

    private static long fingerprint(byte[] bytes, int length) {
        return HASH_FN.hashBytes(bytes, 0, length).asLong();
    }

    public void testMultipleLengths() {
        int iterations = 800;
        byte[] buf = new byte[iterations * 4];
        int bufLen = 0;
        long h = 0L;
        for (int i = 0; i < iterations; ++i) {
            h ^= FarmHashFingerprint64Test.fingerprint(buf, i);
            h = FarmHashFingerprint64Test.remix(h);
            buf[bufLen++] = FarmHashFingerprint64Test.getChar(h);
            h ^= FarmHashFingerprint64Test.fingerprint(buf, i * i % bufLen);
            h = FarmHashFingerprint64Test.remix(h);
            buf[bufLen++] = FarmHashFingerprint64Test.getChar(h);
            h ^= FarmHashFingerprint64Test.fingerprint(buf, i * i * i % bufLen);
            h = FarmHashFingerprint64Test.remix(h);
            buf[bufLen++] = FarmHashFingerprint64Test.getChar(h);
            h ^= FarmHashFingerprint64Test.fingerprint(buf, bufLen);
            h = FarmHashFingerprint64Test.remix(h);
            buf[bufLen++] = FarmHashFingerprint64Test.getChar(h);
            int x0 = buf[bufLen - 1] & 0xFF;
            int x1 = buf[bufLen - 2] & 0xFF;
            int x2 = buf[bufLen - 3] & 0xFF;
            int x3 = buf[bufLen / 2] & 0xFF;
            int n = ((x0 << 16) + (x1 << 8) + x2) % bufLen;
            buf[n] = (byte)(buf[n] ^ x3);
            int n2 = ((x1 << 16) + (x2 << 8) + x3) % bufLen;
            buf[n2] = (byte)(buf[n2] ^ i % 256);
        }
        FarmHashFingerprint64Test.assertEquals((long)8799303343006015847L, (long)h);
    }

    private static long remix(long h) {
        h ^= h >>> 41;
        return h *= 949921979L;
    }

    private static byte getChar(long h) {
        return (byte)(97L + (h & 0xFFFFFL) % 26L);
    }
}

