/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.PrimitiveSink;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import junit.framework.TestCase;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class FunnelsTest
extends TestCase {
    public void testForBytes() {
        PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        Funnels.byteArrayFunnel().funnel((Object)new byte[]{4, 3, 2, 1}, primitiveSink);
        ((PrimitiveSink)Mockito.verify((Object)primitiveSink)).putBytes(new byte[]{4, 3, 2, 1});
    }

    public void testForBytes_null() {
        FunnelsTest.assertNullsThrowException(Funnels.byteArrayFunnel());
    }

    public void testForStrings() {
        PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        Funnels.unencodedCharsFunnel().funnel((Object)"test", primitiveSink);
        ((PrimitiveSink)Mockito.verify((Object)primitiveSink)).putUnencodedChars((CharSequence)"test");
    }

    public void testForStrings_null() {
        FunnelsTest.assertNullsThrowException(Funnels.unencodedCharsFunnel());
    }

    public void testForStringsCharset() {
        for (Charset charset : Charset.availableCharsets().values()) {
            PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
            Funnels.stringFunnel((Charset)charset).funnel((Object)"test", primitiveSink);
            ((PrimitiveSink)Mockito.verify((Object)primitiveSink)).putString((CharSequence)"test", charset);
        }
    }

    public void testForStringsCharset_null() {
        for (Charset charset : Charset.availableCharsets().values()) {
            FunnelsTest.assertNullsThrowException(Funnels.stringFunnel((Charset)charset));
        }
    }

    public void testForInts() {
        Integer value = 1234;
        PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        Funnels.integerFunnel().funnel((Object)value, primitiveSink);
        ((PrimitiveSink)Mockito.verify((Object)primitiveSink)).putInt(1234);
    }

    public void testForInts_null() {
        FunnelsTest.assertNullsThrowException(Funnels.integerFunnel());
    }

    public void testForLongs() {
        Long value = 1234L;
        PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        Funnels.longFunnel().funnel((Object)value, primitiveSink);
        ((PrimitiveSink)Mockito.verify((Object)primitiveSink)).putLong(1234L);
    }

    public void testForLongs_null() {
        FunnelsTest.assertNullsThrowException(Funnels.longFunnel());
    }

    public void testSequential() {
        Funnel elementFunnel = (Funnel)Mockito.mock(Funnel.class);
        PrimitiveSink primitiveSink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        Funnel sequential = Funnels.sequentialFunnel((Funnel)elementFunnel);
        sequential.funnel(Arrays.asList("foo", "bar", "baz", "quux"), primitiveSink);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{elementFunnel});
        ((Funnel)inOrder.verify((Object)elementFunnel)).funnel((Object)"foo", primitiveSink);
        ((Funnel)inOrder.verify((Object)elementFunnel)).funnel((Object)"bar", primitiveSink);
        ((Funnel)inOrder.verify((Object)elementFunnel)).funnel((Object)"baz", primitiveSink);
        ((Funnel)inOrder.verify((Object)elementFunnel)).funnel((Object)"quux", primitiveSink);
    }

    private static void assertNullsThrowException(Funnel<?> funnel) {
        AbstractStreamingHasher primitiveSink = new AbstractStreamingHasher(4, 4){

            protected HashCode makeHash() {
                throw new UnsupportedOperationException();
            }

            protected void process(ByteBuffer bb) {
                while (bb.hasRemaining()) {
                    bb.get();
                }
            }
        };
        try {
            funnel.funnel(null, (PrimitiveSink)primitiveSink);
            FunnelsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAsOutputStream() throws Exception {
        PrimitiveSink sink = (PrimitiveSink)Mockito.mock(PrimitiveSink.class);
        OutputStream out = Funnels.asOutputStream((PrimitiveSink)sink);
        byte[] bytes = new byte[]{1, 2, 3, 4};
        out.write(255);
        out.write(bytes);
        out.write(bytes, 1, 2);
        ((PrimitiveSink)Mockito.verify((Object)sink)).putByte((byte)-1);
        ((PrimitiveSink)Mockito.verify((Object)sink)).putBytes(bytes);
        ((PrimitiveSink)Mockito.verify((Object)sink)).putBytes(bytes, 1, 2);
    }

    public void testSerialization() {
        FunnelsTest.assertSame((Object)Funnels.byteArrayFunnel(), (Object)SerializableTester.reserialize((Object)Funnels.byteArrayFunnel()));
        FunnelsTest.assertSame((Object)Funnels.integerFunnel(), (Object)SerializableTester.reserialize((Object)Funnels.integerFunnel()));
        FunnelsTest.assertSame((Object)Funnels.longFunnel(), (Object)SerializableTester.reserialize((Object)Funnels.longFunnel()));
        FunnelsTest.assertSame((Object)Funnels.unencodedCharsFunnel(), (Object)SerializableTester.reserialize((Object)Funnels.unencodedCharsFunnel()));
        FunnelsTest.assertEquals((Object)Funnels.sequentialFunnel((Funnel)Funnels.integerFunnel()), (Object)SerializableTester.reserialize((Object)Funnels.sequentialFunnel((Funnel)Funnels.integerFunnel())));
        FunnelsTest.assertEquals((Object)Funnels.stringFunnel((Charset)Charsets.US_ASCII), (Object)SerializableTester.reserialize((Object)Funnels.stringFunnel((Charset)Charsets.US_ASCII)));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{Funnels.byteArrayFunnel()}).addEqualityGroup(new Object[]{Funnels.integerFunnel()}).addEqualityGroup(new Object[]{Funnels.longFunnel()}).addEqualityGroup(new Object[]{Funnels.unencodedCharsFunnel()}).addEqualityGroup(new Object[]{Funnels.stringFunnel((Charset)Charsets.UTF_8)}).addEqualityGroup(new Object[]{Funnels.stringFunnel((Charset)Charsets.US_ASCII)}).addEqualityGroup(new Object[]{Funnels.sequentialFunnel((Funnel)Funnels.integerFunnel()), SerializableTester.reserialize((Object)Funnels.sequentialFunnel((Funnel)Funnels.integerFunnel()))}).addEqualityGroup(new Object[]{Funnels.sequentialFunnel((Funnel)Funnels.longFunnel())}).testEquals();
    }
}

