/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;

public class HashCodeBenchmark {
    private static final Random random = new Random(42L);
    @Param(value={"1000", "100000"})
    private int size;
    @Param
    WhereToDiffer whereToDiffer;
    @Param
    EqualsImplementation equalsImpl;
    private byte[] testBytesA;
    private byte[] testBytesB;

    @BeforeExperiment
    void setUp() {
        this.testBytesA = new byte[this.size];
        random.nextBytes(this.testBytesA);
        this.testBytesB = Arrays.copyOf(this.testBytesA, this.size);
        int indexToDifferAt = -1;
        switch (this.whereToDiffer) {
            case ONE_PERCENT_IN: {
                indexToDifferAt = (int)((double)this.size * 0.01);
                break;
            }
            case LAST_BYTE: {
                indexToDifferAt = this.size - 1;
                break;
            }
        }
        if (indexToDifferAt != -1) {
            this.testBytesA[indexToDifferAt] = (byte)(this.testBytesB[indexToDifferAt] - 1);
        }
    }

    @Benchmark
    boolean hashFunction(int reps) {
        boolean result = true;
        for (int i = 0; i < reps; ++i) {
            result ^= this.equalsImpl.doEquals(this.testBytesA, this.testBytesB);
        }
        return result;
    }

    private static enum EqualsImplementation {
        ANDING_BOOLEANS{

            @Override
            boolean doEquals(byte[] a, byte[] b) {
                if (a.length != b.length) {
                    return false;
                }
                boolean areEqual = true;
                for (int i = 0; i < a.length; ++i) {
                    areEqual &= a[i] == b[i];
                }
                return areEqual;
            }
        }
        ,
        XORING_TO_BYTE{

            @Override
            boolean doEquals(byte[] a, byte[] b) {
                if (a.length != b.length) {
                    return false;
                }
                int result = 0;
                for (int i = 0; i < a.length; ++i) {
                    result = (byte)(result | a[i] ^ b[i]);
                }
                return result == 0;
            }
        }
        ,
        XORING_TO_INT{

            @Override
            boolean doEquals(byte[] a, byte[] b) {
                if (a.length != b.length) {
                    return false;
                }
                int result = 0;
                for (int i = 0; i < a.length; ++i) {
                    result |= a[i] ^ b[i];
                }
                return result == 0;
            }
        }
        ,
        MESSAGE_DIGEST_IS_EQUAL{

            @Override
            boolean doEquals(byte[] a, byte[] b) {
                return MessageDigest.isEqual(a, b);
            }
        }
        ,
        ARRAYS_EQUALS{

            @Override
            boolean doEquals(byte[] a, byte[] b) {
                return Arrays.equals(a, b);
            }
        };


        abstract boolean doEquals(byte[] var1, byte[] var2);
    }

    private static enum WhereToDiffer {
        ONE_PERCENT_IN,
        LAST_BYTE,
        NOT_AT_ALL;

    }
}

