/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashFunctionEnum;
import java.util.Random;

public class HashFunctionBenchmark {
    private static final Random random = new Random(42L);
    @Param(value={"10", "1000", "100000", "1000000"})
    private int size;
    @Param
    HashFunctionEnum hashFunctionEnum;
    private byte[] testBytes;

    @BeforeExperiment
    void setUp() {
        this.testBytes = new byte[this.size];
        random.nextBytes(this.testBytes);
    }

    @Benchmark
    int hasher(int reps) {
        HashFunction hashFunction = this.hashFunctionEnum.getHashFunction();
        int result = 37;
        for (int i = 0; i < reps; ++i) {
            result ^= hashFunction.newHasher().putBytes(this.testBytes).hash().asBytes()[0];
        }
        return result;
    }

    @Benchmark
    int hashFunction(int reps) {
        HashFunction hashFunction = this.hashFunctionEnum.getHashFunction();
        int result = 37;
        for (int i = 0; i < reps; ++i) {
            result ^= hashFunction.hashBytes(this.testBytes).asBytes()[0];
        }
        return result;
    }

    @Benchmark
    int hashFunctionWithOffset(int reps) {
        HashFunction hashFunction = this.hashFunctionEnum.getHashFunction();
        int result = 37;
        for (int i = 0; i < reps; ++i) {
            result ^= hashFunction.hashBytes(this.testBytes, 1, this.testBytes.length - 1).asBytes()[0];
        }
        return result;
    }
}

