/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.hash.HashFunctionEnum;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public class HashStringBenchmark {
    @Param(value={"0x80", "0x90", "0x100", "0x800", "0x10000", "0x10ffff"})
    MaxCodePoint maxCodePoint;
    @Param(value={"16384"})
    int charCount;
    @Param(value={"MURMUR3_32", "MURMUR3_128", "SHA1"})
    HashFunctionEnum hashFunctionEnum;
    private String[] strings;
    static final int SAMPLES = 256;
    static final int SAMPLE_MASK = 255;

    @BeforeExperiment
    void setUp() {
        long seed = 99L;
        Random rnd = new Random(99L);
        this.strings = new String[256];
        for (int i = 0; i < 256; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.charCount; ++j) {
                int codePoint;
                while (Character.isSurrogate((char)(codePoint = rnd.nextInt(this.maxCodePoint.value)))) {
                }
                sb.appendCodePoint(codePoint);
            }
            this.strings[i] = sb.toString();
        }
    }

    @Benchmark
    int hashUtf8(int reps) {
        int res = 0;
        for (int i = 0; i < reps; ++i) {
            res += System.identityHashCode(this.hashFunctionEnum.getHashFunction().hashString((CharSequence)this.strings[i & 0xFF], StandardCharsets.UTF_8));
        }
        return res;
    }

    @Benchmark
    int hashUtf8Hasher(int reps) {
        int res = 0;
        for (int i = 0; i < reps; ++i) {
            res += System.identityHashCode(this.hashFunctionEnum.getHashFunction().newHasher().putString((CharSequence)this.strings[i & 0xFF], StandardCharsets.UTF_8).hash());
        }
        return res;
    }

    @Benchmark
    int hashUtf8GetBytes(int reps) {
        int res = 0;
        for (int i = 0; i < reps; ++i) {
            res += System.identityHashCode(this.hashFunctionEnum.getHashFunction().hashBytes(this.strings[i & 0xFF].getBytes(StandardCharsets.UTF_8)));
        }
        return res;
    }

    @Benchmark
    int hashUtf8GetBytesHasher(int reps) {
        int res = 0;
        for (int i = 0; i < reps; ++i) {
            res += System.identityHashCode(this.hashFunctionEnum.getHashFunction().newHasher().putBytes(this.strings[i & 0xFF].getBytes(StandardCharsets.UTF_8)).hash());
        }
        return res;
    }

    static class MaxCodePoint {
        final int value;

        private static int decode(String userFriendly) {
            try {
                return Integer.decode(userFriendly);
            }
            catch (NumberFormatException ignored) {
                if (userFriendly.matches("(?i)(?:American|English|ASCII)")) {
                    return 128;
                }
                if (userFriendly.matches("(?i)(?:French|Latin|Western.*European)")) {
                    return 144;
                }
                if (userFriendly.matches("(?i)(?:Branch.*Prediction.*Hostile)")) {
                    return 256;
                }
                if (userFriendly.matches("(?i)(?:Greek|Cyrillic|European|ISO.?8859)")) {
                    return 2048;
                }
                if (userFriendly.matches("(?i)(?:Chinese|Han|Asian|BMP)")) {
                    return 65536;
                }
                if (userFriendly.matches("(?i)(?:Cuneiform|rare|exotic|supplementary.*)")) {
                    return 0x10FFFF;
                }
                throw new IllegalArgumentException("Can't decode codepoint " + userFriendly);
            }
        }

        public static MaxCodePoint valueOf(String userFriendly) {
            return new MaxCodePoint(userFriendly);
        }

        public MaxCodePoint(String userFriendly) {
            this.value = MaxCodePoint.decode(userFriendly);
        }
    }
}

