/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.common.testing.NullPointerTester;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class HashingOutputStreamTest
extends TestCase {
    private Hasher hasher;
    private HashFunction hashFunction;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    protected void setUp() throws Exception {
        super.setUp();
        this.hasher = (Hasher)Mockito.mock(Hasher.class);
        this.hashFunction = (HashFunction)Mockito.mock(HashFunction.class);
        Mockito.when((Object)this.hashFunction.newHasher()).thenReturn((Object)this.hasher);
    }

    public void testWrite_putSingleByte() throws Exception {
        int b = 113;
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(b);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        ((Hasher)Mockito.verify((Object)this.hasher)).putByte((byte)b);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testWrite_putByteArray() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(buf);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        ((Hasher)Mockito.verify((Object)this.hasher)).putBytes(buf, 0, buf.length);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testWrite_putByteArrayAtPos() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(buf, 0, 3);
        ((HashFunction)Mockito.verify((Object)this.hashFunction)).newHasher();
        ((Hasher)Mockito.verify((Object)this.hasher)).putBytes(buf, 0, 3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hashFunction, this.hasher});
    }

    public void testHash_hashesCorrectly() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        HashCode expectedHash = Hashing.md5().hashBytes(buf);
        HashingOutputStream out = new HashingOutputStream(Hashing.md5(), (OutputStream)this.buffer);
        out.write(buf);
        HashingOutputStreamTest.assertEquals((Object)expectedHash, (Object)out.hash());
    }

    public void testChecksForNull() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new HashingOutputStream(Hashing.md5(), (OutputStream)new ByteArrayOutputStream()));
        tester.testAllPublicStaticMethods(HashingOutputStream.class);
        tester.testAllPublicConstructors(HashingOutputStream.class);
    }
}

