/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class MessageDigestAlgorithmBenchmark {
    @Param(value={"10", "1000", "100000", "1000000"})
    int size;
    @Param
    Algorithm algorithm;
    @Param
    HashMethod hashMethod;
    private static final int RANDOM_SEED = new Random().nextInt();
    private byte[] testBytes;

    @BeforeExperiment
    void setUp() {
        this.testBytes = new byte[this.size];
        new Random(RANDOM_SEED).nextBytes(this.testBytes);
    }

    @Benchmark
    byte hashing(int reps) {
        byte result = 1;
        HashMethod hashMethod = this.hashMethod;
        Algorithm algorithm = this.algorithm;
        for (int i = 0; i < reps; ++i) {
            result = (byte)(result ^ hashMethod.hash(algorithm, this.testBytes)[0]);
        }
        return result;
    }

    private static enum Algorithm {
        MD5("MD5", Hashing.md5()),
        SHA_1("SHA-1", Hashing.sha1()),
        SHA_256("SHA-256", Hashing.sha256()),
        SHA_384("SHA-384", Hashing.sha384()),
        SHA_512("SHA-512", Hashing.sha512());

        private final String algorithmName;
        private final HashFunction hashFn;

        private Algorithm(String algorithmName, HashFunction hashFn) {
            this.algorithmName = algorithmName;
            this.hashFn = hashFn;
        }

        public MessageDigest getMessageDigest() {
            try {
                return MessageDigest.getInstance(this.algorithmName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }

        public HashFunction getHashFunction() {
            return this.hashFn;
        }
    }

    private static enum HashMethod {
        MESSAGE_DIGEST_API{

            @Override
            public byte[] hash(Algorithm algorithm, byte[] input) {
                MessageDigest md = algorithm.getMessageDigest();
                md.update(input);
                return md.digest();
            }
        }
        ,
        HASH_FUNCTION_DIRECT{

            @Override
            public byte[] hash(Algorithm algorithm, byte[] input) {
                return algorithm.getHashFunction().hashBytes(input).asBytes();
            }
        }
        ,
        HASH_FUNCTION_VIA_HASHER{

            @Override
            public byte[] hash(Algorithm algorithm, byte[] input) {
                return algorithm.getHashFunction().newHasher().putBytes(input).hash().asBytes();
            }
        };


        public abstract byte[] hash(Algorithm var1, byte[] var2);
    }
}

