/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.util.Random;
import junit.framework.TestCase;

public class Murmur3Hash32Test
extends TestCase {
    public void testKnownIntegerInputs() {
        Murmur3Hash32Test.assertHash(593689054, Hashing.murmur3_32().hashInt(0));
        Murmur3Hash32Test.assertHash(-189366624, Hashing.murmur3_32().hashInt(-42));
        Murmur3Hash32Test.assertHash(-1134849565, Hashing.murmur3_32().hashInt(42));
        Murmur3Hash32Test.assertHash(-1718298732, Hashing.murmur3_32().hashInt(Integer.MIN_VALUE));
        Murmur3Hash32Test.assertHash(-1653689534, Hashing.murmur3_32().hashInt(Integer.MAX_VALUE));
    }

    public void testKnownLongInputs() {
        Murmur3Hash32Test.assertHash(1669671676, Hashing.murmur3_32().hashLong(0L));
        Murmur3Hash32Test.assertHash(-846261623, Hashing.murmur3_32().hashLong(-42L));
        Murmur3Hash32Test.assertHash(1871679806, Hashing.murmur3_32().hashLong(42L));
        Murmur3Hash32Test.assertHash(1366273829, Hashing.murmur3_32().hashLong(Long.MIN_VALUE));
        Murmur3Hash32Test.assertHash(-2106506049, Hashing.murmur3_32().hashLong(Long.MAX_VALUE));
    }

    public void testKnownStringInputs() {
        Murmur3Hash32Test.assertHash(0, Hashing.murmur3_32().hashUnencodedChars((CharSequence)""));
        Murmur3Hash32Test.assertHash(679745764, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"k"));
        Murmur3Hash32Test.assertHash(1510782915, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"hell"));
        Murmur3Hash32Test.assertHash(-675079799, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"hello"));
        Murmur3Hash32Test.assertHash(1935035788, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"http://www.google.com/"));
        Murmur3Hash32Test.assertHash(-528633700, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"The quick brown fox jumps over the lazy dog"));
    }

    public void testSimpleStringUtf8() {
        Murmur3Hash32Test.assertEquals((Object)Hashing.murmur3_32().hashBytes("ABCDefGHI\u0799".getBytes(Charsets.UTF_8)), (Object)Hashing.murmur3_32().hashString((CharSequence)"ABCDefGHI\u0799", Charsets.UTF_8));
    }

    public void testStringInputsUtf8() {
        Random rng = new Random(0L);
        for (int z = 0; z < 100; ++z) {
            int[] codePoints = new int[rng.nextInt(8)];
            for (int i = 0; i < codePoints.length; ++i) {
                do {
                    codePoints[i] = rng.nextInt(2048);
                } while (!Character.isValidCodePoint(codePoints[i]) || codePoints[i] >= 55296 && codePoints[i] <= 57343);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < codePoints.length; ++i) {
                builder.appendCodePoint(codePoints[i]);
            }
            String str = builder.toString();
            Murmur3Hash32Test.assertEquals((Object)Hashing.murmur3_32().hashBytes(str.getBytes(Charsets.UTF_8)), (Object)Hashing.murmur3_32().hashString((CharSequence)str, Charsets.UTF_8));
        }
    }

    private static void assertHash(int expected, HashCode actual) {
        Murmur3Hash32Test.assertEquals((Object)HashCode.fromInt((int)expected), (Object)actual);
    }

    public void testParanoidHashBytes() {
        HashTestUtils.HashFn hf = new HashTestUtils.HashFn(){

            @Override
            public byte[] hash(byte[] input, int seed) {
                return Hashing.murmur3_32((int)seed).hashBytes(input).asBytes();
            }
        };
        HashTestUtils.verifyHashFunction(hf, 32, -1326088477);
    }

    public void testParanoid() {
        HashTestUtils.HashFn hf = new HashTestUtils.HashFn(){

            @Override
            public byte[] hash(byte[] input, int seed) {
                Hasher hasher = Hashing.murmur3_32((int)seed).newHasher();
                Funnels.byteArrayFunnel().funnel((Object)input, (PrimitiveSink)hasher);
                return hasher.hash().asBytes();
            }
        };
        HashTestUtils.verifyHashFunction(hf, 32, -1326088477);
    }

    public void testInvariants() {
        HashTestUtils.assertInvariants(Hashing.murmur3_32());
    }

    public void testInvalidUnicodeHashString() {
        String str = new String(new char[]{'a', '\ud800', '\ud800', 'z'});
        Murmur3Hash32Test.assertEquals((Object)Hashing.murmur3_32().hashBytes(str.getBytes(Charsets.UTF_8)), (Object)Hashing.murmur3_32().hashString((CharSequence)str, Charsets.UTF_8));
    }

    public void testInvalidUnicodeHasherPutString() {
        String str = new String(new char[]{'a', '\ud800', '\ud800', 'z'});
        Murmur3Hash32Test.assertEquals((Object)Hashing.murmur3_32().hashBytes(str.getBytes(Charsets.UTF_8)), (Object)Hashing.murmur3_32().newHasher().putString((CharSequence)str, Charsets.UTF_8).hash());
    }
}

