/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.AppendableWriter;
import com.google.common.io.IoTestCase;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public class AppendableWriterTest
extends IoTestCase {
    public void testWriteMethods() throws IOException {
        StringBuilder builder = new StringBuilder();
        AppendableWriter writer = new AppendableWriter((Appendable)builder);
        writer.write("Hello".toCharArray());
        writer.write(44);
        writer.write(-1091633120);
        writer.write("Wo");
        writer.write("Whirled".toCharArray(), 3, 2);
        writer.write("Mad! Mad, I say", 2, 2);
        AppendableWriterTest.assertEquals((String)"Hello, World!", (String)builder.toString());
    }

    public void testAppendMethods() throws IOException {
        StringBuilder builder = new StringBuilder();
        AppendableWriter writer = new AppendableWriter((Appendable)builder);
        writer.append("Hello,");
        writer.append(' ');
        writer.append("The World Wide Web", 4, 9);
        writer.append("!");
        AppendableWriterTest.assertEquals((String)"Hello, World!", (String)builder.toString());
    }

    public void testCloseFlush() throws IOException {
        SpyAppendable spy = new SpyAppendable();
        AppendableWriter writer = new AppendableWriter((Appendable)spy);
        writer.write("Hello");
        AppendableWriterTest.assertFalse((boolean)spy.flushed);
        AppendableWriterTest.assertFalse((boolean)spy.closed);
        writer.flush();
        AppendableWriterTest.assertTrue((boolean)spy.flushed);
        AppendableWriterTest.assertFalse((boolean)spy.closed);
        writer.close();
        AppendableWriterTest.assertTrue((boolean)spy.flushed);
        AppendableWriterTest.assertTrue((boolean)spy.closed);
    }

    public void testCloseIsFinal() throws IOException {
        StringBuilder builder = new StringBuilder();
        AppendableWriter writer = new AppendableWriter((Appendable)builder);
        writer.write("Hi");
        writer.close();
        try {
            writer.write(" Greg");
            AppendableWriterTest.fail((String)"Should have thrown IOException due to writer already closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            writer.flush();
            AppendableWriterTest.fail((String)"Should have thrown IOException due to writer already closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.close();
    }

    private static class SpyAppendable
    implements Appendable,
    Flushable,
    Closeable {
        boolean flushed;
        boolean closed;
        StringBuilder result = new StringBuilder();

        private SpyAppendable() {
        }

        @Override
        public Appendable append(CharSequence csq) {
            this.result.append(csq);
            return this;
        }

        @Override
        public Appendable append(char c) {
            this.result.append(c);
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            this.result.append(csq, start, end);
            return this;
        }

        @Override
        public void flush() {
            this.flushed = true;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

