/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;

public class BaseEncodingBenchmark {
    private static final int INPUTS_COUNT = 4096;
    private static final int INPUTS_MASK = 4095;
    @Param
    EncodingOption encoding;
    @Param(value={"10", "100", "10000"})
    int n;
    private final byte[][] encodingInputs = new byte[4096][];
    private final String[] decodingInputs = new String[4096];

    @BeforeExperiment
    public void setUp() {
        Random rng = new Random();
        for (int i = 0; i < this.encodingInputs.length; ++i) {
            this.encodingInputs[i] = new byte[this.n];
            rng.nextBytes(this.encodingInputs[i]);
            this.decodingInputs[i] = this.encoding.encoding.encode(this.encodingInputs[i]);
        }
    }

    @Benchmark
    public int encode(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            tmp += System.identityHashCode(this.encoding.encoding.encode(this.encodingInputs[i & 0xFFF]));
        }
        return tmp;
    }

    @Benchmark
    public int decode(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            tmp += System.identityHashCode(this.encoding.encoding.decode((CharSequence)this.decodingInputs[i & 0xFFF]));
        }
        return tmp;
    }

    @Benchmark
    public int encodingStream(int reps) throws IOException {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            StringWriter target = new StringWriter(2 * this.n);
            OutputStream encodingStream = this.encoding.encoding.encodingStream((Writer)target);
            encodingStream.write(this.encodingInputs[i & 0xFFF]);
            encodingStream.close();
            tmp += target.getBuffer().length();
        }
        return tmp;
    }

    @Benchmark
    public int decodingStream(int reps) throws IOException {
        int tmp = 0;
        byte[] target = new byte[this.n];
        for (int i = 0; i < reps; ++i) {
            StringReader source = new StringReader(this.decodingInputs[i & 0xFFF]);
            InputStream decodingStream = this.encoding.encoding.decodingStream((Reader)source);
            decodingStream.read(target);
            decodingStream.close();
            tmp += target[0];
        }
        return tmp;
    }

    static enum EncodingOption {
        BASE64(BaseEncoding.base64()),
        BASE64_URL(BaseEncoding.base64Url()),
        BASE32(BaseEncoding.base32()),
        BASE32_HEX(BaseEncoding.base32Hex()),
        BASE16(BaseEncoding.base16());

        final BaseEncoding encoding;

        private EncodingOption(BaseEncoding encoding) {
            this.encoding = encoding;
        }
    }
}

