/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nullable;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class BaseEncodingTest
extends TestCase {
    public void testSeparatorsExplicitly() {
        BaseEncodingTest.testEncodes(BaseEncoding.base64().withSeparator("\n", 3), "foobar", "Zm9\nvYm\nFy");
        BaseEncodingTest.testEncodes(BaseEncoding.base64().withSeparator("$", 4), "foobar", "Zm9v$YmFy");
        BaseEncodingTest.testEncodes(BaseEncoding.base32().withSeparator("*", 4), "foobar", "MZXW*6YTB*OI==*====");
    }

    public void testSeparatorSameAsPadChar() {
        try {
            BaseEncoding.base64().withSeparator("=", 3);
            BaseEncodingTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            BaseEncoding.base64().withPadChar('#').withSeparator("!#!", 3);
            BaseEncodingTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAtMostOneSeparator() {
        BaseEncoding separated = BaseEncoding.base64().withSeparator("\n", 3);
        try {
            separated.withSeparator("$", 4);
            BaseEncodingTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBase64() {
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "", "");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "f", "Zg==");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "fo", "Zm8=");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "foo", "Zm9v");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "foob", "Zm9vYg==");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "fooba", "Zm9vYmE=");
        BaseEncodingTest.testEncodingWithSeparators(BaseEncoding.base64(), "foobar", "Zm9vYmFy");
    }

    @GwtIncompatible
    public void testBase64Streaming() throws IOException {
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "", "");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "f", "Zg==");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "fo", "Zm8=");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "foo", "Zm9v");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "foob", "Zm9vYg==");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "fooba", "Zm9vYmE=");
        BaseEncodingTest.testStreamingEncodingWithSeparators(BaseEncoding.base64(), "foobar", "Zm9vYmFy");
    }

    public void testBase64LenientPadding() {
        BaseEncodingTest.testDecodes(BaseEncoding.base64(), "Zg", "f");
        BaseEncodingTest.testDecodes(BaseEncoding.base64(), "Zg=", "f");
        BaseEncodingTest.testDecodes(BaseEncoding.base64(), "Zg==", "f");
        BaseEncodingTest.testDecodes(BaseEncoding.base64(), "Zg===", "f");
        BaseEncodingTest.testDecodes(BaseEncoding.base64(), "Zg====", "f");
    }

    public void testBase64InvalidDecodings() {
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "A\u007f", "Unrecognized character: 0x7f");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "Wf2!", "Unrecognized character: !");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "let's not talk of love or chains!");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "12345", "Invalid input length 5");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "AB=C", "Unrecognized character: =");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "A=BCD", "Invalid input length 5");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base64(), "?", "Invalid input length 1");
    }

    public void testBase64CannotUpperCase() {
        try {
            BaseEncoding.base64().upperCase();
            BaseEncodingTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBase64CannotLowerCase() {
        try {
            BaseEncoding.base64().lowerCase();
            BaseEncodingTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBase64AlternatePadding() {
        BaseEncoding enc = BaseEncoding.base64().withPadChar('~');
        BaseEncodingTest.testEncodingWithSeparators(enc, "", "");
        BaseEncodingTest.testEncodingWithSeparators(enc, "f", "Zg~~");
        BaseEncodingTest.testEncodingWithSeparators(enc, "fo", "Zm8~");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foo", "Zm9v");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foob", "Zm9vYg~~");
        BaseEncodingTest.testEncodingWithSeparators(enc, "fooba", "Zm9vYmE~");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foobar", "Zm9vYmFy");
    }

    @GwtIncompatible
    public void testBase64StreamingAlternatePadding() throws IOException {
        BaseEncoding enc = BaseEncoding.base64().withPadChar('~');
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "", "");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "f", "Zg~~");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "fo", "Zm8~");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foo", "Zm9v");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foob", "Zm9vYg~~");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "fooba", "Zm9vYmE~");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foobar", "Zm9vYmFy");
    }

    public void testBase64OmitPadding() {
        BaseEncoding enc = BaseEncoding.base64().omitPadding();
        BaseEncodingTest.testEncodingWithSeparators(enc, "", "");
        BaseEncodingTest.testEncodingWithSeparators(enc, "f", "Zg");
        BaseEncodingTest.testEncodingWithSeparators(enc, "fo", "Zm8");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foo", "Zm9v");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foob", "Zm9vYg");
        BaseEncodingTest.testEncodingWithSeparators(enc, "fooba", "Zm9vYmE");
        BaseEncodingTest.testEncodingWithSeparators(enc, "foobar", "Zm9vYmFy");
    }

    @GwtIncompatible
    public void testBase64StreamingOmitPadding() throws IOException {
        BaseEncoding enc = BaseEncoding.base64().omitPadding();
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "", "");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "f", "Zg");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "fo", "Zm8");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foo", "Zm9v");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foob", "Zm9vYg");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "fooba", "Zm9vYmE");
        BaseEncodingTest.testStreamingEncodingWithSeparators(enc, "foobar", "Zm9vYmFy");
    }

    public void testBase64Offset() {
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base64(), "foobar", 0, 6, "Zm9vYmFy");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base64(), "foobar", 1, 5, "b29iYXI=");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base64(), "foobar", 2, 3, "b2Jh");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base64(), "foobar", 3, 1, "Yg==");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base64(), "foobar", 4, 0, "");
    }

    public void testBase32() {
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "", "");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "f", "MY======");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "fo", "MZXQ====");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "foo", "MZXW6===");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "foob", "MZXW6YQ=");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "fooba", "MZXW6YTB");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32(), "foobar", "MZXW6YTBOI======");
    }

    @GwtIncompatible
    public void testBase32Streaming() throws IOException {
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "", "");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "f", "MY======");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "fo", "MZXQ====");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "foo", "MZXW6===");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "foob", "MZXW6YQ=");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "fooba", "MZXW6YTB");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32(), "foobar", "MZXW6YTBOI======");
    }

    public void testBase32LenientPadding() {
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6=", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6==", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6===", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6====", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32(), "MZXW6=====", "foo");
    }

    public void testBase32AlternatePadding() {
        BaseEncoding enc = BaseEncoding.base32().withPadChar('~');
        BaseEncodingTest.testEncodingWithCasing(enc, "", "");
        BaseEncodingTest.testEncodingWithCasing(enc, "f", "MY~~~~~~");
        BaseEncodingTest.testEncodingWithCasing(enc, "fo", "MZXQ~~~~");
        BaseEncodingTest.testEncodingWithCasing(enc, "foo", "MZXW6~~~");
        BaseEncodingTest.testEncodingWithCasing(enc, "foob", "MZXW6YQ~");
        BaseEncodingTest.testEncodingWithCasing(enc, "fooba", "MZXW6YTB");
        BaseEncodingTest.testEncodingWithCasing(enc, "foobar", "MZXW6YTBOI~~~~~~");
    }

    public void testBase32InvalidDecodings() {
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "A ", "Unrecognized character: 0x20");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "Wf2!", "Unrecognized character: f");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "let's not talk of love or chains!");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "A", "Invalid input length 1");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "ABC");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "ABCDEF");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "AB=C", "Unrecognized character: =");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "A=BCDE", "Invalid input length 6");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32(), "?", "Invalid input length 1");
    }

    public void testBase32UpperCaseIsNoOp() {
        BaseEncodingTest.assertSame((Object)BaseEncoding.base32(), (Object)BaseEncoding.base32().upperCase());
    }

    public void testBase32Offset() {
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base32(), "foobar", 0, 6, "MZXW6YTBOI======");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base32(), "foobar", 1, 5, "N5XWEYLS");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base32(), "foobar", 2, 3, "N5RGC===");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base32(), "foobar", 3, 1, "MI======");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base32(), "foobar", 4, 0, "");
    }

    public void testBase32Hex() {
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "", "");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "f", "CO======");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "fo", "CPNG====");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "foo", "CPNMU===");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "foob", "CPNMUOG=");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "fooba", "CPNMUOJ1");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base32Hex(), "foobar", "CPNMUOJ1E8======");
    }

    @GwtIncompatible
    public void testBase32HexStreaming() throws IOException {
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "", "");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "f", "CO======");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "fo", "CPNG====");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "foo", "CPNMU===");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "foob", "CPNMUOG=");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "fooba", "CPNMUOJ1");
        BaseEncodingTest.testStreamingEncodingWithCasing(BaseEncoding.base32Hex(), "foobar", "CPNMUOJ1E8======");
    }

    public void testBase32HexLenientPadding() {
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU=", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU==", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU===", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU====", "foo");
        BaseEncodingTest.testDecodes(BaseEncoding.base32Hex(), "CPNMU=====", "foo");
    }

    public void testBase32HexInvalidDecodings() {
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "A\u007f", "Unrecognized character: 0x7f");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "Wf2!", "Unrecognized character: W");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "let's not talk of love or chains!");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "A");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "ABC");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base32Hex(), "ABCDEF");
    }

    public void testBase32HexUpperCaseIsNoOp() {
        BaseEncodingTest.assertSame((Object)BaseEncoding.base32Hex(), (Object)BaseEncoding.base32Hex().upperCase());
    }

    public void testBase16() {
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "", "");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "f", "66");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "fo", "666F");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "foo", "666F6F");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "foob", "666F6F62");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "fooba", "666F6F6261");
        BaseEncodingTest.testEncodingWithCasing(BaseEncoding.base16(), "foobar", "666F6F626172");
    }

    public void testBase16UpperCaseIsNoOp() {
        BaseEncodingTest.assertSame((Object)BaseEncoding.base16(), (Object)BaseEncoding.base16().upperCase());
    }

    public void testBase16InvalidDecodings() {
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base16(), "\n\n", "Unrecognized character: 0xa");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base16(), "EFGH", "Unrecognized character: G");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base16(), "A", "Invalid input length 1");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base16(), "ABC");
        BaseEncodingTest.assertFailsToDecode(BaseEncoding.base16(), "?", "Invalid input length 1");
    }

    public void testBase16Offset() {
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base16(), "foobar", 0, 6, "666F6F626172");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base16(), "foobar", 1, 5, "6F6F626172");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base16(), "foobar", 2, 3, "6F6261");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base16(), "foobar", 3, 1, "62");
        BaseEncodingTest.testEncodesWithOffset(BaseEncoding.base16(), "foobar", 4, 0, "");
    }

    private static void testEncodingWithCasing(BaseEncoding encoding, String decoded, String encoded) {
        BaseEncodingTest.testEncodingWithSeparators(encoding, decoded, encoded);
        BaseEncodingTest.testEncodingWithSeparators(encoding.upperCase(), decoded, Ascii.toUpperCase((String)encoded));
        BaseEncodingTest.testEncodingWithSeparators(encoding.lowerCase(), decoded, Ascii.toLowerCase((String)encoded));
    }

    private static void testEncodingWithSeparators(BaseEncoding encoding, String decoded, String encoded) {
        BaseEncodingTest.testEncoding(encoding, decoded, encoded);
        for (int sepLength = 3; sepLength <= 5; ++sepLength) {
            for (String separator : ImmutableList.of((Object)",", (Object)"\n", (Object)";;", (Object)"")) {
                BaseEncodingTest.testEncoding(encoding.withSeparator(separator, sepLength), decoded, Joiner.on((String)separator).join(Splitter.fixedLength((int)sepLength).split((CharSequence)encoded)));
            }
        }
    }

    private static void testEncoding(BaseEncoding encoding, String decoded, String encoded) {
        BaseEncodingTest.testEncodes(encoding, decoded, encoded);
        BaseEncodingTest.testDecodes(encoding, encoded, decoded);
    }

    private static void testEncodes(BaseEncoding encoding, String decoded, String encoded) {
        Truth.assertThat((String)encoding.encode(decoded.getBytes(Charsets.UTF_8))).isEqualTo((Object)encoded);
    }

    private static void testEncodesWithOffset(BaseEncoding encoding, String decoded, int offset, int len, String encoded) {
        Truth.assertThat((String)encoding.encode(decoded.getBytes(Charsets.UTF_8), offset, len)).isEqualTo((Object)encoded);
    }

    private static void testDecodes(BaseEncoding encoding, String encoded, String decoded) {
        BaseEncodingTest.assertTrue((boolean)encoding.canDecode((CharSequence)encoded));
        Truth.assertThat((byte[])encoding.decode((CharSequence)encoded)).isEqualTo((Object)decoded.getBytes(Charsets.UTF_8));
    }

    private static void assertFailsToDecode(BaseEncoding encoding, String cannotDecode) {
        BaseEncodingTest.assertFailsToDecode(encoding, cannotDecode, null);
    }

    private static void assertFailsToDecode(BaseEncoding encoding, String cannotDecode, @Nullable String expectedMessage) {
        block5: {
            block4: {
                BaseEncodingTest.assertFalse((boolean)encoding.canDecode((CharSequence)cannotDecode));
                try {
                    encoding.decode((CharSequence)cannotDecode);
                    BaseEncodingTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException expected) {
                    if (expectedMessage == null) break block4;
                    Truth.assertThat((Throwable)expected.getCause()).hasMessage(expectedMessage);
                }
            }
            try {
                encoding.decodeChecked((CharSequence)cannotDecode);
                BaseEncodingTest.fail((String)"Expected DecodingException");
            }
            catch (BaseEncoding.DecodingException expected) {
                if (expectedMessage == null) break block5;
                Truth.assertThat((Throwable)expected).hasMessage(expectedMessage);
            }
        }
    }

    @GwtIncompatible
    private static void testStreamingEncodingWithCasing(BaseEncoding encoding, String decoded, String encoded) throws IOException {
        BaseEncodingTest.testStreamingEncodingWithSeparators(encoding, decoded, encoded);
        BaseEncodingTest.testStreamingEncodingWithSeparators(encoding.upperCase(), decoded, Ascii.toUpperCase((String)encoded));
        BaseEncodingTest.testStreamingEncodingWithSeparators(encoding.lowerCase(), decoded, Ascii.toLowerCase((String)encoded));
    }

    @GwtIncompatible
    private static void testStreamingEncodingWithSeparators(BaseEncoding encoding, String decoded, String encoded) throws IOException {
        BaseEncodingTest.testStreamingEncoding(encoding, decoded, encoded);
        for (int sepLength = 3; sepLength <= 5; ++sepLength) {
            for (String separator : ImmutableList.of((Object)",", (Object)"\n", (Object)";;", (Object)"")) {
                BaseEncodingTest.testStreamingEncoding(encoding.withSeparator(separator, sepLength), decoded, Joiner.on((String)separator).join(Splitter.fixedLength((int)sepLength).split((CharSequence)encoded)));
            }
        }
    }

    @GwtIncompatible
    private static void testStreamingEncoding(BaseEncoding encoding, String decoded, String encoded) throws IOException {
        BaseEncodingTest.testStreamingEncodes(encoding, decoded, encoded);
        BaseEncodingTest.testStreamingDecodes(encoding, encoded, decoded);
    }

    @GwtIncompatible
    private static void testStreamingEncodes(BaseEncoding encoding, String decoded, String encoded) throws IOException {
        StringWriter writer = new StringWriter();
        OutputStream encodingStream = encoding.encodingStream((Writer)writer);
        encodingStream.write(decoded.getBytes(Charsets.UTF_8));
        encodingStream.close();
        Truth.assertThat((String)writer.toString()).isEqualTo((Object)encoded);
    }

    @GwtIncompatible
    private static void testStreamingDecodes(BaseEncoding encoding, String encoded, String decoded) throws IOException {
        byte[] bytes = decoded.getBytes(Charsets.UTF_8);
        InputStream decodingStream = encoding.decodingStream((Reader)new StringReader(encoded));
        for (int i = 0; i < bytes.length; ++i) {
            Truth.assertThat((Integer)decodingStream.read()).isEqualTo((Object)(bytes[i] & 0xFF));
        }
        Truth.assertThat((Integer)decodingStream.read()).isEqualTo((Object)-1);
        decodingStream.close();
    }

    public void testToString() {
        BaseEncodingTest.assertEquals((String)"BaseEncoding.base64().withPadChar('=')", (String)BaseEncoding.base64().toString());
        BaseEncodingTest.assertEquals((String)"BaseEncoding.base32Hex().omitPadding()", (String)BaseEncoding.base32Hex().omitPadding().toString());
        BaseEncodingTest.assertEquals((String)"BaseEncoding.base32().lowerCase().withPadChar('$')", (String)BaseEncoding.base32().lowerCase().withPadChar('$').toString());
        BaseEncodingTest.assertEquals((String)"BaseEncoding.base16().withSeparator(\"\n\", 10)", (String)BaseEncoding.base16().withSeparator("\n", 10).toString());
    }
}

