/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.IoTestCase;
import com.google.common.io.TestByteSink;
import com.google.common.io.TestByteSource;
import com.google.common.io.TestInputStream;
import com.google.common.io.TestOption;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.junit.Assert;

public class ByteSinkTest
extends IoTestCase {
    private final byte[] bytes = ByteSinkTest.newPreFilledByteArray(10000);
    private TestByteSink sink;

    protected void setUp() throws Exception {
        this.sink = new TestByteSink(new TestOption[0]);
    }

    public void testOpenBufferedStream() throws IOException {
        OutputStream out = this.sink.openBufferedStream();
        ByteSinkTest.assertTrue((boolean)this.sink.wasStreamOpened());
        ByteSinkTest.assertFalse((boolean)this.sink.wasStreamClosed());
        out.write(new byte[]{1, 2, 3, 4});
        out.close();
        ByteSinkTest.assertTrue((boolean)this.sink.wasStreamClosed());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])this.sink.getBytes());
    }

    public void testWrite_bytes() throws IOException {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])this.sink.getBytes());
        this.sink.write(this.bytes);
        ByteSinkTest.assertTrue((this.sink.wasStreamOpened() && this.sink.wasStreamClosed() ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])this.bytes, (byte[])this.sink.getBytes());
    }

    public void testWriteFrom_inputStream() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.bytes);
        this.sink.writeFrom(in);
        ByteSinkTest.assertTrue((this.sink.wasStreamOpened() && this.sink.wasStreamClosed() ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])this.bytes, (byte[])this.sink.getBytes());
    }

    public void testWriteFromStream_doesNotCloseThatStream() throws IOException {
        TestInputStream in = new TestInputStream((InputStream)new ByteArrayInputStream(new byte[10]), new TestOption[0]);
        ByteSinkTest.assertFalse((boolean)in.closed());
        this.sink.writeFrom(in);
        ByteSinkTest.assertFalse((boolean)in.closed());
    }

    public void testClosesOnErrors_copyingFromByteSourceThatThrows() {
        for (TestOption option : EnumSet.of(TestOption.OPEN_THROWS, TestOption.READ_THROWS, TestOption.CLOSE_THROWS)) {
            TestByteSource failSource = new TestByteSource(new byte[10], option);
            TestByteSink okSink = new TestByteSink(new TestOption[0]);
            try {
                failSource.copyTo(okSink);
                ByteSinkTest.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ByteSinkTest.assertTrue((String)("stream not closed when copying from source with option: " + (Object)((Object)option)), (!okSink.wasStreamOpened() || okSink.wasStreamClosed() ? 1 : 0) != 0);
        }
    }

    public void testClosesOnErrors_whenWriteThrows() {
        TestByteSink failSink = new TestByteSink(TestOption.WRITE_THROWS);
        try {
            new TestByteSource(new byte[10], new TestOption[0]).copyTo(failSink);
            ByteSinkTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteSinkTest.assertTrue((boolean)failSink.wasStreamClosed());
    }

    public void testClosesOnErrors_writingFromInputStreamThatThrows() {
        TestByteSink okSink = new TestByteSink(new TestOption[0]);
        try {
            TestInputStream in = new TestInputStream((InputStream)new ByteArrayInputStream(new byte[10]), TestOption.READ_THROWS);
            okSink.writeFrom(in);
            ByteSinkTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteSinkTest.assertTrue((boolean)okSink.wasStreamClosed());
    }
}

