/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.VmOptions;
import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Random;

@VmOptions(value={"-Xms12g", "-Xmx12g", "-d64"})
public class ByteSourceAsCharSourceReadBenchmark {
    @Param(value={"UTF-8"})
    String charsetName;
    @Param
    ReadStrategy strategy;
    @Param(value={"10", "1024", "1048576"})
    int size;
    Charset charset;
    ByteSource data;

    @BeforeExperiment
    public void setUp() {
        this.charset = Charset.forName(this.charsetName);
        StringBuilder sb = new StringBuilder();
        Random random = new Random(-559038737L);
        sb.ensureCapacity(this.size);
        for (int k = 0; k < this.size; ++k) {
            sb.append((char)(random.nextInt(118) + 9));
        }
        String string = sb.toString();
        sb.setLength(0);
        this.data = ByteSource.wrap((byte[])string.getBytes(this.charset));
    }

    @Benchmark
    public int timeCopy(int reps) throws IOException {
        int r = 0;
        Charset localCharset = this.charset;
        ByteSource localData = this.data;
        ReadStrategy localStrategy = this.strategy;
        for (int i = 0; i < reps; ++i) {
            r += localStrategy.read(localData, localCharset).hashCode();
        }
        return r;
    }

    static enum ReadStrategy {
        TO_BYTE_ARRAY_NEW_STRING{

            @Override
            String read(ByteSource byteSource, Charset cs) throws IOException {
                return new String(byteSource.read(), cs);
            }
        }
        ,
        USING_CHARSTREAMS_COPY{

            @Override
            String read(ByteSource byteSource, Charset cs) throws IOException {
                StringBuilder sb = new StringBuilder();
                try (InputStreamReader reader = new InputStreamReader(byteSource.openStream(), cs);){
                    CharStreams.copy((Readable)reader, (Appendable)sb);
                }
                return sb.toString();
            }
        }
        ,
        USING_DECODER_WITH_SIZE_HINT{

            @Override
            String read(ByteSource byteSource, Charset cs) throws IOException {
                Optional size = byteSource.sizeIfKnown();
                if (size.isPresent() && (Long)size.get() == (long)((Long)size.get()).intValue()) {
                    int maxChars = (int)((float)((Long)size.get()).intValue() * cs.newDecoder().maxCharsPerByte());
                    char[] buffer = new char[maxChars];
                    int bufIndex = 0;
                    try (InputStreamReader reader = new InputStreamReader(byteSource.openStream(), cs);){
                        int nRead = 0;
                        for (int remaining = buffer.length; remaining > 0 && (nRead = reader.read(buffer, bufIndex, remaining)) != -1; remaining -= nRead) {
                            bufIndex += nRead;
                        }
                        if (nRead == -1) {
                            String string = new String(buffer, 0, bufIndex);
                            return string;
                        }
                        StringBuilder builder = new StringBuilder(bufIndex + 32);
                        builder.append(buffer, 0, bufIndex);
                        buffer = null;
                        CharStreams.copy((Readable)reader, (Appendable)builder);
                        String string = builder.toString();
                        return string;
                    }
                }
                return TO_BYTE_ARRAY_NEW_STRING.read(byteSource, cs);
            }
        };


        abstract String read(ByteSource var1, Charset var2) throws IOException;
    }
}

