/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.CharSequenceReader;
import java.io.IOException;
import java.nio.CharBuffer;
import junit.framework.TestCase;

public class CharSequenceReaderTest
extends TestCase {
    public void testReadEmptyString() throws IOException {
        CharSequenceReaderTest.assertReadsCorrectly("");
    }

    public void testReadsStringsCorrectly() throws IOException {
        CharSequenceReaderTest.assertReadsCorrectly("abc");
        CharSequenceReaderTest.assertReadsCorrectly("abcde");
        CharSequenceReaderTest.assertReadsCorrectly("abcdefghijkl");
        CharSequenceReaderTest.assertReadsCorrectly("abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\r0123456789\r\n!@#$%^&*()-=_+\t[]{};':\",./<>?\\| ");
    }

    public void testMarkAndReset() throws IOException {
        String string = "abcdefghijklmnopqrstuvwxyz";
        CharSequenceReader reader = new CharSequenceReader((CharSequence)string);
        CharSequenceReaderTest.assertTrue((boolean)reader.markSupported());
        CharSequenceReaderTest.assertEquals((String)string, (String)CharSequenceReaderTest.readFully(reader));
        CharSequenceReaderTest.assertFullyRead(reader);
        reader.reset();
        CharSequenceReaderTest.assertEquals((String)string, (String)CharSequenceReaderTest.readFully(reader));
        CharSequenceReaderTest.assertFullyRead(reader);
        reader.reset();
        CharSequenceReaderTest.assertEquals((long)5L, (long)reader.skip(5L));
        reader.mark(Integer.MAX_VALUE);
        CharSequenceReaderTest.assertEquals((String)string.substring(5), (String)CharSequenceReaderTest.readFully(reader));
        CharSequenceReaderTest.assertFullyRead(reader);
        reader.reset();
        CharSequenceReaderTest.assertEquals((String)string.substring(5), (String)CharSequenceReaderTest.readFully(reader));
        CharSequenceReaderTest.assertFullyRead(reader);
    }

    public void testIllegalArguments() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"12345");
        char[] buf = new char[10];
        try {
            reader.read(buf, 0, 11);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(buf, 10, 1);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(buf, 11, 0);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(buf, -1, 5);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(buf, 5, -1);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.read(buf, 0, 11);
            CharSequenceReaderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            reader.skip(-1L);
            CharSequenceReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            reader.mark(-1);
            CharSequenceReaderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMethodsThrowWhenClosed() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"");
        reader.close();
        try {
            reader.read();
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.read(new char[10]);
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.read(new char[10], 0, 10);
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.read(CharBuffer.allocate(10));
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.skip(10L);
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.ready();
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.mark(10);
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.reset();
            CharSequenceReaderTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void assertReadsCorrectly(CharSequence charSequence) throws IOException {
        int read;
        String expected = charSequence.toString();
        CharSequenceReader reader = new CharSequenceReader(charSequence);
        for (int i = 0; i < expected.length(); ++i) {
            CharSequenceReaderTest.assertEquals((int)expected.charAt(i), (int)reader.read());
        }
        CharSequenceReaderTest.assertFullyRead(reader);
        reader = new CharSequenceReader(charSequence);
        char[] buf = new char[expected.length()];
        CharSequenceReaderTest.assertEquals((int)(expected.length() == 0 ? -1 : expected.length()), (int)reader.read(buf));
        CharSequenceReaderTest.assertEquals((String)expected, (String)new String(buf));
        CharSequenceReaderTest.assertFullyRead(reader);
        reader = new CharSequenceReader(charSequence);
        buf = new char[5];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buf, 0, buf.length)) != -1) {
            builder.append(buf, 0, read);
        }
        CharSequenceReaderTest.assertEquals((String)expected, (String)builder.toString());
        CharSequenceReaderTest.assertFullyRead(reader);
        reader = new CharSequenceReader(charSequence);
        CharBuffer buf2 = CharBuffer.allocate(expected.length());
        CharSequenceReaderTest.assertEquals((int)(expected.length() == 0 ? -1 : expected.length()), (int)reader.read(buf2));
        buf2.flip();
        CharSequenceReaderTest.assertEquals((String)expected, (String)buf2.toString());
        CharSequenceReaderTest.assertFullyRead(reader);
        reader = new CharSequenceReader(charSequence);
        buf2 = CharBuffer.allocate(5);
        builder = new StringBuilder();
        while (reader.read(buf2) != -1) {
            buf2.flip();
            builder.append(buf2);
            buf2.clear();
        }
        CharSequenceReaderTest.assertEquals((String)expected, (String)builder.toString());
        CharSequenceReaderTest.assertFullyRead(reader);
        reader = new CharSequenceReader(charSequence);
        CharSequenceReaderTest.assertEquals((long)expected.length(), (long)reader.skip(Long.MAX_VALUE));
        CharSequenceReaderTest.assertFullyRead(reader);
        if (expected.length() > 5) {
            reader = new CharSequenceReader(charSequence);
            CharSequenceReaderTest.assertEquals((long)5L, (long)reader.skip(5L));
            buf = new char[expected.length() - 5];
            CharSequenceReaderTest.assertEquals((int)buf.length, (int)reader.read(buf, 0, buf.length));
            CharSequenceReaderTest.assertEquals((String)expected.substring(5), (String)new String(buf));
            CharSequenceReaderTest.assertFullyRead(reader);
        }
    }

    private static void assertFullyRead(CharSequenceReader reader) throws IOException {
        CharSequenceReaderTest.assertEquals((int)-1, (int)reader.read());
        CharSequenceReaderTest.assertEquals((int)-1, (int)reader.read(new char[10], 0, 10));
        CharSequenceReaderTest.assertEquals((int)-1, (int)reader.read(CharBuffer.allocate(10)));
        CharSequenceReaderTest.assertEquals((long)0L, (long)reader.skip(10L));
    }

    private static String readFully(CharSequenceReader reader) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read()) != -1) {
            builder.append((char)read);
        }
        return builder.toString();
    }
}

