/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.AndroidIncompatible;
import com.google.common.io.ByteSourceTester;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.google.common.io.SourceSinkFactories;
import com.google.common.io.SourceSinkFactory;
import com.google.common.io.SourceSinkTester;
import com.google.common.io.TestCharSink;
import com.google.common.io.TestOption;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import junit.framework.Test;
import junit.framework.TestSuite;

@AndroidIncompatible
public class CharSourceTester
extends SourceSinkTester<CharSource, String, SourceSinkFactory.CharSourceFactory> {
    private static final ImmutableList<Method> testMethods = CharSourceTester.getTestMethods(CharSourceTester.class);
    private final ImmutableList<String> expectedLines;
    private CharSource source;

    static TestSuite tests(String name, SourceSinkFactory.CharSourceFactory factory, boolean testAsByteSource) {
        TestSuite suite = new TestSuite(name);
        for (Map.Entry entry : TEST_STRINGS.entrySet()) {
            if (testAsByteSource) {
                suite.addTest((Test)CharSourceTester.suiteForBytes(factory, ((String)entry.getValue()).getBytes(Charsets.UTF_8), name, (String)entry.getKey(), true));
                continue;
            }
            suite.addTest((Test)CharSourceTester.suiteForString(factory, (String)entry.getValue(), name, (String)entry.getKey()));
        }
        return suite;
    }

    static TestSuite suiteForBytes(SourceSinkFactory.CharSourceFactory factory, byte[] bytes, String name, String desc, boolean slice) {
        TestSuite suite = CharSourceTester.suiteForString(factory, new String(bytes, Charsets.UTF_8), name, desc);
        SourceSinkFactory.ByteSourceFactory byteSourceFactory = SourceSinkFactories.asByteSourceFactory(factory);
        suite.addTest((Test)ByteSourceTester.suiteForBytes(byteSourceFactory, bytes, name + ".asByteSource[Charset]", desc, slice));
        return suite;
    }

    static TestSuite suiteForString(SourceSinkFactory.CharSourceFactory factory, String string, String name, String desc) {
        TestSuite suite = new TestSuite(name + " [" + desc + "]");
        for (Method method : testMethods) {
            suite.addTest((Test)new CharSourceTester(factory, string, name, desc, method));
        }
        return suite;
    }

    public CharSourceTester(SourceSinkFactory.CharSourceFactory factory, String string, String suiteName, String caseDesc, Method method) {
        super(factory, string, suiteName, caseDesc, method);
        this.expectedLines = CharSourceTester.getLines((String)this.expected);
    }

    protected void setUp() throws Exception {
        this.source = (CharSource)((SourceSinkFactory.CharSourceFactory)this.factory).createSource(this.data);
    }

    public void testOpenStream() throws IOException {
        int read;
        Reader reader = this.source.openStream();
        StringWriter writer = new StringWriter();
        char[] buf = new char[64];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        reader.close();
        writer.close();
        this.assertExpectedString(writer.toString());
    }

    public void testOpenBufferedStream() throws IOException {
        int read;
        BufferedReader reader = this.source.openBufferedStream();
        StringWriter writer = new StringWriter();
        char[] buf = new char[64];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
        }
        reader.close();
        writer.close();
        this.assertExpectedString(writer.toString());
    }

    public void testLines() throws IOException {
        try (Stream lines = this.source.lines();){
            this.assertExpectedLines((List)lines.collect(ImmutableList.toImmutableList()));
        }
    }

    public void testCopyTo_appendable() throws IOException {
        StringBuilder builder = new StringBuilder();
        CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)this.source.copyTo((Appendable)builder));
        this.assertExpectedString(builder.toString());
    }

    public void testCopyTo_charSink() throws IOException {
        TestCharSink sink = new TestCharSink(new TestOption[0]);
        CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)this.source.copyTo((CharSink)sink));
        this.assertExpectedString(sink.getString());
    }

    public void testRead_toString() throws IOException {
        String string = this.source.read();
        this.assertExpectedString(string);
    }

    public void testReadFirstLine() throws IOException {
        if (this.expectedLines.isEmpty()) {
            CharSourceTester.assertNull((Object)this.source.readFirstLine());
        } else {
            CharSourceTester.assertEquals((String)((String)this.expectedLines.get(0)), (String)this.source.readFirstLine());
        }
    }

    public void testReadLines_toList() throws IOException {
        this.assertExpectedLines((List<String>)this.source.readLines());
    }

    public void testIsEmpty() throws IOException {
        CharSourceTester.assertEquals((boolean)((String)this.expected).isEmpty(), (boolean)this.source.isEmpty());
    }

    public void testLength() throws IOException {
        CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)this.source.length());
    }

    public void testLengthIfKnown() throws IOException {
        Optional lengthIfKnown = this.source.lengthIfKnown();
        if (lengthIfKnown.isPresent()) {
            CharSourceTester.assertEquals((long)((String)this.expected).length(), (long)((Long)lengthIfKnown.get()));
        }
    }

    public void testReadLines_withProcessor() throws IOException {
        List list = (List)this.source.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return true;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        this.assertExpectedLines(list);
    }

    public void testReadLines_withProcessor_stopsOnFalse() throws IOException {
        List list = (List)this.source.readLines((LineProcessor)new LineProcessor<List<String>>(){
            List<String> list = Lists.newArrayList();

            public boolean processLine(String line) throws IOException {
                this.list.add(line);
                return false;
            }

            public List<String> getResult() {
                return this.list;
            }
        });
        if (this.expectedLines.isEmpty()) {
            CharSourceTester.assertTrue((boolean)list.isEmpty());
        } else {
            CharSourceTester.assertEquals((Object)this.expectedLines.subList(0, 1), (Object)list);
        }
    }

    public void testForEachLine() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.source.forEachLine(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.assertExpectedLines((List<String>)builder.build());
    }

    private void assertExpectedString(String string) {
        CharSourceTester.assertEquals((String)((String)this.expected), (String)string);
    }

    private void assertExpectedLines(List<String> list) {
        CharSourceTester.assertEquals(this.expectedLines, list);
    }
}

