/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.VmOptions;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.Random;

@VmOptions(value={"-Xms12g", "-Xmx12g", "-d64"})
public class CharStreamsCopyBenchmark {
    @Param
    CopyStrategy strategy;
    @Param
    TargetSupplier target;
    @Param(value={"10", "1024", "1048576"})
    int size;
    String data;

    @BeforeExperiment
    public void setUp() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random(-559038737L);
        sb.ensureCapacity(this.size);
        for (int k = 0; k < this.size; ++k) {
            sb.append((char)(random.nextInt(118) + 9));
        }
        this.data = sb.toString();
    }

    @Benchmark
    public long timeCopy(int reps) throws IOException {
        long r = 0L;
        String localData = this.data;
        TargetSupplier localTarget = this.target;
        CopyStrategy localStrategy = this.strategy;
        for (int i = 0; i < reps; ++i) {
            Appendable appendable = localTarget.get(localData.length());
            r += localStrategy.copy(new StringReader(localData), appendable);
        }
        return r;
    }

    static enum TargetSupplier {
        STRING_WRITER{

            @Override
            Appendable get(int sz) {
                return new StringWriter(sz);
            }
        }
        ,
        STRING_BUILDER{

            @Override
            Appendable get(int sz) {
                return new StringBuilder(sz);
            }
        };


        abstract Appendable get(int var1);
    }

    static enum CopyStrategy {
        OLD{

            @Override
            long copy(Readable from, Appendable to) throws IOException {
                CharBuffer buf = CharStreams.createBuffer();
                long total = 0L;
                while (from.read(buf) != -1) {
                    buf.flip();
                    to.append(buf);
                    total += (long)buf.remaining();
                    buf.clear();
                }
                return total;
            }
        }
        ,
        NEW{

            @Override
            long copy(Readable from, Appendable to) throws IOException {
                return CharStreams.copy((Readable)from, (Appendable)to);
            }
        };


        abstract long copy(Readable var1, Appendable var2) throws IOException;
    }
}

