/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;

public class LittleEndianDataOutputStreamTest
extends TestCase {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private LittleEndianDataOutputStream out = new LittleEndianDataOutputStream((OutputStream)this.baos);

    public void testWriteLittleEndian() throws IOException {
        this.out.write(new byte[]{-100, 100});
        this.out.writeBoolean(true);
        this.out.writeBoolean(false);
        this.out.writeByte(100);
        this.out.writeByte(-100);
        this.out.writeByte(-56);
        this.out.writeChar(97);
        this.out.writeShort(-30000);
        this.out.writeShort(-15536);
        this.out.writeInt(-889275714);
        this.out.writeLong(-2401053089206453570L);
        this.out.writeUTF("Herby Derby");
        this.out.writeFloat(Float.intBitsToFloat(-889275714));
        this.out.writeDouble(Double.longBitsToDouble(-2401053089206453570L));
        byte[] data = this.baos.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        byte[] b = new byte[2];
        in.readFully(b);
        LittleEndianDataOutputStreamTest.assertEquals((int)-100, (int)b[0]);
        LittleEndianDataOutputStreamTest.assertEquals((int)100, (int)b[1]);
        LittleEndianDataOutputStreamTest.assertEquals((boolean)true, (boolean)in.readBoolean());
        LittleEndianDataOutputStreamTest.assertEquals((boolean)false, (boolean)in.readBoolean());
        LittleEndianDataOutputStreamTest.assertEquals((int)100, (int)in.readByte());
        LittleEndianDataOutputStreamTest.assertEquals((int)-100, (int)in.readByte());
        LittleEndianDataOutputStreamTest.assertEquals((int)200, (int)in.readUnsignedByte());
        LittleEndianDataOutputStreamTest.assertEquals((char)'\u6100', (char)in.readChar());
        LittleEndianDataOutputStreamTest.assertEquals((int)-12150, (int)in.readShort());
        LittleEndianDataOutputStreamTest.assertEquals((int)20675, (int)in.readUnsignedShort());
        LittleEndianDataOutputStreamTest.assertEquals((int)-1095041334, (int)in.readInt());
        LittleEndianDataOutputStreamTest.assertEquals((long)-4703166713275961890L, (long)in.readLong());
        LittleEndianDataOutputStreamTest.assertEquals((String)"Herby Derby", (String)in.readUTF());
        LittleEndianDataOutputStreamTest.assertEquals((int)-1095041334, (int)Float.floatToIntBits(in.readFloat()));
        LittleEndianDataOutputStreamTest.assertEquals((long)-4703166713275961890L, (long)Double.doubleToLongBits(in.readDouble()));
    }

    public void testWriteBytes() throws IOException {
        this.out.writeBytes("r\u00c9sum\u00c9");
        byte[] data = this.baos.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        byte[] b = new byte[6];
        in.readFully(b);
        LittleEndianDataOutputStreamTest.assertEquals("r\u00c9sum\u00c9".getBytes(Charsets.ISO_8859_1), b);
    }

    public void testWriteBytes_discardHighOrderBytes() throws IOException {
        this.out.writeBytes("\uaaaa\uaabb\uaacc");
        byte[] data = this.baos.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        byte[] b = new byte[3];
        in.readFully(b);
        byte[] expected = new byte[]{-86, -69, -52};
        LittleEndianDataOutputStreamTest.assertEquals(expected, b);
    }

    public void testWriteChars() throws IOException {
        this.out.writeChars("r\u00c9sum\u00c9");
        byte[] data = this.baos.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        byte[] actual = new byte[12];
        in.readFully(actual);
        LittleEndianDataOutputStreamTest.assertEquals((int)114, (int)actual[0]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[1]);
        LittleEndianDataOutputStreamTest.assertEquals((byte)-55, (byte)actual[2]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[3]);
        LittleEndianDataOutputStreamTest.assertEquals((int)115, (int)actual[4]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[5]);
        LittleEndianDataOutputStreamTest.assertEquals((int)117, (int)actual[6]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[7]);
        LittleEndianDataOutputStreamTest.assertEquals((int)109, (int)actual[8]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[9]);
        LittleEndianDataOutputStreamTest.assertEquals((byte)-55, (byte)actual[10]);
        LittleEndianDataOutputStreamTest.assertEquals((int)0, (int)actual[11]);
    }

    private static void assertEquals(byte[] expected, byte[] actual) {
        LittleEndianDataOutputStreamTest.assertEquals((Object)Bytes.asList((byte[])expected), (Object)Bytes.asList((byte[])actual));
    }
}

