/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.AndroidIncompatible;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.google.common.io.SourceSinkFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SourceSinkFactories {
    private SourceSinkFactories() {
    }

    public static SourceSinkFactory.CharSourceFactory stringCharSourceFactory() {
        return new StringSourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory byteArraySourceFactory() {
        return new ByteArraySourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory emptyByteSourceFactory() {
        return new EmptyByteSourceFactory();
    }

    public static SourceSinkFactory.CharSourceFactory emptyCharSourceFactory() {
        return new EmptyCharSourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory fileByteSourceFactory() {
        return new FileByteSourceFactory();
    }

    public static SourceSinkFactory.ByteSinkFactory fileByteSinkFactory() {
        return new FileByteSinkFactory(null);
    }

    public static SourceSinkFactory.ByteSinkFactory appendingFileByteSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        return new FileByteSinkFactory(initialString.getBytes(Charsets.UTF_8));
    }

    public static SourceSinkFactory.CharSourceFactory fileCharSourceFactory() {
        return new FileCharSourceFactory();
    }

    public static SourceSinkFactory.CharSinkFactory fileCharSinkFactory() {
        return new FileCharSinkFactory(null);
    }

    public static SourceSinkFactory.CharSinkFactory appendingFileCharSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        return new FileCharSinkFactory(initialString);
    }

    public static SourceSinkFactory.ByteSourceFactory urlByteSourceFactory() {
        return new UrlByteSourceFactory();
    }

    public static SourceSinkFactory.CharSourceFactory urlCharSourceFactory() {
        return new UrlCharSourceFactory();
    }

    @AndroidIncompatible
    public static SourceSinkFactory.ByteSourceFactory pathByteSourceFactory() {
        return new PathByteSourceFactory();
    }

    @AndroidIncompatible
    public static SourceSinkFactory.ByteSinkFactory pathByteSinkFactory() {
        return new PathByteSinkFactory(null);
    }

    @AndroidIncompatible
    public static SourceSinkFactory.ByteSinkFactory appendingPathByteSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        return new PathByteSinkFactory(initialString.getBytes(Charsets.UTF_8));
    }

    @AndroidIncompatible
    public static SourceSinkFactory.CharSourceFactory pathCharSourceFactory() {
        return new PathCharSourceFactory();
    }

    @AndroidIncompatible
    public static SourceSinkFactory.CharSinkFactory pathCharSinkFactory() {
        return new PathCharSinkFactory(null);
    }

    @AndroidIncompatible
    public static SourceSinkFactory.CharSinkFactory appendingPathCharSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        return new PathCharSinkFactory(initialString);
    }

    public static SourceSinkFactory.ByteSourceFactory asByteSourceFactory(final SourceSinkFactory.CharSourceFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.ByteSourceFactory(){

            @Override
            public ByteSource createSource(byte[] data) throws IOException {
                return ((CharSource)factory.createSource(new String(data, Charsets.UTF_8))).asByteSource(Charsets.UTF_8);
            }

            @Override
            public byte[] getExpected(byte[] data) {
                return factory.getExpected(new String(data, Charsets.UTF_8)).getBytes(Charsets.UTF_8);
            }

            @Override
            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    public static SourceSinkFactory.CharSourceFactory asCharSourceFactory(final SourceSinkFactory.ByteSourceFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.CharSourceFactory(){

            @Override
            public CharSource createSource(String string) throws IOException {
                return ((ByteSource)factory.createSource(string.getBytes(Charsets.UTF_8))).asCharSource(Charsets.UTF_8);
            }

            @Override
            public String getExpected(String data) {
                return new String(factory.getExpected(data.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
            }

            @Override
            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    public static SourceSinkFactory.CharSinkFactory asCharSinkFactory(final SourceSinkFactory.ByteSinkFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.CharSinkFactory(){

            @Override
            public CharSink createSink() throws IOException {
                return ((ByteSink)factory.createSink()).asCharSink(Charsets.UTF_8);
            }

            @Override
            public String getSinkContents() throws IOException {
                return new String((byte[])factory.getSinkContents(), Charsets.UTF_8);
            }

            @Override
            public String getExpected(String data) {
                byte[] factoryExpectedForNothing = factory.getExpected(new byte[0]);
                return new String(factoryExpectedForNothing, Charsets.UTF_8) + (String)Preconditions.checkNotNull((Object)data);
            }

            @Override
            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    public static SourceSinkFactory.ByteSourceFactory asSlicedByteSourceFactory(final SourceSinkFactory.ByteSourceFactory factory, final long off, final long len) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.ByteSourceFactory(){

            @Override
            public ByteSource createSource(byte[] bytes) throws IOException {
                return ((ByteSource)factory.createSource(bytes)).slice(off, len);
            }

            @Override
            public byte[] getExpected(byte[] bytes) {
                byte[] baseExpected = factory.getExpected(bytes);
                int startOffset = (int)Math.min(off, (long)baseExpected.length);
                int actualLen = (int)Math.min(len, (long)(baseExpected.length - startOffset));
                return Arrays.copyOfRange(baseExpected, startOffset, startOffset + actualLen);
            }

            @Override
            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    @AndroidIncompatible
    private static class PathCharSinkFactory
    extends Jdk7FileFactory
    implements SourceSinkFactory.CharSinkFactory {
        private final String initialString;

        private PathCharSinkFactory(@Nullable String initialString) {
            this.initialString = initialString;
        }

        @Override
        public CharSink createSink() throws IOException {
            Path file = this.createFile();
            if (this.initialString != null) {
                try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(file, Charsets.UTF_8, new OpenOption[0]);){
                    writer.write(this.initialString);
                }
                return MoreFiles.asCharSink((Path)file, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND});
            }
            return MoreFiles.asCharSink((Path)file, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        }

        @Override
        public String getExpected(String string) {
            Preconditions.checkNotNull((Object)string);
            return this.initialString == null ? string : this.initialString + string;
        }

        @Override
        public String getSinkContents() throws IOException {
            Path file = this.getPath();
            try (BufferedReader reader = java.nio.file.Files.newBufferedReader(file, Charsets.UTF_8);){
                StringBuilder builder = new StringBuilder();
                int c = ((Reader)reader).read();
                while (c != -1) {
                    builder.append((char)c);
                    c = ((Reader)reader).read();
                }
                String string = builder.toString();
                return string;
            }
        }
    }

    @AndroidIncompatible
    private static class PathCharSourceFactory
    extends Jdk7FileFactory
    implements SourceSinkFactory.CharSourceFactory {
        private PathCharSourceFactory() {
        }

        @Override
        public CharSource createSource(String string) throws IOException {
            Preconditions.checkNotNull((Object)string);
            Path file = this.createFile();
            try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(file, Charsets.UTF_8, new OpenOption[0]);){
                writer.write(string);
            }
            return MoreFiles.asCharSource((Path)file, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        }

        @Override
        public String getExpected(String string) {
            return (String)Preconditions.checkNotNull((Object)string);
        }
    }

    @AndroidIncompatible
    private static class PathByteSinkFactory
    extends Jdk7FileFactory
    implements SourceSinkFactory.ByteSinkFactory {
        private final byte[] initialBytes;

        private PathByteSinkFactory(@Nullable byte[] initialBytes) {
            this.initialBytes = initialBytes;
        }

        @Override
        public ByteSink createSink() throws IOException {
            Path file = this.createFile();
            if (this.initialBytes != null) {
                java.nio.file.Files.write(file, this.initialBytes, new OpenOption[0]);
                return MoreFiles.asByteSink((Path)file, (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND});
            }
            return MoreFiles.asByteSink((Path)file, (OpenOption[])new OpenOption[0]);
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            if (this.initialBytes == null) {
                return (byte[])Preconditions.checkNotNull((Object)bytes);
            }
            byte[] result = new byte[this.initialBytes.length + bytes.length];
            System.arraycopy(this.initialBytes, 0, result, 0, this.initialBytes.length);
            System.arraycopy(bytes, 0, result, this.initialBytes.length, bytes.length);
            return result;
        }

        @Override
        public byte[] getSinkContents() throws IOException {
            Path file = this.getPath();
            return java.nio.file.Files.readAllBytes(file);
        }
    }

    @AndroidIncompatible
    private static class PathByteSourceFactory
    extends Jdk7FileFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private PathByteSourceFactory() {
        }

        @Override
        public ByteSource createSource(byte[] bytes) throws IOException {
            Preconditions.checkNotNull((Object)bytes);
            Path file = this.createFile();
            java.nio.file.Files.write(file, bytes, new OpenOption[0]);
            return MoreFiles.asByteSource((Path)file, (OpenOption[])new OpenOption[0]);
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            return (byte[])Preconditions.checkNotNull((Object)bytes);
        }
    }

    @AndroidIncompatible
    private static abstract class Jdk7FileFactory {
        private static final Logger logger = Logger.getLogger(Jdk7FileFactory.class.getName());
        private final ThreadLocal<Path> fileThreadLocal = new ThreadLocal();

        private Jdk7FileFactory() {
        }

        protected Path createFile() throws IOException {
            Path file = java.nio.file.Files.createTempFile("SinkSourceFile", "txt", new FileAttribute[0]);
            this.fileThreadLocal.set(file);
            return file;
        }

        protected Path getPath() {
            return this.fileThreadLocal.get();
        }

        public final void tearDown() throws IOException {
            try {
                java.nio.file.Files.delete(this.fileThreadLocal.get());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to delete file: " + this.fileThreadLocal.get(), e);
            }
            this.fileThreadLocal.remove();
        }
    }

    private static class UrlCharSourceFactory
    extends FileCharSourceFactory {
        private UrlCharSourceFactory() {
        }

        @Override
        public CharSource createSource(String string) throws IOException {
            super.createSource(string);
            return Resources.asCharSource((URL)this.getFile().toURI().toURL(), (Charset)Charsets.UTF_8);
        }
    }

    private static class UrlByteSourceFactory
    extends FileByteSourceFactory {
        private UrlByteSourceFactory() {
        }

        @Override
        public ByteSource createSource(byte[] bytes) throws IOException {
            super.createSource(bytes);
            return Resources.asByteSource((URL)this.getFile().toURI().toURL());
        }
    }

    private static class FileCharSinkFactory
    extends FileFactory
    implements SourceSinkFactory.CharSinkFactory {
        private final String initialString;

        private FileCharSinkFactory(@Nullable String initialString) {
            this.initialString = initialString;
        }

        @Override
        public CharSink createSink() throws IOException {
            File file = this.createFile();
            if (this.initialString != null) {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
                    writer.write(this.initialString);
                }
                return Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            }
            return Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
        }

        @Override
        public String getExpected(String string) {
            Preconditions.checkNotNull((Object)string);
            return this.initialString == null ? string : this.initialString + string;
        }

        @Override
        public String getSinkContents() throws IOException {
            File file = this.getFile();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
            StringBuilder builder = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(100);
            while (((Reader)reader).read(buffer) != -1) {
                buffer.flip();
                builder.append(buffer);
                buffer.clear();
            }
            return builder.toString();
        }
    }

    private static class FileCharSourceFactory
    extends FileFactory
    implements SourceSinkFactory.CharSourceFactory {
        private FileCharSourceFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSource createSource(String string) throws IOException {
            Preconditions.checkNotNull((Object)string);
            File file = this.createFile();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
                writer.write(string);
            }
            return Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        }

        @Override
        public String getExpected(String string) {
            return (String)Preconditions.checkNotNull((Object)string);
        }
    }

    private static class FileByteSinkFactory
    extends FileFactory
    implements SourceSinkFactory.ByteSinkFactory {
        private final byte[] initialBytes;

        private FileByteSinkFactory(@Nullable byte[] initialBytes) {
            this.initialBytes = initialBytes;
        }

        @Override
        public ByteSink createSink() throws IOException {
            File file = this.createFile();
            if (this.initialBytes != null) {
                try (FileOutputStream out = new FileOutputStream(file);){
                    out.write(this.initialBytes);
                }
                return Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            }
            return Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            if (this.initialBytes == null) {
                return (byte[])Preconditions.checkNotNull((Object)bytes);
            }
            byte[] result = new byte[this.initialBytes.length + bytes.length];
            System.arraycopy(this.initialBytes, 0, result, 0, this.initialBytes.length);
            System.arraycopy(bytes, 0, result, this.initialBytes.length, bytes.length);
            return result;
        }

        @Override
        public byte[] getSinkContents() throws IOException {
            int read;
            File file = this.getFile();
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[100];
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            return out.toByteArray();
        }
    }

    private static class FileByteSourceFactory
    extends FileFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private FileByteSourceFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteSource createSource(byte[] bytes) throws IOException {
            Preconditions.checkNotNull((Object)bytes);
            File file = this.createFile();
            try (FileOutputStream out = new FileOutputStream(file);){
                ((OutputStream)out).write(bytes);
            }
            return Files.asByteSource((File)file);
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            return (byte[])Preconditions.checkNotNull((Object)bytes);
        }
    }

    private static abstract class FileFactory {
        private static final Logger logger = Logger.getLogger(FileFactory.class.getName());
        private final ThreadLocal<File> fileThreadLocal = new ThreadLocal();

        private FileFactory() {
        }

        protected File createFile() throws IOException {
            File file = File.createTempFile("SinkSourceFile", "txt");
            this.fileThreadLocal.set(file);
            return file;
        }

        protected File getFile() {
            return this.fileThreadLocal.get();
        }

        public final void tearDown() throws IOException {
            if (!this.fileThreadLocal.get().delete()) {
                logger.warning("Unable to delete file: " + this.fileThreadLocal.get());
            }
            this.fileThreadLocal.remove();
        }
    }

    private static class EmptyByteSourceFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private EmptyByteSourceFactory() {
        }

        @Override
        public ByteSource createSource(byte[] bytes) throws IOException {
            return ByteSource.empty();
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            return new byte[0];
        }

        @Override
        public void tearDown() throws IOException {
        }
    }

    private static class EmptyCharSourceFactory
    implements SourceSinkFactory.CharSourceFactory {
        private EmptyCharSourceFactory() {
        }

        @Override
        public CharSource createSource(String data) throws IOException {
            return CharSource.empty();
        }

        @Override
        public String getExpected(String data) {
            return "";
        }

        @Override
        public void tearDown() throws IOException {
        }
    }

    private static class ByteArraySourceFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private ByteArraySourceFactory() {
        }

        @Override
        public ByteSource createSource(byte[] bytes) throws IOException {
            return ByteSource.wrap((byte[])bytes);
        }

        @Override
        public byte[] getExpected(byte[] bytes) {
            return bytes;
        }

        @Override
        public void tearDown() throws IOException {
        }
    }

    private static class StringSourceFactory
    implements SourceSinkFactory.CharSourceFactory {
        private StringSourceFactory() {
        }

        @Override
        public CharSource createSource(String data) throws IOException {
            return CharSource.wrap((CharSequence)data);
        }

        @Override
        public String getExpected(String data) {
            return data;
        }

        @Override
        public void tearDown() throws IOException {
        }
    }
}

