/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.common.math.MathBenchmarking;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigIntegerMathBenchmark {
    private static final int[] factorials = new int[65536];
    private static final int[] slowFactorials = new int[65536];
    private static final int[] binomials = new int[65536];
    @Param(value={"50", "1000", "10000"})
    int factorialBound;

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            BigIntegerMathBenchmark.factorials[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(this.factorialBound);
            BigIntegerMathBenchmark.slowFactorials[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(this.factorialBound);
            BigIntegerMathBenchmark.binomials[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(factorials[i] + 1);
        }
    }

    private static BigInteger oldSlowFactorial(int n) {
        if (n <= 20) {
            return BigInteger.valueOf(LongMath.factorial((int)n));
        }
        int k = 20;
        return BigInteger.valueOf(LongMath.factorial((int)k)).multiply(BigIntegerMathBenchmark.oldSlowFactorial(k, n));
    }

    private static BigInteger oldSlowFactorial(int n1, int n2) {
        assert (n1 <= n2);
        if (IntMath.log2((int)n2, (RoundingMode)RoundingMode.CEILING) * (n2 - n1) < 63) {
            long result = 1L;
            for (int i = n1 + 1; i <= n2; ++i) {
                result *= (long)i;
            }
            return BigInteger.valueOf(result);
        }
        int mid = n1 + n2 >>> 1;
        return BigIntegerMathBenchmark.oldSlowFactorial(n1, mid).multiply(BigIntegerMathBenchmark.oldSlowFactorial(mid, n2));
    }

    @Benchmark
    int slowFactorial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMathBenchmark.oldSlowFactorial(slowFactorials[j]).intValue();
        }
        return tmp;
    }

    @Benchmark
    int factorial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.factorial((int)factorials[j]).intValue();
        }
        return tmp;
    }

    @Benchmark
    int binomial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.binomial((int)factorials[j], (int)binomials[j]).intValue();
        }
        return tmp;
    }
}

