/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.MathBenchmarking;
import java.math.BigInteger;
import java.math.RoundingMode;

public class BigIntegerMathRoundingBenchmark {
    private static final BigInteger[] nonzero1 = new BigInteger[65536];
    private static final BigInteger[] nonzero2 = new BigInteger[65536];
    private static final BigInteger[] positive = new BigInteger[65536];
    @Param(value={"DOWN", "UP", "FLOOR", "CEILING", "HALF_EVEN", "HALF_UP", "HALF_DOWN"})
    RoundingMode mode;

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            BigIntegerMathRoundingBenchmark.positive[i] = MathBenchmarking.randomPositiveBigInteger(1024);
            BigIntegerMathRoundingBenchmark.nonzero1[i] = MathBenchmarking.randomNonZeroBigInteger(1024);
            BigIntegerMathRoundingBenchmark.nonzero2[i] = MathBenchmarking.randomNonZeroBigInteger(1024);
        }
    }

    @Benchmark
    int log2(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.log2((BigInteger)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int log10(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.log10((BigInteger)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int sqrt(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.sqrt((BigInteger)positive[j], (RoundingMode)this.mode).intValue();
        }
        return tmp;
    }

    @Benchmark
    int divide(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += BigIntegerMath.divide((BigInteger)nonzero1[j], (BigInteger)nonzero2[j], (RoundingMode)this.mode).intValue();
        }
        return tmp;
    }
}

