/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.DoubleMath;
import com.google.common.math.MathTesting;
import com.google.common.primitives.Doubles;
import com.google.common.testing.NullPointerTester;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class DoubleMathTest
extends TestCase {
    private static final BigDecimal MAX_INT_AS_BIG_DECIMAL = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MIN_INT_AS_BIG_DECIMAL = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal MAX_LONG_AS_BIG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_AS_BIG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final ImmutableList<Double> FINITE_TOLERANCE_CANDIDATES = ImmutableList.of((Object)-0.0, (Object)0.0, (Object)1.0, (Object)100.0, (Object)10000.0, (Object)Double.MAX_VALUE);
    private static final Iterable<Double> TOLERANCE_CANDIDATES = Iterables.concat(FINITE_TOLERANCE_CANDIDATES, (Iterable)ImmutableList.of((Object)Double.POSITIVE_INFINITY));
    private static final List<Double> BAD_TOLERANCE_CANDIDATES = Doubles.asList((double[])new double[]{-4.9E-324, -2.2250738585072014E-308, -1.0, -20.0, Double.NaN, Double.NEGATIVE_INFINITY, -0.001});

    public void testConstantsMaxFactorial() {
        BigInteger maxDoubleValue = BigDecimal.valueOf(Double.MAX_VALUE).toBigInteger();
        DoubleMathTest.assertTrue((BigIntegerMath.factorial((int)170).compareTo(maxDoubleValue) <= 0 ? 1 : 0) != 0);
        DoubleMathTest.assertTrue((BigIntegerMath.factorial((int)171).compareTo(maxDoubleValue) > 0 ? 1 : 0) != 0);
    }

    public void testConstantsEverySixteenthFactorial() {
        int i = 0;
        for (int n = 0; n <= 170; n += 16) {
            DoubleMathTest.assertEquals((Object)BigIntegerMath.factorial((int)n).doubleValue(), (Object)DoubleMath.everySixteenthFactorial[i]);
            ++i;
        }
    }

    @GwtIncompatible
    public void testRoundIntegralDoubleToInt() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                boolean isInBounds = expected.compareTo(MAX_INT_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_INT_AS_BIG_DECIMAL) >= 0;
                try {
                    DoubleMathTest.assertEquals((int)expected.intValue(), (int)DoubleMath.roundToInt((double)d, (RoundingMode)mode));
                    DoubleMathTest.assertTrue((boolean)isInBounds);
                }
                catch (ArithmeticException e) {
                    DoubleMathTest.assertFalse((boolean)isInBounds);
                }
            }
        }
    }

    @GwtIncompatible
    public void testRoundFractionalDoubleToInt() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                boolean isInBounds = expected.compareTo(MAX_INT_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_INT_AS_BIG_DECIMAL) >= 0;
                try {
                    DoubleMathTest.assertEquals((String)("Rounding " + d + " with mode " + (Object)((Object)mode)), (int)expected.intValue(), (int)DoubleMath.roundToInt((double)d, (RoundingMode)mode));
                    DoubleMathTest.assertTrue((boolean)isInBounds);
                }
                catch (ArithmeticException e) {
                    DoubleMathTest.assertFalse((boolean)isInBounds);
                }
            }
        }
    }

    @GwtIncompatible
    public void testRoundExactIntegralDoubleToInt() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            BigDecimal expected = new BigDecimal(d).setScale(0, RoundingMode.UNNECESSARY);
            boolean isInBounds = expected.compareTo(MAX_INT_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_INT_AS_BIG_DECIMAL) >= 0;
            try {
                DoubleMathTest.assertEquals((int)expected.intValue(), (int)DoubleMath.roundToInt((double)d, (RoundingMode)RoundingMode.UNNECESSARY));
                DoubleMathTest.assertTrue((boolean)isInBounds);
            }
            catch (ArithmeticException e) {
                DoubleMathTest.assertFalse((boolean)isInBounds);
            }
        }
    }

    @GwtIncompatible
    public void testRoundExactFractionalDoubleToIntFails() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            try {
                DoubleMath.roundToInt((double)d, (RoundingMode)RoundingMode.UNNECESSARY);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundNaNToIntAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToInt((double)Double.NaN, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundInfiniteToIntAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToInt((double)Double.POSITIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            try {
                DoubleMath.roundToInt((double)Double.NEGATIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundIntegralDoubleToLong() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                boolean isInBounds = expected.compareTo(MAX_LONG_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_LONG_AS_BIG_DECIMAL) >= 0;
                try {
                    DoubleMathTest.assertEquals((long)expected.longValue(), (long)DoubleMath.roundToLong((double)d, (RoundingMode)mode));
                    DoubleMathTest.assertTrue((boolean)isInBounds);
                }
                catch (ArithmeticException e) {
                    DoubleMathTest.assertFalse((boolean)isInBounds);
                }
            }
        }
    }

    @GwtIncompatible
    public void testRoundFractionalDoubleToLong() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                boolean isInBounds = expected.compareTo(MAX_LONG_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_LONG_AS_BIG_DECIMAL) >= 0;
                try {
                    DoubleMathTest.assertEquals((long)expected.longValue(), (long)DoubleMath.roundToLong((double)d, (RoundingMode)mode));
                    DoubleMathTest.assertTrue((boolean)isInBounds);
                }
                catch (ArithmeticException e) {
                    DoubleMathTest.assertFalse((boolean)isInBounds);
                }
            }
        }
    }

    @GwtIncompatible
    public void testRoundExactIntegralDoubleToLong() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            BigDecimal expected = new BigDecimal(d).setScale(0, RoundingMode.UNNECESSARY);
            boolean isInBounds = expected.compareTo(MAX_LONG_AS_BIG_DECIMAL) <= 0 & expected.compareTo(MIN_LONG_AS_BIG_DECIMAL) >= 0;
            try {
                DoubleMathTest.assertEquals((long)expected.longValue(), (long)DoubleMath.roundToLong((double)d, (RoundingMode)RoundingMode.UNNECESSARY));
                DoubleMathTest.assertTrue((boolean)isInBounds);
            }
            catch (ArithmeticException e) {
                DoubleMathTest.assertFalse((boolean)isInBounds);
            }
        }
    }

    @GwtIncompatible
    public void testRoundExactFractionalDoubleToLongFails() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            try {
                DoubleMath.roundToLong((double)d, (RoundingMode)RoundingMode.UNNECESSARY);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundNaNToLongAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToLong((double)Double.NaN, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundInfiniteToLongAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToLong((double)Double.POSITIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            try {
                DoubleMath.roundToLong((double)Double.NEGATIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundIntegralDoubleToBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                DoubleMathTest.assertEquals((Object)expected.toBigInteger(), (Object)DoubleMath.roundToBigInteger((double)d, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testRoundFractionalDoubleToBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                BigDecimal expected = new BigDecimal(d).setScale(0, mode);
                DoubleMathTest.assertEquals((Object)expected.toBigInteger(), (Object)DoubleMath.roundToBigInteger((double)d, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testRoundExactIntegralDoubleToBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            BigDecimal expected = new BigDecimal(d).setScale(0, RoundingMode.UNNECESSARY);
            DoubleMathTest.assertEquals((Object)expected.toBigInteger(), (Object)DoubleMath.roundToBigInteger((double)d, (RoundingMode)RoundingMode.UNNECESSARY));
        }
    }

    @GwtIncompatible
    public void testRoundExactFractionalDoubleToBigIntegerFails() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            try {
                DoubleMath.roundToBigInteger((double)d, (RoundingMode)RoundingMode.UNNECESSARY);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundNaNToBigIntegerAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToBigInteger((double)Double.NaN, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundInfiniteToBigIntegerAlwaysFails() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                DoubleMath.roundToBigInteger((double)Double.POSITIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            try {
                DoubleMath.roundToBigInteger((double)Double.NEGATIVE_INFINITY, (RoundingMode)mode);
                DoubleMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @GwtIncompatible
    public void testRoundLog2Floor() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            int log2 = DoubleMath.log2((double)d, (RoundingMode)RoundingMode.FLOOR);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) <= d ? 1 : 0) != 0);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2 + 1) > d ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testRoundLog2Ceiling() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            int log2 = DoubleMath.log2((double)d, (RoundingMode)RoundingMode.CEILING);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) >= d ? 1 : 0) != 0);
            double z = StrictMath.pow(2.0, log2 - 1);
            DoubleMathTest.assertTrue((z < d ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testRoundLog2Down() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            int log2 = DoubleMath.log2((double)d, (RoundingMode)RoundingMode.DOWN);
            if (d >= 1.0) {
                DoubleMathTest.assertTrue((log2 >= 0 ? 1 : 0) != 0);
                DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) <= d ? 1 : 0) != 0);
                DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2 + 1) > d ? 1 : 0) != 0);
                continue;
            }
            DoubleMathTest.assertTrue((log2 <= 0 ? 1 : 0) != 0);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) >= d ? 1 : 0) != 0);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2 - 1) < d ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testRoundLog2Up() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            int log2 = DoubleMath.log2((double)d, (RoundingMode)RoundingMode.UP);
            if (d >= 1.0) {
                DoubleMathTest.assertTrue((log2 >= 0 ? 1 : 0) != 0);
                DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) >= d ? 1 : 0) != 0);
                DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2 - 1) < d ? 1 : 0) != 0);
                continue;
            }
            DoubleMathTest.assertTrue((log2 <= 0 ? 1 : 0) != 0);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2) <= d ? 1 : 0) != 0);
            DoubleMathTest.assertTrue((StrictMath.pow(2.0, log2 + 1) > d ? 1 : 0) != 0);
        }
    }

    @GwtIncompatible
    public void testRoundLog2Half() {
        for (int exp : Arrays.asList(-1022, -50, -1, 0, 1, 2, 3, 4, 100, 1022, 1023)) {
            for (RoundingMode mode : Arrays.asList(RoundingMode.HALF_EVEN, RoundingMode.HALF_UP, RoundingMode.HALF_DOWN)) {
                double x = Math.scalb(Math.sqrt(2.0) + 0.001, exp);
                double y = Math.scalb(Math.sqrt(2.0) - 0.001, exp);
                if (exp < 0) {
                    DoubleMathTest.assertEquals((int)(exp + 1), (int)DoubleMath.log2((double)x, (RoundingMode)mode));
                    DoubleMathTest.assertEquals((int)exp, (int)DoubleMath.log2((double)y, (RoundingMode)mode));
                    continue;
                }
                DoubleMathTest.assertEquals((int)(exp + 1), (int)DoubleMath.log2((double)x, (RoundingMode)mode));
                DoubleMathTest.assertEquals((int)exp, (int)DoubleMath.log2((double)y, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testRoundLog2Exact() {
        for (double x : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            boolean isPowerOfTwo = StrictMath.pow(2.0, DoubleMath.log2((double)x, (RoundingMode)RoundingMode.FLOOR)) == x;
            try {
                int log2 = DoubleMath.log2((double)x, (RoundingMode)RoundingMode.UNNECESSARY);
                DoubleMathTest.assertEquals((Object)x, (Object)Math.scalb(1.0, log2));
                DoubleMathTest.assertTrue((boolean)isPowerOfTwo);
            }
            catch (ArithmeticException e) {
                DoubleMathTest.assertFalse((boolean)isPowerOfTwo);
            }
        }
    }

    @GwtIncompatible
    public void testRoundLog2ThrowsOnZerosInfinitiesAndNaN() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            for (double d : Arrays.asList(0.0, -0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN)) {
                try {
                    DoubleMath.log2((double)d, (RoundingMode)mode);
                    DoubleMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @GwtIncompatible
    public void testRoundLog2ThrowsOnNegative() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
                try {
                    DoubleMath.log2((double)(-d), (RoundingMode)mode);
                    DoubleMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @GwtIncompatible
    public void testIsPowerOfTwoYes() {
        for (int i = -1074; i <= 1023; ++i) {
            DoubleMathTest.assertTrue((boolean)DoubleMath.isPowerOfTwo((double)StrictMath.pow(2.0, i)));
        }
    }

    @GwtIncompatible
    public void testIsPowerOfTwo() {
        for (double x : MathTesting.ALL_DOUBLE_CANDIDATES) {
            boolean expected = x > 0.0 && !Double.isInfinite(x) && !Double.isNaN(x) && StrictMath.pow(2.0, DoubleMath.log2((double)x, (RoundingMode)RoundingMode.FLOOR)) == x;
            DoubleMathTest.assertEquals((boolean)expected, (boolean)DoubleMath.isPowerOfTwo((double)x));
        }
    }

    @GwtIncompatible
    public void testLog2Accuracy() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            double trueLog2;
            double dmLog2 = DoubleMath.log2((double)d);
            DoubleMathTest.assertTrue((Math.abs(dmLog2 - (trueLog2 = this.trueLog2(d))) <= Math.ulp(trueLog2) ? 1 : 0) != 0);
        }
    }

    public void testLog2SemiMonotonic() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            DoubleMathTest.assertTrue((DoubleMath.log2((double)(d + 0.01)) >= DoubleMath.log2((double)d) ? 1 : 0) != 0);
        }
    }

    public void testLog2Negative() {
        for (double d : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            DoubleMathTest.assertTrue((boolean)Double.isNaN(DoubleMath.log2((double)(-d))));
        }
    }

    public void testLog2Zero() {
        DoubleMathTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)DoubleMath.log2((double)0.0));
        DoubleMathTest.assertEquals((Object)Double.NEGATIVE_INFINITY, (Object)DoubleMath.log2((double)-0.0));
    }

    public void testLog2NaNInfinity() {
        DoubleMathTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)DoubleMath.log2((double)Double.POSITIVE_INFINITY));
        DoubleMathTest.assertTrue((boolean)Double.isNaN(DoubleMath.log2((double)Double.NEGATIVE_INFINITY)));
        DoubleMathTest.assertTrue((boolean)Double.isNaN(DoubleMath.log2((double)Double.NaN)));
    }

    @GwtIncompatible
    private strictfp double trueLog2(double d) {
        double trueLog2 = StrictMath.log(d) / StrictMath.log(2.0);
        while (StrictMath.pow(2.0, trueLog2) < d) {
            trueLog2 = StrictMath.nextUp(trueLog2);
        }
        while (StrictMath.pow(2.0, trueLog2) > d) {
            trueLog2 = StrictMath.nextAfter(trueLog2, Double.NEGATIVE_INFINITY);
        }
        if (StrictMath.abs(StrictMath.pow(2.0, trueLog2) - d) > StrictMath.abs(StrictMath.pow(2.0, StrictMath.nextUp(trueLog2)) - d)) {
            trueLog2 = StrictMath.nextUp(trueLog2);
        }
        return trueLog2;
    }

    @GwtIncompatible
    public void testIsMathematicalIntegerIntegral() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.INTEGRAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            DoubleMathTest.assertTrue((boolean)DoubleMath.isMathematicalInteger((double)d));
        }
    }

    @GwtIncompatible
    public void testIsMathematicalIntegerFractional() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.FRACTIONAL_DOUBLE_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            double d = (Double)unmodifiableIterator.next();
            DoubleMathTest.assertFalse((boolean)DoubleMath.isMathematicalInteger((double)d));
        }
    }

    @GwtIncompatible
    public void testIsMathematicalIntegerNotFinite() {
        for (double d : Arrays.asList(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN)) {
            DoubleMathTest.assertFalse((boolean)DoubleMath.isMathematicalInteger((double)d));
        }
    }

    @GwtIncompatible
    public void testFactorial() {
        for (int i = 0; i <= 170; ++i) {
            double actual = BigIntegerMath.factorial((int)i).doubleValue();
            double result = DoubleMath.factorial((int)i);
            DoubleMathTest.assertEquals((double)actual, (double)result, (double)Math.ulp(actual));
        }
    }

    public void testFactorialTooHigh() {
        DoubleMathTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)DoubleMath.factorial((int)171));
        DoubleMathTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)DoubleMath.factorial((int)190));
    }

    public void testFactorialNegative() {
        for (int n : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                DoubleMath.factorial((int)n);
                DoubleMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testFuzzyEqualsFinite() {
        for (double a : MathTesting.FINITE_DOUBLE_CANDIDATES) {
            for (double b : MathTesting.FINITE_DOUBLE_CANDIDATES) {
                UnmodifiableIterator unmodifiableIterator = FINITE_TOLERANCE_CANDIDATES.iterator();
                while (unmodifiableIterator.hasNext()) {
                    double tolerance = (Double)unmodifiableIterator.next();
                    DoubleMathTest.assertEquals((Math.abs(a - b) <= tolerance ? 1 : 0) != 0, (boolean)DoubleMath.fuzzyEquals((double)a, (double)b, (double)tolerance));
                }
            }
        }
    }

    public void testFuzzyInfiniteVersusFiniteWithFiniteTolerance() {
        for (double inf : MathTesting.INFINITIES) {
            for (double a : MathTesting.FINITE_DOUBLE_CANDIDATES) {
                UnmodifiableIterator unmodifiableIterator = FINITE_TOLERANCE_CANDIDATES.iterator();
                while (unmodifiableIterator.hasNext()) {
                    double tolerance = (Double)unmodifiableIterator.next();
                    DoubleMathTest.assertFalse((boolean)DoubleMath.fuzzyEquals((double)a, (double)inf, (double)tolerance));
                    DoubleMathTest.assertFalse((boolean)DoubleMath.fuzzyEquals((double)inf, (double)a, (double)tolerance));
                }
            }
        }
    }

    public void testFuzzyInfiniteVersusInfiniteWithFiniteTolerance() {
        for (double inf : MathTesting.INFINITIES) {
            UnmodifiableIterator unmodifiableIterator = FINITE_TOLERANCE_CANDIDATES.iterator();
            while (unmodifiableIterator.hasNext()) {
                double tolerance = (Double)unmodifiableIterator.next();
                DoubleMathTest.assertTrue((boolean)DoubleMath.fuzzyEquals((double)inf, (double)inf, (double)tolerance));
                DoubleMathTest.assertFalse((boolean)DoubleMath.fuzzyEquals((double)inf, (double)(-inf), (double)tolerance));
            }
        }
    }

    public void testFuzzyEqualsInfiniteTolerance() {
        for (double a : MathTesting.DOUBLE_CANDIDATES_EXCEPT_NAN) {
            for (double b : MathTesting.DOUBLE_CANDIDATES_EXCEPT_NAN) {
                DoubleMathTest.assertTrue((boolean)DoubleMath.fuzzyEquals((double)a, (double)b, (double)Double.POSITIVE_INFINITY));
            }
        }
    }

    public void testFuzzyEqualsOneNaN() {
        for (double a : MathTesting.DOUBLE_CANDIDATES_EXCEPT_NAN) {
            for (double tolerance : TOLERANCE_CANDIDATES) {
                DoubleMathTest.assertFalse((boolean)DoubleMath.fuzzyEquals((double)a, (double)Double.NaN, (double)tolerance));
                DoubleMathTest.assertFalse((boolean)DoubleMath.fuzzyEquals((double)Double.NaN, (double)a, (double)tolerance));
            }
        }
    }

    public void testFuzzyEqualsTwoNaNs() {
        for (double tolerance : TOLERANCE_CANDIDATES) {
            DoubleMathTest.assertTrue((boolean)DoubleMath.fuzzyEquals((double)Double.NaN, (double)Double.NaN, (double)tolerance));
        }
    }

    public void testFuzzyEqualsZeroTolerance() {
        Iterator iterator = Doubles.asList((double[])new double[]{0.0, -0.0}).iterator();
        while (iterator.hasNext()) {
            double zero = (Double)iterator.next();
            for (double a : MathTesting.ALL_DOUBLE_CANDIDATES) {
                for (double b : MathTesting.ALL_DOUBLE_CANDIDATES) {
                    DoubleMathTest.assertEquals((a == b || Double.isNaN(a) && Double.isNaN(b) ? 1 : 0) != 0, (boolean)DoubleMath.fuzzyEquals((double)a, (double)b, (double)zero));
                }
            }
        }
    }

    public void testFuzzyEqualsBadTolerance() {
        for (double tolerance : BAD_TOLERANCE_CANDIDATES) {
            try {
                DoubleMath.fuzzyEquals((double)1.0, (double)2.0, (double)tolerance);
                DoubleMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testFuzzyCompare0() {
        DoubleMathTest.runTestFuzzyCompare(0);
    }

    public void testFuzzyCompare1() {
        DoubleMathTest.runTestFuzzyCompare(1);
    }

    public void testFuzzyCompare2() {
        DoubleMathTest.runTestFuzzyCompare(2);
    }

    public void testFuzzyCompare3() {
        DoubleMathTest.runTestFuzzyCompare(3);
    }

    public void testFuzzyCompare4() {
        DoubleMathTest.runTestFuzzyCompare(4);
    }

    public void testFuzzyCompare5() {
        DoubleMathTest.runTestFuzzyCompare(5);
    }

    public void testFuzzyCompare6() {
        DoubleMathTest.runTestFuzzyCompare(6);
    }

    public void testFuzzyCompare7() {
        DoubleMathTest.assertEquals((int)7, (int)Iterables.size(TOLERANCE_CANDIDATES));
    }

    private static void runTestFuzzyCompare(int toleranceIndex) {
        double tolerance = (Double)Iterables.get(TOLERANCE_CANDIDATES, (int)toleranceIndex);
        for (double a : MathTesting.ALL_DOUBLE_CANDIDATES) {
            for (double b : MathTesting.ALL_DOUBLE_CANDIDATES) {
                int expected = DoubleMath.fuzzyEquals((double)a, (double)b, (double)tolerance) ? 0 : Double.compare(a, b);
                int actual = DoubleMath.fuzzyCompare((double)a, (double)b, (double)tolerance);
                DoubleMathTest.assertEquals((int)Integer.signum(expected), (int)Integer.signum(actual));
            }
        }
    }

    public void testFuzzyCompareBadTolerance() {
        for (double tolerance : BAD_TOLERANCE_CANDIDATES) {
            try {
                DoubleMath.fuzzyCompare((double)1.0, (double)2.0, (double)tolerance);
                DoubleMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testMean_doubleVarargs() {
        DoubleMathTest.assertEquals((double)-1.375, (double)DoubleMath.mean((double[])new double[]{1.1, -2.2, 4.4, -8.8}), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)1.1, (double)DoubleMath.mean((double[])new double[]{1.1}), (double)1.0E-10);
        try {
            DoubleMath.mean((double[])new double[]{Double.NaN});
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DoubleMath.mean((double[])new double[]{Double.POSITIVE_INFINITY});
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_intVarargs() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((int[])new int[]{11, -22, 44, -88}), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((int[])new int[]{11}), (double)1.0E-10);
    }

    @GwtIncompatible
    public void testMean_longVarargs() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((long[])new long[]{11L, -22L, 44L, -88L}), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((long[])new long[]{11L}), (double)1.0E-10);
    }

    @GwtIncompatible
    public void testMean_emptyVarargs() {
        try {
            DoubleMath.mean((int[])new int[0]);
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_doubleIterable() {
        DoubleMathTest.assertEquals((double)-1.375, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)1.1, (Object)-2.2, (Object)4.4, (Object)-8.8)), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)1.1, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)1.1)), (double)1.0E-10);
        try {
            DoubleMath.mean((Iterable)ImmutableList.of());
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DoubleMath.mean((Iterable)ImmutableList.of((Object)Double.NaN));
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DoubleMath.mean((Iterable)ImmutableList.of((Object)Double.POSITIVE_INFINITY));
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_intIterable() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)11, (Object)-22, (Object)44, (Object)-88)), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)11)), (double)1.0E-10);
        try {
            DoubleMath.mean((Iterable)ImmutableList.of());
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_longIterable() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)11L, (Object)-22L, (Object)44L, (Object)-88L)), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((Iterable)ImmutableList.of((Object)11L)), (double)1.0E-10);
        try {
            DoubleMath.mean((Iterable)ImmutableList.of());
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_intIterator() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((Iterator)ImmutableList.of((Object)11, (Object)-22, (Object)44, (Object)-88).iterator()), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((Iterator)ImmutableList.of((Object)11).iterator()), (double)1.0E-10);
        try {
            DoubleMath.mean((Iterator)ImmutableList.of().iterator());
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testMean_longIterator() {
        DoubleMathTest.assertEquals((double)-13.75, (double)DoubleMath.mean((Iterator)ImmutableList.of((Object)11L, (Object)-22L, (Object)44L, (Object)-88L).iterator()), (double)1.0E-10);
        DoubleMathTest.assertEquals((double)11.0, (double)DoubleMath.mean((Iterator)ImmutableList.of((Object)11L).iterator()), (double)1.0E-10);
        try {
            DoubleMath.mean((Iterator)ImmutableList.of().iterator());
            DoubleMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.setDefault(Double.TYPE, (Object)3.0);
        tester.testAllPublicStaticMethods(DoubleMath.class);
    }
}

