/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.math.AndroidIncompatible;
import com.google.common.math.DoubleUtils;
import com.google.common.math.MathTesting;
import java.lang.reflect.Method;
import java.math.BigInteger;
import junit.framework.TestCase;

public class DoubleUtilsTest
extends TestCase {
    @AndroidIncompatible
    public void testNextDown() throws Exception {
        Method jdkNextDown = DoubleUtilsTest.getJdkNextDown();
        for (double d : MathTesting.FINITE_DOUBLE_CANDIDATES) {
            DoubleUtilsTest.assertEquals((Object)jdkNextDown.invoke(null, d), (Object)DoubleUtils.nextDown((double)d));
        }
    }

    private static Method getJdkNextDown() throws Exception {
        try {
            return Math.class.getMethod("nextDown", Double.TYPE);
        }
        catch (NoSuchMethodException expectedBeforeJava8) {
            return Class.forName("sun.misc.FpUtils").getMethod("nextDown", Double.TYPE);
        }
    }

    @AndroidIncompatible
    public void testBigToDouble() {
        for (BigInteger b : MathTesting.ALL_BIGINTEGER_CANDIDATES) {
            if (b.doubleValue() == DoubleUtils.bigToDouble((BigInteger)b)) continue;
            DoubleUtilsTest.failFormat("Converting %s to double: expected doubleValue %s but got bigToDouble %s", b, b.doubleValue(), DoubleUtils.bigToDouble((BigInteger)b));
        }
    }

    public void testEnsureNonNegative() {
        DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)0.0));
        for (double positiveValue : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            DoubleUtilsTest.assertEquals((Object)positiveValue, (Object)DoubleUtils.ensureNonNegative((double)positiveValue));
            DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)(-positiveValue)));
        }
        DoubleUtilsTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)DoubleUtils.ensureNonNegative((double)Double.POSITIVE_INFINITY));
        DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)Double.NEGATIVE_INFINITY));
        try {
            DoubleUtils.ensureNonNegative((double)Double.NaN);
            DoubleUtilsTest.fail((String)"Expected IllegalArgumentException from ensureNonNegative(Double.NaN)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testOneBits() {
        DoubleUtilsTest.assertEquals((long)0x3FF0000000000000L, (long)Double.doubleToRawLongBits(1.0));
    }

    private static void failFormat(String template, Object ... args) {
        DoubleUtilsTest.fail((String)String.format(template, args));
    }
}

