/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.common.math.IntMath;
import com.google.common.math.MathBenchmarking;

public class IntMathBenchmark {
    private static int[] exponent = new int[65536];
    private static int[] factorial = new int[65536];
    private static int[] binomial = new int[65536];
    private static final int[] positive = new int[65536];
    private static final int[] nonnegative = new int[65536];
    private static final int[] ints = new int[65536];

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            IntMathBenchmark.exponent[i] = MathBenchmarking.randomExponent();
            IntMathBenchmark.factorial[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(50);
            IntMathBenchmark.binomial[i] = MathBenchmarking.RANDOM_SOURCE.nextInt(factorial[i] + 1);
            IntMathBenchmark.positive[i] = MathBenchmarking.randomPositiveBigInteger(31).intValue();
            IntMathBenchmark.nonnegative[i] = MathBenchmarking.randomNonNegativeBigInteger(31).intValue();
            IntMathBenchmark.ints[i] = MathBenchmarking.RANDOM_SOURCE.nextInt();
        }
    }

    @Benchmark
    int pow(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.pow((int)positive[j], (int)exponent[j]);
        }
        return tmp;
    }

    @Benchmark
    int mod(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.mod((int)ints[j], (int)positive[j]);
        }
        return tmp;
    }

    @Benchmark
    int gCD(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.gcd((int)nonnegative[j], (int)positive[j]);
        }
        return tmp;
    }

    @Benchmark
    int factorial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.factorial((int)factorial[j]);
        }
        return tmp;
    }

    @Benchmark
    int binomial(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.binomial((int)factorial[j], (int)binomial[j]);
        }
        return tmp;
    }

    @Benchmark
    int isPrime(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            if (!IntMath.isPrime((int)positive[j])) continue;
            ++tmp;
        }
        return tmp;
    }
}

