/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.AndroidIncompatible;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.common.math.MathTesting;
import com.google.common.math.TestPlatform;
import com.google.common.testing.NullPointerTester;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class IntMathTest
extends TestCase {
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);

    public void testMaxSignedPowerOfTwo() {
        IntMathTest.assertTrue((boolean)IntMath.isPowerOfTwo((int)0x40000000));
        long value = 0x80000000L;
        IntMathTest.assertFalse((boolean)IntMath.isPowerOfTwo((int)((int)value)));
    }

    public void testCeilingPowerOfTwo() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            BigInteger expectedResult = BigIntegerMath.ceilingPowerOfTwo((BigInteger)BigInteger.valueOf(x));
            if (IntMathTest.fitsInInt(expectedResult)) {
                IntMathTest.assertEquals((int)expectedResult.intValue(), (int)IntMath.ceilingPowerOfTwo((int)x));
                continue;
            }
            try {
                IntMath.ceilingPowerOfTwo((int)x);
                IntMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    public void testFloorPowerOfTwo() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            BigInteger expectedResult = BigIntegerMath.floorPowerOfTwo((BigInteger)BigInteger.valueOf(x));
            IntMathTest.assertEquals((int)expectedResult.intValue(), (int)IntMath.floorPowerOfTwo((int)x));
        }
    }

    public void testCeilingPowerOfTwoNegative() {
        for (int x : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.ceilingPowerOfTwo((int)x);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testFloorPowerOfTwoNegative() {
        for (int x : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.floorPowerOfTwo((int)x);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testCeilingPowerOfTwoZero() {
        try {
            IntMath.ceilingPowerOfTwo((int)0);
            IntMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFloorPowerOfTwoZero() {
        try {
            IntMath.floorPowerOfTwo((int)0);
            IntMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConstantMaxPowerOfSqrt2Unsigned() {
        IntMathTest.assertEquals((int)BigIntegerMath.sqrt((BigInteger)BigInteger.ZERO.setBit(63), (RoundingMode)RoundingMode.FLOOR).intValue(), (int)-1257966797);
    }

    @GwtIncompatible
    public void testConstantsPowersOf10() {
        for (int i = 0; i < IntMath.powersOf10.length - 1; ++i) {
            IntMathTest.assertEquals((int)IntMath.pow((int)10, (int)i), (int)IntMath.powersOf10[i]);
        }
    }

    @GwtIncompatible
    public void testMaxLog10ForLeadingZeros() {
        for (int i = 0; i < 32; ++i) {
            IntMathTest.assertEquals((int)BigIntegerMath.log10((BigInteger)BigInteger.ONE.shiftLeft(32 - i), (RoundingMode)RoundingMode.FLOOR), (int)IntMath.maxLog10ForLeadingZeros[i]);
        }
    }

    @GwtIncompatible
    public void testConstantsHalfPowersOf10() {
        for (int i = 0; i < IntMath.halfPowersOf10.length; ++i) {
            assert ((long)IntMath.halfPowersOf10[i] == Math.min(Integer.MAX_VALUE, BigIntegerMath.sqrt((BigInteger)BigInteger.TEN.pow(2 * i + 1), (RoundingMode)RoundingMode.FLOOR).longValue()));
        }
    }

    public void testConstantsBiggestBinomials() {
        for (int k = 0; k < IntMath.biggestBinomials.length; ++k) {
            IntMathTest.assertTrue((boolean)IntMathTest.fitsInInt(BigIntegerMath.binomial((int)IntMath.biggestBinomials[k], (int)k)));
            IntMathTest.assertTrue((IntMath.biggestBinomials[k] == Integer.MAX_VALUE || !IntMathTest.fitsInInt(BigIntegerMath.binomial((int)(IntMath.biggestBinomials[k] + 1), (int)k)) ? 1 : 0) != 0);
        }
        IntMathTest.assertFalse((boolean)IntMathTest.fitsInInt(BigIntegerMath.binomial((int)(2 * IntMath.biggestBinomials.length), (int)IntMath.biggestBinomials.length)));
    }

    @GwtIncompatible
    public void testPowersSqrtMaxInt() {
        IntMathTest.assertEquals((int)IntMath.sqrt((int)Integer.MAX_VALUE, (RoundingMode)RoundingMode.FLOOR), (int)46340);
    }

    @AndroidIncompatible
    public void testLessThanBranchFree() {
        for (int x : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int y : MathTesting.ALL_INTEGER_CANDIDATES) {
                if (!LongMath.fitsInInt((long)((long)x - (long)y))) continue;
                int expected = x < y ? 1 : 0;
                int actual = IntMath.lessThanBranchFree((int)x, (int)y);
                IntMathTest.assertEquals((int)expected, (int)actual);
            }
        }
    }

    @GwtIncompatible
    public void testIsPowerOfTwo() {
        for (int x : MathTesting.ALL_INTEGER_CANDIDATES) {
            BigInteger bigX = BigInteger.valueOf(x);
            boolean expected = bigX.signum() > 0 && bigX.bitCount() == 1;
            IntMathTest.assertEquals((boolean)expected, (boolean)IntMath.isPowerOfTwo((int)x));
        }
    }

    public void testLog2ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                IntMath.log2((int)0, (RoundingMode)mode);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testLog2NegativeAlwaysThrows() {
        for (int x : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    IntMath.log2((int)x, (RoundingMode)mode);
                    IntMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void testLog2MatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                IntMathTest.assertEquals((int)BigIntegerMath.log2((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (int)IntMath.log2((int)x, (RoundingMode)mode));
            }
        }
    }

    public void testLog2Exact() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            boolean isPowerOf2 = IntMath.isPowerOfTwo((int)x);
            try {
                IntMathTest.assertEquals((int)x, (int)(1 << IntMath.log2((int)x, (RoundingMode)RoundingMode.UNNECESSARY)));
                IntMathTest.assertTrue((boolean)isPowerOf2);
            }
            catch (ArithmeticException e) {
                IntMathTest.assertFalse((boolean)isPowerOf2);
            }
        }
    }

    @GwtIncompatible
    public void testLog10ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                IntMath.log10((int)0, (RoundingMode)mode);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testLog10NegativeAlwaysThrows() {
        for (int x : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    IntMath.log10((int)x, (RoundingMode)mode);
                    IntMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @GwtIncompatible
    public void testLog10MatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                IntMathTest.assertEquals((int)BigIntegerMath.log10((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (int)IntMath.log10((int)x, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testLog10Exact() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            int floor = IntMath.log10((int)x, (RoundingMode)RoundingMode.FLOOR);
            boolean expectSuccess = IntMath.pow((int)10, (int)floor) == x;
            try {
                IntMathTest.assertEquals((int)floor, (int)IntMath.log10((int)x, (RoundingMode)RoundingMode.UNNECESSARY));
                IntMathTest.assertTrue((boolean)expectSuccess);
            }
            catch (ArithmeticException e) {
                IntMathTest.assertFalse((boolean)expectSuccess);
            }
        }
    }

    @GwtIncompatible
    public void testLog10TrivialOnPowerOfTen() {
        int x = 1000000;
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            IntMathTest.assertEquals((int)6, (int)IntMath.log10((int)x, (RoundingMode)mode));
        }
    }

    @GwtIncompatible
    public void testSqrtZeroAlwaysZero() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            IntMathTest.assertEquals((int)0, (int)IntMath.sqrt((int)0, (RoundingMode)mode));
        }
    }

    @GwtIncompatible
    public void testSqrtNegativeAlwaysThrows() {
        for (int x : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            for (RoundingMode mode : RoundingMode.values()) {
                try {
                    IntMath.sqrt((int)x, (RoundingMode)mode);
                    IntMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @GwtIncompatible
    public void testSqrtMatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                IntMathTest.assertEquals((Object)BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (Object)BigInteger.valueOf(IntMath.sqrt((int)x, (RoundingMode)mode)));
            }
        }
    }

    @GwtIncompatible
    public void testSqrtExactMatchesFloorOrThrows() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            int floor = IntMath.sqrt((int)x, (RoundingMode)RoundingMode.FLOOR);
            boolean isPerfectSquare = floor * floor == x;
            try {
                IntMathTest.assertEquals((int)floor, (int)IntMath.sqrt((int)x, (RoundingMode)RoundingMode.UNNECESSARY));
                IntMathTest.assertTrue((boolean)isPerfectSquare);
            }
            catch (ArithmeticException e) {
                IntMathTest.assertFalse((boolean)isPerfectSquare);
            }
        }
    }

    @GwtIncompatible
    public void testPow() {
        for (int i : MathTesting.ALL_INTEGER_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int pow = (Integer)unmodifiableIterator.next();
                IntMathTest.assertEquals((String)(i + "^" + pow), (int)BigInteger.valueOf(i).pow(pow).intValue(), (int)IntMath.pow((int)i, (int)pow));
            }
        }
    }

    @AndroidIncompatible
    public void testDivNonZero() {
        for (int p : MathTesting.NONZERO_INTEGER_CANDIDATES) {
            for (int q : MathTesting.NONZERO_INTEGER_CANDIDATES) {
                for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                    if (p == Integer.MIN_VALUE && q == -1 && TestPlatform.intsCanGoOutOfRange()) continue;
                    int expected = new BigDecimal(BigInteger.valueOf(p)).divide(new BigDecimal(BigInteger.valueOf(q)), 0, mode).intValue();
                    IntMathTest.assertEquals((String)(p + "/" + q), (int)IntMathTest.force32(expected), (int)IntMath.divide((int)p, (int)q, (RoundingMode)mode));
                }
            }
        }
    }

    @AndroidIncompatible
    public void testDivNonZeroExact() {
        for (int p : MathTesting.NONZERO_INTEGER_CANDIDATES) {
            for (int q : MathTesting.NONZERO_INTEGER_CANDIDATES) {
                if (p == Integer.MIN_VALUE && q == -1 && TestPlatform.intsCanGoOutOfRange()) continue;
                boolean dividesEvenly = p % q == 0;
                try {
                    IntMathTest.assertEquals((String)(p + "/" + q), (int)p, (int)(IntMath.divide((int)p, (int)q, (RoundingMode)RoundingMode.UNNECESSARY) * q));
                    IntMathTest.assertTrue((String)(p + "/" + q + " not expected to divide evenly"), (boolean)dividesEvenly);
                }
                catch (ArithmeticException e) {
                    IntMathTest.assertFalse((String)(p + "/" + q + " expected to divide evenly"), (boolean)dividesEvenly);
                }
            }
        }
    }

    public void testZeroDivIsAlwaysZero() {
        for (int q : MathTesting.NONZERO_INTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                IntMathTest.assertEquals((int)0, (int)IntMath.divide((int)0, (int)q, (RoundingMode)mode));
            }
        }
    }

    public void testDivByZeroAlwaysFails() {
        for (int p : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    IntMath.divide((int)p, (int)0, (RoundingMode)mode);
                    IntMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException arithmeticException) {}
            }
        }
    }

    public void testMod() {
        for (int x : MathTesting.ALL_INTEGER_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
            while (unmodifiableIterator.hasNext()) {
                int m = (Integer)unmodifiableIterator.next();
                IntMathTest.assertEquals((int)BigInteger.valueOf(x).mod(BigInteger.valueOf(m)).intValue(), (int)IntMath.mod((int)x, (int)m));
            }
        }
    }

    public void testModNegativeModulusFails() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int x = (Integer)unmodifiableIterator.next();
            for (int m : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
                try {
                    IntMath.mod((int)x, (int)m);
                    IntMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException arithmeticException) {}
            }
        }
    }

    public void testModZeroModulusFails() {
        for (int x : MathTesting.ALL_INTEGER_CANDIDATES) {
            try {
                IntMath.mod((int)x, (int)0);
                IntMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    public void testGCD() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int a = (Integer)unmodifiableIterator.next();
            UnmodifiableIterator unmodifiableIterator2 = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
            while (unmodifiableIterator2.hasNext()) {
                int b = (Integer)unmodifiableIterator2.next();
                IntMathTest.assertEquals((Object)BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)), (Object)BigInteger.valueOf(IntMath.gcd((int)a, (int)b)));
            }
        }
    }

    public void testGCDZero() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            int a = (Integer)unmodifiableIterator.next();
            IntMathTest.assertEquals((int)a, (int)IntMath.gcd((int)a, (int)0));
            IntMathTest.assertEquals((int)a, (int)IntMath.gcd((int)0, (int)a));
        }
        IntMathTest.assertEquals((int)0, (int)IntMath.gcd((int)0, (int)0));
    }

    public void testGCDNegativePositiveThrows() {
        for (int a : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.gcd((int)a, (int)3);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                IntMath.gcd((int)3, (int)a);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testGCDNegativeZeroThrows() {
        for (int a : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.gcd((int)a, (int)0);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                IntMath.gcd((int)0, (int)a);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @AndroidIncompatible
    public void testCheckedAdd() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                BigInteger expectedResult = BigInteger.valueOf(a).add(BigInteger.valueOf(b));
                boolean expectedSuccess = IntMathTest.fitsInInt(expectedResult);
                try {
                    IntMathTest.assertEquals((int)(a + b), (int)IntMath.checkedAdd((int)a, (int)b));
                    IntMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    IntMathTest.assertFalse((boolean)expectedSuccess);
                }
            }
        }
    }

    @AndroidIncompatible
    public void testCheckedSubtract() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                BigInteger expectedResult = BigInteger.valueOf(a).subtract(BigInteger.valueOf(b));
                boolean expectedSuccess = IntMathTest.fitsInInt(expectedResult);
                try {
                    IntMathTest.assertEquals((int)(a - b), (int)IntMath.checkedSubtract((int)a, (int)b));
                    IntMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    IntMathTest.assertFalse((boolean)expectedSuccess);
                }
            }
        }
    }

    @AndroidIncompatible
    public void testCheckedMultiply() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                BigInteger expectedResult = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
                boolean expectedSuccess = IntMathTest.fitsInInt(expectedResult);
                try {
                    IntMathTest.assertEquals((int)(a * b), (int)IntMath.checkedMultiply((int)a, (int)b));
                    IntMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    IntMathTest.assertFalse((boolean)expectedSuccess);
                }
            }
        }
    }

    public void testCheckedPow() {
        for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int k = (Integer)unmodifiableIterator.next();
                BigInteger expectedResult = BigInteger.valueOf(b).pow(k);
                boolean expectedSuccess = IntMathTest.fitsInInt(expectedResult);
                try {
                    IntMathTest.assertEquals((String)(b + "^" + k), (int)IntMathTest.force32(expectedResult.intValue()), (int)IntMath.checkedPow((int)b, (int)k));
                    IntMathTest.assertTrue((String)(b + "^" + k + " should have succeeded"), (boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    IntMathTest.assertFalse((String)(b + "^" + k + " should have failed"), (boolean)expectedSuccess);
                }
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedAdd() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                this.assertOperationEquals(a, b, "s+", IntMathTest.saturatedCast(BigInteger.valueOf(a).add(BigInteger.valueOf(b))), IntMath.saturatedAdd((int)a, (int)b));
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedSubtract() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                this.assertOperationEquals(a, b, "s-", IntMathTest.saturatedCast(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b))), IntMath.saturatedSubtract((int)a, (int)b));
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedMultiply() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int b : MathTesting.ALL_INTEGER_CANDIDATES) {
                this.assertOperationEquals(a, b, "s*", IntMathTest.saturatedCast(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b))), IntMath.saturatedMultiply((int)a, (int)b));
            }
        }
    }

    @GwtIncompatible
    public void testSaturatedPow() {
        for (int a : MathTesting.ALL_INTEGER_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int b = (Integer)unmodifiableIterator.next();
                this.assertOperationEquals(a, b, "s^", IntMathTest.saturatedCast(BigInteger.valueOf(a).pow(b)), IntMath.saturatedPow((int)a, (int)b));
            }
        }
    }

    private static int saturatedCast(BigInteger big) {
        if (big.compareTo(MAX_INT) > 0) {
            return Integer.MAX_VALUE;
        }
        if (big.compareTo(MIN_INT) < 0) {
            return Integer.MIN_VALUE;
        }
        return big.intValue();
    }

    private void assertOperationEquals(int a, int b, String op, int expected, int actual) {
        if (expected != actual) {
            IntMathTest.fail((String)("Expected for " + a + " " + op + " " + b + " = " + expected + ", but got " + actual));
        }
    }

    public void testFactorial() {
        for (int n = 0; n <= 50; ++n) {
            BigInteger expectedBig = BigIntegerMath.factorial((int)n);
            int expectedInt = IntMathTest.fitsInInt(expectedBig) ? expectedBig.intValue() : Integer.MAX_VALUE;
            IntMathTest.assertEquals((int)expectedInt, (int)IntMath.factorial((int)n));
        }
    }

    public void testFactorialNegative() {
        for (int n : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.factorial((int)n);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testBinomial() {
        for (int n = 0; n <= 50; ++n) {
            for (int k = 0; k <= n; ++k) {
                BigInteger expectedBig = BigIntegerMath.binomial((int)n, (int)k);
                int expectedInt = IntMathTest.fitsInInt(expectedBig) ? expectedBig.intValue() : Integer.MAX_VALUE;
                IntMathTest.assertEquals((int)expectedInt, (int)IntMath.binomial((int)n, (int)k));
            }
        }
    }

    public void testBinomialOutside() {
        for (int n = 0; n <= 50; ++n) {
            try {
                IntMath.binomial((int)n, (int)-1);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                IntMath.binomial((int)n, (int)(n + 1));
                IntMathTest.fail((String)"Expected IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testBinomialNegative() {
        for (int n : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                IntMath.binomial((int)n, (int)0);
                IntMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testMean() {
        IntMathTest.assertMean(2, 1, 3);
        IntMathTest.assertMean(-2, -3, -1);
        IntMathTest.assertMean(0, -1, 1);
        IntMathTest.assertMean(1, -1, 3);
        IntMathTest.assertMean(0x3FFFFFFF, -1, Integer.MAX_VALUE);
        IntMathTest.assertMean(2, 1, 4);
        IntMathTest.assertMean(-3, -4, -1);
        IntMathTest.assertMean(0, -1, 2);
        IntMathTest.assertMean(0, -2147483646, Integer.MAX_VALUE);
        IntMathTest.assertMean(0, 0, 1);
        IntMathTest.assertMean(-1, -1, 0);
        IntMathTest.assertMean(-1, Integer.MIN_VALUE, Integer.MAX_VALUE);
        IntMathTest.assertMean(1, 1, 1);
        IntMathTest.assertMean(0, 0, 0);
        IntMathTest.assertMean(-1, -1, -1);
        IntMathTest.assertMean(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        IntMathTest.assertMean(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (int x : MathTesting.ALL_INTEGER_CANDIDATES) {
            for (int y : MathTesting.ALL_INTEGER_CANDIDATES) {
                IntMathTest.assertMean(x, y);
            }
        }
    }

    private static void assertMean(int expectedMean, int x, int y) {
        IntMathTest.assertEquals((String)"The expectedMean should be the same as computeMeanSafely", (int)expectedMean, (int)IntMathTest.computeMeanSafely(x, y));
        IntMathTest.assertMean(x, y);
    }

    private static void assertMean(int x, int y) {
        int expectedMean = IntMathTest.computeMeanSafely(x, y);
        IntMathTest.assertEquals((int)expectedMean, (int)IntMath.mean((int)x, (int)y));
        IntMathTest.assertEquals((String)"The mean of x and y should equal the mean of y and x", (int)expectedMean, (int)IntMath.mean((int)y, (int)x));
    }

    private static int computeMeanSafely(int x, int y) {
        BigInteger bigX = BigInteger.valueOf(x);
        BigInteger bigY = BigInteger.valueOf(y);
        BigDecimal bigMean = new BigDecimal(bigX.add(bigY)).divide(BigDecimal.valueOf(2L), 3);
        return Integer.parseInt(bigMean.toString());
    }

    private static boolean fitsInInt(BigInteger big) {
        return big.bitLength() <= 31;
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.setDefault(Integer.TYPE, (Object)1);
        tester.testAllPublicStaticMethods(IntMath.class);
    }

    @GwtIncompatible
    public void testIsPrime() {
        for (int i = 0; i < 100000; ++i) {
            IntMathTest.assertEquals((boolean)LongMath.isPrime((long)i), (boolean)IntMath.isPrime((int)i));
        }
        Random rand = new Random(1L);
        for (int i = 0; i < 1000; ++i) {
            int n = rand.nextInt(Integer.MAX_VALUE);
            IntMathTest.assertEquals((boolean)LongMath.isPrime((long)n), (boolean)IntMath.isPrime((int)n));
        }
    }

    private static int force32(int value) {
        return value & 0xFFFFFFFF;
    }
}

