/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.AndroidIncompatible;
import com.google.common.math.BigIntegerMath;
import com.google.common.math.LongMath;
import com.google.common.math.MathTesting;
import com.google.common.testing.NullPointerTester;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class LongMathTest
extends TestCase {
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    public void testMaxSignedPowerOfTwo() {
        LongMathTest.assertTrue((boolean)LongMath.isPowerOfTwo((long)0x4000000000000000L));
        LongMathTest.assertFalse((boolean)LongMath.isPowerOfTwo((long)Long.MIN_VALUE));
    }

    public void testCeilingPowerOfTwo() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            BigInteger expectedResult = BigIntegerMath.ceilingPowerOfTwo((BigInteger)BigInteger.valueOf(x));
            if (LongMathTest.fitsInLong(expectedResult)) {
                LongMathTest.assertEquals((long)expectedResult.longValue(), (long)LongMath.ceilingPowerOfTwo((long)x));
                continue;
            }
            try {
                LongMath.ceilingPowerOfTwo((long)x);
                LongMathTest.fail((String)"Expected ArithmeticException");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    public void testFloorPowerOfTwo() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            BigInteger expectedResult = BigIntegerMath.floorPowerOfTwo((BigInteger)BigInteger.valueOf(x));
            LongMathTest.assertEquals((long)expectedResult.longValue(), (long)LongMath.floorPowerOfTwo((long)x));
        }
    }

    public void testCeilingPowerOfTwoNegative() {
        for (long x : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            try {
                LongMath.ceilingPowerOfTwo((long)x);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testFloorPowerOfTwoNegative() {
        for (long x : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            try {
                LongMath.floorPowerOfTwo((long)x);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testCeilingPowerOfTwoZero() {
        try {
            LongMath.ceilingPowerOfTwo((long)0L);
            LongMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFloorPowerOfTwoZero() {
        try {
            LongMath.floorPowerOfTwo((long)0L);
            LongMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConstantMaxPowerOfSqrt2Unsigned() {
        LongMathTest.assertEquals((long)BigIntegerMath.sqrt((BigInteger)BigInteger.ZERO.setBit(127), (RoundingMode)RoundingMode.FLOOR).longValue(), (long)-5402926248376769404L);
    }

    @GwtIncompatible
    public void testMaxLog10ForLeadingZeros() {
        for (int i = 0; i < 64; ++i) {
            LongMathTest.assertEquals((int)BigIntegerMath.log10((BigInteger)BigInteger.ONE.shiftLeft(64 - i), (RoundingMode)RoundingMode.FLOOR), (int)LongMath.maxLog10ForLeadingZeros[i]);
        }
    }

    @GwtIncompatible
    public void testConstantsPowersOf10() {
        for (int i = 0; i < LongMath.powersOf10.length; ++i) {
            LongMathTest.assertEquals((long)LongMath.checkedPow((long)10L, (int)i), (long)LongMath.powersOf10[i]);
        }
        try {
            LongMath.checkedPow((long)10L, (int)LongMath.powersOf10.length);
            LongMathTest.fail((String)"Expected ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConstantsHalfPowersOf10() {
        for (int i = 0; i < LongMath.halfPowersOf10.length; ++i) {
            LongMathTest.assertEquals((Object)BigIntegerMath.sqrt((BigInteger)BigInteger.TEN.pow(2 * i + 1), (RoundingMode)RoundingMode.FLOOR), (Object)BigInteger.valueOf(LongMath.halfPowersOf10[i]));
        }
        BigInteger nextBigger = BigIntegerMath.sqrt((BigInteger)BigInteger.TEN.pow(2 * LongMath.halfPowersOf10.length + 1), (RoundingMode)RoundingMode.FLOOR);
        LongMathTest.assertTrue((nextBigger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? 1 : 0) != 0);
    }

    @GwtIncompatible
    public void testConstantsSqrtMaxLong() {
        LongMathTest.assertEquals((long)LongMath.sqrt((long)Long.MAX_VALUE, (RoundingMode)RoundingMode.FLOOR), (long)3037000499L);
    }

    @GwtIncompatible
    public void testConstantsFactorials() {
        long expected = 1L;
        int i = 0;
        while (i < LongMath.factorials.length) {
            LongMathTest.assertEquals((long)expected, (long)LongMath.factorials[i]);
            expected *= (long)(++i);
        }
        try {
            LongMath.checkedMultiply((long)LongMath.factorials[LongMath.factorials.length - 1], (long)LongMath.factorials.length);
            LongMathTest.fail((String)"Expected ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testConstantsBiggestBinomials() {
        int k;
        for (k = 0; k < LongMath.biggestBinomials.length; ++k) {
            LongMathTest.assertTrue((boolean)LongMathTest.fitsInLong(BigIntegerMath.binomial((int)LongMath.biggestBinomials[k], (int)k)));
            LongMathTest.assertTrue((LongMath.biggestBinomials[k] == Integer.MAX_VALUE || !LongMathTest.fitsInLong(BigIntegerMath.binomial((int)(LongMath.biggestBinomials[k] + 1), (int)k)) ? 1 : 0) != 0);
        }
        k = LongMath.biggestBinomials.length;
        LongMathTest.assertFalse((boolean)LongMathTest.fitsInLong(BigIntegerMath.binomial((int)(2 * k), (int)k)));
    }

    @GwtIncompatible
    public void testConstantsBiggestSimpleBinomials() {
        int k;
        for (k = 0; k < LongMath.biggestSimpleBinomials.length; ++k) {
            LongMathTest.assertTrue((LongMath.biggestSimpleBinomials[k] <= LongMath.biggestBinomials[k] ? 1 : 0) != 0);
            long unused = this.simpleBinomial(LongMath.biggestSimpleBinomials[k], k);
            if (LongMath.biggestSimpleBinomials[k] >= Integer.MAX_VALUE) continue;
            try {
                this.simpleBinomial(LongMath.biggestSimpleBinomials[k] + 1, k);
                LongMathTest.fail((String)"Expected ArithmeticException");
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        try {
            k = LongMath.biggestSimpleBinomials.length;
            this.simpleBinomial(2 * k, k);
            LongMathTest.fail((String)"Expected ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @AndroidIncompatible
    public void testLessThanBranchFree() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            for (long y : MathTesting.ALL_LONG_CANDIDATES) {
                BigInteger difference = BigInteger.valueOf(x).subtract(BigInteger.valueOf(y));
                if (!LongMathTest.fitsInLong(difference)) continue;
                int expected = x < y ? 1 : 0;
                int actual = LongMath.lessThanBranchFree((long)x, (long)y);
                LongMathTest.assertEquals((int)expected, (int)actual);
            }
        }
    }

    @GwtIncompatible
    private long simpleBinomial(int n, int k) {
        long accum = 1L;
        for (int i = 0; i < k; ++i) {
            accum = LongMath.checkedMultiply((long)accum, (long)(n - i));
            accum /= (long)(i + 1);
        }
        return accum;
    }

    @GwtIncompatible
    public void testIsPowerOfTwo() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            BigInteger bigX = BigInteger.valueOf(x);
            boolean expected = bigX.signum() > 0 && bigX.bitCount() == 1;
            LongMathTest.assertEquals((boolean)expected, (boolean)LongMath.isPowerOfTwo((long)x));
        }
    }

    public void testLog2ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                LongMath.log2((long)0L, (RoundingMode)mode);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testLog2NegativeAlwaysThrows() {
        for (long x : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    LongMath.log2((long)x, (RoundingMode)mode);
                    LongMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void testLog2MatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                LongMathTest.assertEquals((int)BigIntegerMath.log2((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (int)LongMath.log2((long)x, (RoundingMode)mode));
            }
        }
    }

    public void testLog2Exact() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            boolean isPowerOf2 = LongMath.isPowerOfTwo((long)x);
            try {
                LongMathTest.assertEquals((long)x, (long)(1L << LongMath.log2((long)x, (RoundingMode)RoundingMode.UNNECESSARY)));
                LongMathTest.assertTrue((boolean)isPowerOf2);
            }
            catch (ArithmeticException e) {
                LongMathTest.assertFalse((boolean)isPowerOf2);
            }
        }
    }

    @GwtIncompatible
    public void testLog10ZeroAlwaysThrows() {
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            try {
                LongMath.log10((long)0L, (RoundingMode)mode);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testLog10NegativeAlwaysThrows() {
        for (long x : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    LongMath.log10((long)x, (RoundingMode)mode);
                    LongMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @GwtIncompatible
    public void testLog10MatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                LongMathTest.assertEquals((int)BigIntegerMath.log10((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (int)LongMath.log10((long)x, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testLog10Exact() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            int floor = LongMath.log10((long)x, (RoundingMode)RoundingMode.FLOOR);
            boolean expectedSuccess = LongMath.pow((long)10L, (int)floor) == x;
            try {
                LongMathTest.assertEquals((int)floor, (int)LongMath.log10((long)x, (RoundingMode)RoundingMode.UNNECESSARY));
                LongMathTest.assertTrue((boolean)expectedSuccess);
            }
            catch (ArithmeticException e) {
                if (!expectedSuccess) continue;
                LongMathTest.failFormat("expected log10(%s, UNNECESSARY) = %s; got ArithmeticException", x, floor);
            }
        }
    }

    @GwtIncompatible
    public void testLog10TrivialOnPowerOf10() {
        long x = 1000000000000L;
        for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
            LongMathTest.assertEquals((int)12, (int)LongMath.log10((long)x, (RoundingMode)mode));
        }
    }

    @GwtIncompatible
    public void testSqrtNegativeAlwaysThrows() {
        for (long x : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    LongMath.sqrt((long)x, (RoundingMode)mode);
                    LongMathTest.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    @GwtIncompatible
    public void testSqrtMatchesBigInteger() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                LongMathTest.assertEquals((Object)BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(x), (RoundingMode)mode), (Object)BigInteger.valueOf(LongMath.sqrt((long)x, (RoundingMode)mode)));
            }
        }
    }

    @GwtIncompatible
    public void testSqrtExactMatchesFloorOrThrows() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long x = (Long)unmodifiableIterator.next();
            long sqrtFloor = LongMath.sqrt((long)x, (RoundingMode)RoundingMode.FLOOR);
            boolean isPerfectSquare = sqrtFloor * sqrtFloor == x;
            try {
                LongMathTest.assertEquals((long)sqrtFloor, (long)LongMath.sqrt((long)x, (RoundingMode)RoundingMode.UNNECESSARY));
                LongMathTest.assertTrue((boolean)isPerfectSquare);
            }
            catch (ArithmeticException e) {
                LongMathTest.assertFalse((boolean)isPerfectSquare);
            }
        }
    }

    @GwtIncompatible
    public void testPow() {
        for (long i : MathTesting.ALL_LONG_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int exp = (Integer)unmodifiableIterator.next();
                LongMathTest.assertEquals((long)LongMath.pow((long)i, (int)exp), (long)BigInteger.valueOf(i).pow(exp).longValue());
            }
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testDivNonZero() {
        for (long p : MathTesting.NONZERO_LONG_CANDIDATES) {
            for (long q : MathTesting.NONZERO_LONG_CANDIDATES) {
                for (RoundingMode mode : MathTesting.ALL_SAFE_ROUNDING_MODES) {
                    long actual;
                    long expected = new BigDecimal(BigInteger.valueOf(p)).divide(new BigDecimal(BigInteger.valueOf(q)), 0, mode).longValue();
                    if (expected == (actual = LongMath.divide((long)p, (long)q, (RoundingMode)mode))) continue;
                    LongMathTest.failFormat("expected divide(%s, %s, %s) = %s; got %s", new Object[]{p, q, mode, expected, actual});
                }
            }
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testDivNonZeroExact() {
        for (long p : MathTesting.NONZERO_LONG_CANDIDATES) {
            for (long q : MathTesting.NONZERO_LONG_CANDIDATES) {
                boolean expectedSuccess = p % q == 0L;
                try {
                    LongMathTest.assertEquals((long)p, (long)(LongMath.divide((long)p, (long)q, (RoundingMode)RoundingMode.UNNECESSARY) * q));
                    LongMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    if (!expectedSuccess) continue;
                    LongMathTest.failFormat("expected divide(%s, %s, UNNECESSARY) to succeed; got ArithmeticException", p, q);
                }
            }
        }
    }

    @GwtIncompatible
    public void testZeroDivIsAlwaysZero() {
        for (long q : MathTesting.NONZERO_LONG_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                LongMathTest.assertEquals((long)0L, (long)LongMath.divide((long)0L, (long)q, (RoundingMode)mode));
            }
        }
    }

    @GwtIncompatible
    public void testDivByZeroAlwaysFails() {
        for (long p : MathTesting.ALL_LONG_CANDIDATES) {
            for (RoundingMode mode : MathTesting.ALL_ROUNDING_MODES) {
                try {
                    LongMath.divide((long)p, (long)0L, (RoundingMode)mode);
                    LongMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException arithmeticException) {}
            }
        }
    }

    @GwtIncompatible
    public void testIntMod() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_INTEGER_CANDIDATES.iterator();
            while (unmodifiableIterator.hasNext()) {
                int m = (Integer)unmodifiableIterator.next();
                LongMathTest.assertEquals((int)BigInteger.valueOf(x).mod(BigInteger.valueOf(m)).intValue(), (int)LongMath.mod((long)x, (int)m));
            }
        }
    }

    @GwtIncompatible
    public void testIntModNegativeModulusFails() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            for (int m : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
                try {
                    LongMath.mod((long)x, (int)m);
                    LongMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException arithmeticException) {}
            }
        }
    }

    @GwtIncompatible
    public void testIntModZeroModulusFails() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            try {
                LongMath.mod((long)x, (int)0);
                LongMathTest.fail((String)"Expected AE");
            }
            catch (ArithmeticException arithmeticException) {}
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testMod() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
            while (unmodifiableIterator.hasNext()) {
                long m = (Long)unmodifiableIterator.next();
                LongMathTest.assertEquals((long)BigInteger.valueOf(x).mod(BigInteger.valueOf(m)).longValue(), (long)LongMath.mod((long)x, (long)m));
            }
        }
    }

    @GwtIncompatible
    public void testModNegativeModulusFails() {
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            for (long m : MathTesting.NEGATIVE_LONG_CANDIDATES) {
                try {
                    LongMath.mod((long)x, (long)m);
                    LongMathTest.fail((String)"Expected ArithmeticException");
                }
                catch (ArithmeticException arithmeticException) {}
            }
        }
    }

    public void testGCDExhaustive() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long a = (Long)unmodifiableIterator.next();
            UnmodifiableIterator unmodifiableIterator2 = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
            while (unmodifiableIterator2.hasNext()) {
                long b = (Long)unmodifiableIterator2.next();
                LongMathTest.assertEquals((Object)BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)), (Object)BigInteger.valueOf(LongMath.gcd((long)a, (long)b)));
            }
        }
    }

    @GwtIncompatible
    public void testGCDZero() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long a = (Long)unmodifiableIterator.next();
            LongMathTest.assertEquals((long)a, (long)LongMath.gcd((long)a, (long)0L));
            LongMathTest.assertEquals((long)a, (long)LongMath.gcd((long)0L, (long)a));
        }
        LongMathTest.assertEquals((long)0L, (long)LongMath.gcd((long)0L, (long)0L));
    }

    @GwtIncompatible
    public void testGCDNegativePositiveThrows() {
        for (long a : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            try {
                LongMath.gcd((long)a, (long)3L);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                LongMath.gcd((long)3L, (long)a);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testGCDNegativeZeroThrows() {
        for (long a : MathTesting.NEGATIVE_LONG_CANDIDATES) {
            try {
                LongMath.gcd((long)a, (long)0L);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                LongMath.gcd((long)0L, (long)a);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testCheckedAdd() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                BigInteger expectedResult = BigInteger.valueOf(a).add(BigInteger.valueOf(b));
                boolean expectedSuccess = LongMathTest.fitsInLong(expectedResult);
                try {
                    LongMathTest.assertEquals((long)(a + b), (long)LongMath.checkedAdd((long)a, (long)b));
                    LongMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    if (!expectedSuccess) continue;
                    LongMathTest.failFormat("expected checkedAdd(%s, %s) = %s; got ArithmeticException", a, b, expectedResult);
                }
            }
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testCheckedSubtract() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                BigInteger expectedResult = BigInteger.valueOf(a).subtract(BigInteger.valueOf(b));
                boolean expectedSuccess = LongMathTest.fitsInLong(expectedResult);
                try {
                    LongMathTest.assertEquals((long)(a - b), (long)LongMath.checkedSubtract((long)a, (long)b));
                    LongMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    if (!expectedSuccess) continue;
                    LongMathTest.failFormat("expected checkedSubtract(%s, %s) = %s; got ArithmeticException", a, b, expectedResult);
                }
            }
        }
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testCheckedMultiply() {
        boolean isAndroid = System.getProperties().getProperty("java.runtime.name").contains("Android");
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                if (isAndroid && a == -4294967296L && b == 0x80000000L) continue;
                BigInteger expectedResult = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
                boolean expectedSuccess = LongMathTest.fitsInLong(expectedResult);
                try {
                    LongMathTest.assertEquals((long)(a * b), (long)LongMath.checkedMultiply((long)a, (long)b));
                    LongMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    if (!expectedSuccess) continue;
                    LongMathTest.failFormat("expected checkedMultiply(%s, %s) = %s; got ArithmeticException", a, b, expectedResult);
                }
            }
        }
    }

    @GwtIncompatible
    public void testCheckedPow() {
        for (long b : MathTesting.ALL_LONG_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int exp = (Integer)unmodifiableIterator.next();
                BigInteger expectedResult = BigInteger.valueOf(b).pow(exp);
                boolean expectedSuccess = LongMathTest.fitsInLong(expectedResult);
                try {
                    LongMathTest.assertEquals((long)expectedResult.longValue(), (long)LongMath.checkedPow((long)b, (int)exp));
                    LongMathTest.assertTrue((boolean)expectedSuccess);
                }
                catch (ArithmeticException e) {
                    if (!expectedSuccess) continue;
                    LongMathTest.failFormat("expected checkedPow(%s, %s) = %s; got ArithmeticException", b, exp, expectedResult);
                }
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedAdd() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                this.assertOperationEquals(a, b, "s+", LongMathTest.saturatedCast(BigInteger.valueOf(a).add(BigInteger.valueOf(b))), LongMath.saturatedAdd((long)a, (long)b));
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedSubtract() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                this.assertOperationEquals(a, b, "s-", LongMathTest.saturatedCast(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b))), LongMath.saturatedSubtract((long)a, (long)b));
            }
        }
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testSaturatedMultiply() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            for (long b : MathTesting.ALL_LONG_CANDIDATES) {
                this.assertOperationEquals(a, b, "s*", LongMathTest.saturatedCast(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b))), LongMath.saturatedMultiply((long)a, (long)b));
            }
        }
    }

    @GwtIncompatible
    public void testSaturatedPow() {
        for (long a : MathTesting.ALL_LONG_CANDIDATES) {
            UnmodifiableIterator unmodifiableIterator = MathTesting.EXPONENTS.iterator();
            while (unmodifiableIterator.hasNext()) {
                int b = (Integer)unmodifiableIterator.next();
                this.assertOperationEquals(a, b, "s^", LongMathTest.saturatedCast(BigInteger.valueOf(a).pow(b)), LongMath.saturatedPow((long)a, (int)b));
            }
        }
    }

    private void assertOperationEquals(long a, long b, String op, long expected, long actual) {
        if (expected != actual) {
            LongMathTest.fail((String)("Expected for " + a + " " + op + " " + b + " = " + expected + ", but got " + actual));
        }
    }

    @GwtIncompatible
    public void testFactorial() {
        for (int n = 0; n <= 50; ++n) {
            BigInteger expectedBig = BigIntegerMath.factorial((int)n);
            long expectedLong = LongMathTest.fitsInLong(expectedBig) ? expectedBig.longValue() : Long.MAX_VALUE;
            LongMathTest.assertEquals((long)expectedLong, (long)LongMath.factorial((int)n));
        }
    }

    @GwtIncompatible
    public void testFactorialNegative() {
        for (int n : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                LongMath.factorial((int)n);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testBinomial() {
        for (int n = 0; n <= 70; ++n) {
            for (int k = 0; k <= n; ++k) {
                BigInteger expectedBig = BigIntegerMath.binomial((int)n, (int)k);
                long expectedLong = LongMathTest.fitsInLong(expectedBig) ? expectedBig.longValue() : Long.MAX_VALUE;
                LongMathTest.assertEquals((long)expectedLong, (long)LongMath.binomial((int)n, (int)k));
            }
        }
    }

    @GwtIncompatible
    public void testBinomial_exhaustiveNotOverflowing() {
        for (int k = 3; k < LongMath.biggestBinomials.length; ++k) {
            for (int n = 70; n <= LongMath.biggestBinomials[k]; ++n) {
                LongMathTest.assertEquals((long)BigIntegerMath.binomial((int)n, (int)k).longValue(), (long)LongMath.binomial((int)n, (int)k));
            }
        }
    }

    public void testBinomialOutside() {
        for (int n = 0; n <= 50; ++n) {
            try {
                LongMath.binomial((int)n, (int)-1);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                LongMath.binomial((int)n, (int)(n + 1));
                LongMathTest.fail((String)"Expected IllegalArgumentException");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testBinomialNegative() {
        for (int n : MathTesting.NEGATIVE_INTEGER_CANDIDATES) {
            try {
                LongMath.binomial((int)n, (int)0);
                LongMathTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @GwtIncompatible
    public void testSqrtOfPerfectSquareAsDoubleIsPerfect() {
        for (long n = 0L; n <= 3037000499L; ++n) {
            long actual = (long)Math.sqrt(n * n);
            LongMathTest.assertTrue((actual == n ? 1 : 0) != 0);
        }
    }

    public void testSqrtOfLongIsAtMostFloorSqrtMaxLong() {
        long sqrtMaxLong = (long)Math.sqrt(9.223372036854776E18);
        LongMathTest.assertTrue((sqrtMaxLong <= 3037000499L ? 1 : 0) != 0);
    }

    @AndroidIncompatible
    @GwtIncompatible
    public void testMean() {
        LongMathTest.assertMean(2L, 1L, 3L);
        LongMathTest.assertMean(-2L, -3L, -1L);
        LongMathTest.assertMean(0L, -1L, 1L);
        LongMathTest.assertMean(1L, -1L, 3L);
        LongMathTest.assertMean(0x3FFFFFFFFFFFFFFFL, -1L, Long.MAX_VALUE);
        LongMathTest.assertMean(2L, 1L, 4L);
        LongMathTest.assertMean(-3L, -4L, -1L);
        LongMathTest.assertMean(0L, -1L, 2L);
        LongMathTest.assertMean(0L, -9223372036854775806L, Long.MAX_VALUE);
        LongMathTest.assertMean(0L, 0L, 1L);
        LongMathTest.assertMean(-1L, -1L, 0L);
        LongMathTest.assertMean(-1L, Long.MIN_VALUE, Long.MAX_VALUE);
        LongMathTest.assertMean(1L, 1L, 1L);
        LongMathTest.assertMean(0L, 0L, 0L);
        LongMathTest.assertMean(-1L, -1L, -1L);
        LongMathTest.assertMean(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        LongMathTest.assertMean(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        for (long x : MathTesting.ALL_LONG_CANDIDATES) {
            for (long y : MathTesting.ALL_LONG_CANDIDATES) {
                LongMathTest.assertMean(x, y);
            }
        }
    }

    private static void assertMean(long expectedMean, long x, long y) {
        LongMathTest.assertEquals((String)"The expectedMean should be the same as computeMeanSafely", (long)expectedMean, (long)LongMathTest.computeMeanSafely(x, y));
        LongMathTest.assertMean(x, y);
    }

    private static void assertMean(long x, long y) {
        long expectedMean = LongMathTest.computeMeanSafely(x, y);
        LongMathTest.assertEquals((long)expectedMean, (long)LongMath.mean((long)x, (long)y));
        LongMathTest.assertEquals((String)"The mean of x and y should equal the mean of y and x", (long)expectedMean, (long)LongMath.mean((long)y, (long)x));
    }

    private static long computeMeanSafely(long x, long y) {
        BigInteger bigX = BigInteger.valueOf(x);
        BigInteger bigY = BigInteger.valueOf(y);
        BigDecimal bigMean = new BigDecimal(bigX.add(bigY)).divide(BigDecimal.valueOf(2L), 3);
        return Long.parseLong(bigMean.toString());
    }

    private static boolean fitsInLong(BigInteger big) {
        return big.bitLength() <= 63;
    }

    private static long saturatedCast(BigInteger big) {
        if (big.compareTo(MAX_LONG) > 0) {
            return Long.MAX_VALUE;
        }
        if (big.compareTo(MIN_LONG) < 0) {
            return Long.MIN_VALUE;
        }
        return big.longValue();
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.setDefault(Integer.TYPE, (Object)1);
        tester.setDefault(Long.TYPE, (Object)1L);
        tester.testAllPublicStaticMethods(LongMath.class);
    }

    @GwtIncompatible
    public void testIsPrimeSmall() {
        for (int i = 2; i < 1000; ++i) {
            LongMathTest.assertEquals((boolean)BigInteger.valueOf(i).isProbablePrime(100), (boolean)LongMath.isPrime((long)i));
        }
    }

    @GwtIncompatible
    public void testIsPrimeManyConstants() {
        UnmodifiableIterator unmodifiableIterator = MathTesting.POSITIVE_LONG_CANDIDATES.iterator();
        while (unmodifiableIterator.hasNext()) {
            long l = (Long)unmodifiableIterator.next();
            LongMathTest.assertEquals((boolean)BigInteger.valueOf(l).isProbablePrime(100), (boolean)LongMath.isPrime((long)l));
        }
    }

    @GwtIncompatible
    public void testIsPrimeOnUniformRandom() {
        Random rand = new Random(1L);
        for (int bits = 10; bits < 63; ++bits) {
            for (int i = 0; i < 2000; ++i) {
                long l = rand.nextLong() & (1L << bits) - 1L;
                LongMathTest.assertEquals((boolean)BigInteger.valueOf(l).isProbablePrime(100), (boolean)LongMath.isPrime((long)l));
            }
        }
    }

    @GwtIncompatible
    public void testIsPrimeOnRandomPrimes() {
        Random rand = new Random(1L);
        for (int bits = 10; bits < 63; ++bits) {
            for (int i = 0; i < 100; ++i) {
                long p = BigInteger.probablePrime(bits, rand).longValue();
                LongMathTest.assertTrue((boolean)LongMath.isPrime((long)p));
            }
        }
    }

    @GwtIncompatible
    public void testIsPrimeOnRandomComposites() {
        Random rand = new Random(1L);
        for (int bits = 5; bits < 32; ++bits) {
            for (int i = 0; i < 100; ++i) {
                long p = BigInteger.probablePrime(bits, rand).longValue();
                long q = BigInteger.probablePrime(bits, rand).longValue();
                LongMathTest.assertFalse((boolean)LongMath.isPrime((long)(p * q)));
            }
        }
    }

    @GwtIncompatible
    public void testIsPrimeThrowsOnNegative() {
        try {
            LongMath.isPrime((long)-1L);
            LongMathTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    private static void failFormat(String template, Object ... args) {
        LongMathTest.fail((String)String.format(template, args));
    }
}

