/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.math.AndroidIncompatible;
import com.google.common.math.IntMath;
import com.google.common.math.Quantiles;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.truth.Correspondence;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import junit.framework.TestCase;

public class QuantilesTest
extends TestCase {
    private static final double ALLOWED_ERROR = 1.0E-10;
    private static final Correspondence<Number, Number> FINITE_QUANTILE_CORRESPONDENCE = Correspondence.tolerance((double)1.0E-10);
    private static final Correspondence<Double, Double> QUANTILE_CORRESPONDENCE = new Correspondence<Double, Double>(){

        public boolean compare(@Nullable Double actual, @Nullable Double expected) {
            return actual.equals(expected) || FINITE_QUANTILE_CORRESPONDENCE.compare((Object)actual, (Object)expected);
        }

        public String toString() {
            return "is identical to or " + FINITE_QUANTILE_CORRESPONDENCE;
        }
    };
    private static final ImmutableList<Double> SIXTEEN_SQUARES_DOUBLES = ImmutableList.of((Object)25.0, (Object)100.0, (Object)0.0, (Object)144.0, (Object)9.0, (Object)121.0, (Object)4.0, (Object)225.0, (Object)169.0, (Object)64.0, (Object)49.0, (Object)16.0, (Object[])new Double[]{36.0, 1.0, 81.0, 196.0});
    private static final ImmutableList<Long> SIXTEEN_SQUARES_LONGS = ImmutableList.of((Object)25L, (Object)100L, (Object)0L, (Object)144L, (Object)9L, (Object)121L, (Object)4L, (Object)225L, (Object)169L, (Object)64L, (Object)49L, (Object)16L, (Object[])new Long[]{36L, 1L, 81L, 196L});
    private static final ImmutableList<Integer> SIXTEEN_SQUARES_INTEGERS = ImmutableList.of((Object)25, (Object)100, (Object)0, (Object)144, (Object)9, (Object)121, (Object)4, (Object)225, (Object)169, (Object)64, (Object)49, (Object)16, (Object[])new Integer[]{36, 1, 81, 196});
    private static final double SIXTEEN_SQUARES_MIN = 0.0;
    private static final double SIXTEEN_SQUARES_DECILE_1 = 2.5;
    private static final double SIXTEEN_SQUARES_QUARTILE_1 = 14.25;
    private static final double SIXTEEN_SQUARES_MEDIAN = 56.5;
    private static final double SIXTEEN_SQUARES_QUARTILE_3 = 126.75;
    private static final double SIXTEEN_SQUARES_DECILE_8 = 144.0;
    private static final double SIXTEEN_SQUARES_MAX = 225.0;
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_POSITIVE_INFINITY = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.POSITIVE_INFINITY, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_NEGATIVE_INFINITY = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final ImmutableList<Double> NEGATIVE_INFINITY_AND_FIVE_POSITIVE_INFINITIES = ImmutableList.of((Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY, (Object)Double.POSITIVE_INFINITY);
    private static final ImmutableList<Double> ONE_TO_FIVE_AND_NAN = ImmutableList.of((Object)3.0, (Object)5.0, (Object)Double.NaN, (Object)1.0, (Object)4.0, (Object)2.0);
    private static final int PSEUDORANDOM_DATASET_SIZE = 9951;
    private static final ImmutableList<Double> PSEUDORANDOM_DATASET = QuantilesTest.generatePseudorandomDataset();
    private static final ImmutableList<Double> PSEUDORANDOM_DATASET_SORTED = Ordering.natural().immutableSortedCopy(PSEUDORANDOM_DATASET);
    private static final ImmutableList<Double> EMPTY_DATASET = ImmutableList.of();

    public void testMedian_compute_doubleCollection() {
        Truth.assertThat((Double)Quantiles.median().compute(SIXTEEN_SQUARES_DOUBLES)).isWithin(1.0E-10).of(56.5);
    }

    public void testMedian_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Double)Quantiles.median().computeInPlace(dataset)).isWithin(1.0E-10).of(56.5);
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testQuartiles_index_compute_doubleCollection() {
        Truth.assertThat((Double)Quantiles.quartiles().index(1).compute(SIXTEEN_SQUARES_DOUBLES)).isWithin(1.0E-10).of(14.25);
    }

    public void testQuartiles_index_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Double)Quantiles.quartiles().index(1).computeInPlace(dataset)).isWithin(1.0E-10).of(14.25);
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testQuartiles_indexes_varargs_compute_doubleCollection() {
        Truth.assertThat((Map)Quantiles.quartiles().indexes(new int[]{1, 3}).compute(SIXTEEN_SQUARES_DOUBLES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)1, (Object)14.25, new Object[]{3, 126.75});
    }

    public void testQuartiles_indexes_varargs_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Map)Quantiles.quartiles().indexes(new int[]{1, 3}).computeInPlace(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)1, (Object)14.25, new Object[]{3, 126.75});
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testScale_index_compute_doubleCollection() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_DOUBLES)).isWithin(1.0E-10).of(2.5);
    }

    public void testScale_index_compute_longCollection() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_LONGS)).isWithin(1.0E-10).of(2.5);
    }

    public void testScale_index_compute_integerCollection() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(SIXTEEN_SQUARES_INTEGERS)).isWithin(1.0E-10).of(2.5);
    }

    public void testScale_index_compute_doubleVarargs() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(dataset)).isWithin(1.0E-10).of(2.5);
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES).inOrder();
    }

    public void testScale_index_compute_longVarargs() {
        long[] dataset = Longs.toArray(SIXTEEN_SQUARES_LONGS);
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(dataset)).isWithin(1.0E-10).of(2.5);
        Truth.assertThat((long[])dataset).asList().isEqualTo(SIXTEEN_SQUARES_LONGS);
    }

    public void testScale_index_compute_intVarargs() {
        int[] dataset = Ints.toArray(SIXTEEN_SQUARES_INTEGERS);
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(dataset)).isWithin(1.0E-10).of(2.5);
        Truth.assertThat((int[])dataset).asList().isEqualTo(SIXTEEN_SQUARES_INTEGERS);
    }

    public void testScale_index_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).computeInPlace(dataset)).isWithin(1.0E-10).of(2.5);
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testScale_index_computeInPlace_explicitVarargs() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(5).computeInPlace(new double[]{78.9, 12.3, 45.6})).isWithin(1.0E-10).of(45.6);
    }

    public void testScale_indexes_varargs_compute_doubleCollection() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_DOUBLES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
    }

    public void testScale_indexes_varargs_compute_doubleCollection_snapshotsIndexes() {
        int[] indexes = new int[]{0, 10, 5, 1, 8, 10};
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(indexes);
        indexes[0] = 3;
        Truth.assertThat((Map)intermediate.compute(SIXTEEN_SQUARES_DOUBLES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
    }

    public void testScale_indexes_largeVarargs_compute_doubleCollection() {
        int scale = Integer.MAX_VALUE;
        int otherIndex = 0x2AAAAAAA;
        double otherValue = 24.999999979045242;
        Truth.assertThat((Map)Quantiles.scale((int)scale).indexes(new int[]{0, scale, otherIndex}).compute(SIXTEEN_SQUARES_DOUBLES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{scale, 225.0, otherIndex, otherValue});
    }

    public void testScale_indexes_varargs_compute_longCollection() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_LONGS)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
    }

    public void testScale_indexes_varargs_compute_integerCollection() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(SIXTEEN_SQUARES_INTEGERS)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
    }

    public void testScale_indexes_varargs_compute_doubleVarargs() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES).inOrder();
    }

    public void testScale_indexes_varargs_compute_longVarargs() {
        long[] dataset = Longs.toArray(SIXTEEN_SQUARES_LONGS);
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
        Truth.assertThat((long[])dataset).asList().isEqualTo(SIXTEEN_SQUARES_LONGS);
    }

    public void testScale_indexes_varargs_compute_intVarargs() {
        int[] dataset = Ints.toArray(SIXTEEN_SQUARES_INTEGERS);
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).compute(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
        Truth.assertThat((int[])dataset).asList().isEqualTo(SIXTEEN_SQUARES_INTEGERS);
    }

    public void testScale_indexes_varargs_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10, 5, 1, 8, 1}).computeInPlace(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testScale_indexes_varargs_computeInPlace_explicitVarargs() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 10}).computeInPlace(new double[]{78.9, 12.3, 45.6})).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)12.3, new Object[]{10, 78.9});
    }

    public void testScale_indexes_collection_compute_doubleCollection() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes((Collection)ImmutableList.of((Object)0, (Object)10, (Object)5, (Object)1, (Object)8, (Object)1)).compute(SIXTEEN_SQUARES_DOUBLES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
    }

    public void testScale_indexes_collection_computeInPlace() {
        double[] dataset = Doubles.toArray(SIXTEEN_SQUARES_DOUBLES);
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes((Collection)ImmutableList.of((Object)0, (Object)10, (Object)5, (Object)1, (Object)8, (Object)1)).computeInPlace(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)0.0, new Object[]{10, 225.0, 5, 56.5, 1, 2.5, 8, 144.0});
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(SIXTEEN_SQUARES_DOUBLES);
    }

    public void testScale_indexes_varargs_compute_doubleCollection_positiveInfinity() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_POSITIVE_INFINITY)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)1.0, new Object[]{1, 1.5, 2, 2.0, 8, 5.0, 9, Double.POSITIVE_INFINITY, 10, Double.POSITIVE_INFINITY});
    }

    public void testScale_index_compute_doubleCollection_positiveInfinity() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(9).compute(ONE_TO_FIVE_AND_POSITIVE_INFINITY)).isPositiveInfinity();
    }

    public void testScale_indexes_varargs_compute_doubleCollection_negativeInfinity() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_NEGATIVE_INFINITY)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)Double.NEGATIVE_INFINITY, new Object[]{1, Double.NEGATIVE_INFINITY, 2, 1.0, 8, 4.0, 9, 4.5, 10, 5.0});
    }

    public void testScale_index_compute_doubleCollection_negativeInfinity() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(1).compute(ONE_TO_FIVE_AND_NEGATIVE_INFINITY)).isNegativeInfinity();
    }

    public void testScale_indexes_varargs_compute_doubleCollection_bothInfinities() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(NEGATIVE_INFINITY_AND_FIVE_POSITIVE_INFINITIES)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)Double.NEGATIVE_INFINITY, new Object[]{1, Double.NaN, 2, Double.POSITIVE_INFINITY, 8, Double.POSITIVE_INFINITY, 9, Double.POSITIVE_INFINITY, 10, Double.POSITIVE_INFINITY});
    }

    public void testScale_indexes_varargs_compute_doubleCollection_nan() {
        Truth.assertThat((Map)Quantiles.scale((int)10).indexes(new int[]{0, 1, 2, 8, 9, 10}).compute(ONE_TO_FIVE_AND_NAN)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactly((Object)0, (Object)Double.NaN, new Object[]{1, Double.NaN, 2, Double.NaN, 8, Double.NaN, 9, Double.NaN, 10, Double.NaN});
    }

    public void testScale_index_compute_doubleCollection_nan() {
        Truth.assertThat((Double)Quantiles.scale((int)10).index(5).compute(ONE_TO_FIVE_AND_NAN)).isNaN();
    }

    private static ImmutableList<Double> generatePseudorandomDataset() {
        Random random = new Random(2211275185798966364L);
        ImmutableList.Builder largeDatasetBuilder = ImmutableList.builder();
        for (int i = 0; i < 9951; ++i) {
            largeDatasetBuilder.add((Object)random.nextGaussian());
        }
        return largeDatasetBuilder.build();
    }

    private static double expectedLargeDatasetPercentile(int index) {
        if (index % 2 == 0) {
            int position = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.UNNECESSARY);
            return (Double)PSEUDORANDOM_DATASET_SORTED.get(position);
        }
        int positionFloor = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.FLOOR);
        int positionCeil = IntMath.divide((int)(199 * index), (int)2, (RoundingMode)RoundingMode.CEILING);
        double lowerValue = (Double)PSEUDORANDOM_DATASET_SORTED.get(positionFloor);
        double upperValue = (Double)PSEUDORANDOM_DATASET_SORTED.get(positionCeil);
        return (lowerValue + upperValue) / 2.0;
    }

    public void testPercentiles_index_compute_doubleCollection() {
        for (int index = 0; index <= 100; ++index) {
            ((DoubleSubject)Truth.assertThat((Double)Quantiles.percentiles().index(index).compute(PSEUDORANDOM_DATASET)).named("quantile at index " + index, new Object[0])).isWithin(1.0E-10).of(QuantilesTest.expectedLargeDatasetPercentile(index));
        }
    }

    @AndroidIncompatible
    public void testPercentiles_index_computeInPlace() {
        for (int index = 0; index <= 100; ++index) {
            double[] dataset = Doubles.toArray(PSEUDORANDOM_DATASET);
            ((DoubleSubject)Truth.assertThat((Double)Quantiles.percentiles().index(index).computeInPlace(dataset)).named("quantile at index " + index, new Object[0])).isWithin(1.0E-10).of(QuantilesTest.expectedLargeDatasetPercentile(index));
        }
        double[] dataset = Doubles.toArray(PSEUDORANDOM_DATASET);
        double actual = Quantiles.percentiles().index(33).computeInPlace(dataset);
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(PSEUDORANDOM_DATASET);
    }

    public void testPercentiles_indexes_varargsPairs_compute_doubleCollection() {
        for (int index1 = 0; index1 <= 100; ++index1) {
            int index2 = 0;
            while (index2 <= 100) {
                ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
                expectedBuilder.put((Object)index1, (Object)QuantilesTest.expectedLargeDatasetPercentile(index1));
                if (index2 != index1) {
                    expectedBuilder.put((Object)index2, (Object)QuantilesTest.expectedLargeDatasetPercentile(index2));
                }
                Truth.assertThat((Map)Quantiles.percentiles().indexes(new int[]{index1, index2++}).compute(PSEUDORANDOM_DATASET)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactlyEntriesIn((Map)expectedBuilder.build());
            }
        }
    }

    public void testPercentiles_indexes_varargsAll_compute_doubleCollection() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
        for (int index = 0; index <= 100; ++index) {
            indexes.add(index);
            expectedBuilder.put((Object)index, (Object)QuantilesTest.expectedLargeDatasetPercentile(index));
        }
        Random random = new Random(770683168895677741L);
        Collections.shuffle(indexes, random);
        Truth.assertThat((Map)Quantiles.percentiles().indexes(Ints.toArray(indexes)).compute(PSEUDORANDOM_DATASET)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactlyEntriesIn((Map)expectedBuilder.build());
    }

    @AndroidIncompatible
    public void testPercentiles_indexes_varargsAll_computeInPlace() {
        double[] dataset = Doubles.toArray(PSEUDORANDOM_DATASET);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ImmutableMap.Builder expectedBuilder = ImmutableMap.builder();
        for (int index = 0; index <= 100; ++index) {
            indexes.add(index);
            expectedBuilder.put((Object)index, (Object)QuantilesTest.expectedLargeDatasetPercentile(index));
        }
        Random random = new Random(770683168895677741L);
        Collections.shuffle(indexes, random);
        Truth.assertThat((Map)Quantiles.percentiles().indexes(Ints.toArray(indexes)).computeInPlace(dataset)).comparingValuesUsing(QUANTILE_CORRESPONDENCE).containsExactlyEntriesIn((Map)expectedBuilder.build());
        Truth.assertThat((double[])dataset).usingExactEquality().containsExactlyElementsIn(PSEUDORANDOM_DATASET);
    }

    public void testScale_zero() {
        try {
            Quantiles.scale((int)0);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_negative() {
        try {
            Quantiles.scale((int)-4);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.index(-1);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.index(11);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes(new int[]{1, -1, 3});
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes(new int[]{1, 11, 3});
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_collection_negative() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes((Collection)ImmutableList.of((Object)1, (Object)-1, (Object)3));
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_collection_tooHigh() {
        Quantiles.Scale intermediate = Quantiles.scale((int)10);
        try {
            intermediate.indexes((Collection)ImmutableList.of((Object)1, (Object)11, (Object)3));
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_doubleCollection_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(EMPTY_DATASET);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_doubleVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_longVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new long[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_compute_intVarargs_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.compute(new int[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_index_computeInPlace_empty() {
        Quantiles.ScaleAndIndex intermediate = Quantiles.scale((int)10).index(3);
        try {
            intermediate.computeInPlace(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_doubleCollection_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(EMPTY_DATASET);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_doubleVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_longVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new long[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_compute_intVarargs_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.compute(new int[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testScale_indexes_varargs_computeInPlace_empty() {
        Quantiles.ScaleAndIndexes intermediate = Quantiles.scale((int)10).indexes(new int[]{1, 3, 5});
        try {
            intermediate.computeInPlace(new double[0]);
            QuantilesTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

