/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Bytes;
import com.google.common.testing.NullPointerTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class BytesTest
extends TestCase {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] ARRAY1 = new byte[]{1};
    private static final byte[] ARRAY234 = new byte[]{2, 3, 4};
    private static final byte[] VALUES = new byte[]{-128, -1, 0, 1, 127};

    public void testHashCode() {
        for (byte value : VALUES) {
            BytesTest.assertEquals((int)Byte.valueOf(value).hashCode(), (int)Bytes.hashCode((byte)value));
        }
    }

    public void testContains() {
        BytesTest.assertFalse((boolean)Bytes.contains((byte[])EMPTY, (byte)1));
        BytesTest.assertFalse((boolean)Bytes.contains((byte[])ARRAY1, (byte)2));
        BytesTest.assertFalse((boolean)Bytes.contains((byte[])ARRAY234, (byte)1));
        BytesTest.assertTrue((boolean)Bytes.contains((byte[])new byte[]{-1}, (byte)-1));
        BytesTest.assertTrue((boolean)Bytes.contains((byte[])ARRAY234, (byte)2));
        BytesTest.assertTrue((boolean)Bytes.contains((byte[])ARRAY234, (byte)3));
        BytesTest.assertTrue((boolean)Bytes.contains((byte[])ARRAY234, (byte)4));
    }

    public void testIndexOf() {
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])EMPTY, (byte)1));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])ARRAY1, (byte)2));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])ARRAY234, (byte)1));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])new byte[]{-1}, (byte)-1));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])ARRAY234, (byte)2));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])ARRAY234, (byte)3));
        BytesTest.assertEquals((int)2, (int)Bytes.indexOf((byte[])ARRAY234, (byte)4));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])new byte[]{2, 3, 2, 3}, (byte)3));
    }

    public void testIndexOf_arrayTarget() {
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])EMPTY, (byte[])EMPTY));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])EMPTY));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])EMPTY, (byte[])ARRAY234));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])ARRAY1));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])ARRAY1, (byte[])ARRAY234));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])ARRAY1, (byte[])ARRAY1));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])ARRAY234));
        BytesTest.assertEquals((int)0, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])new byte[]{2, 3}));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])new byte[]{3, 4}));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])new byte[]{3}));
        BytesTest.assertEquals((int)2, (int)Bytes.indexOf((byte[])ARRAY234, (byte[])new byte[]{4}));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])new byte[]{2, 3, 3, 3, 3}, (byte[])new byte[]{3}));
        BytesTest.assertEquals((int)2, (int)Bytes.indexOf((byte[])new byte[]{2, 3, 2, 3, 4, 2, 3}, (byte[])new byte[]{2, 3, 4}));
        BytesTest.assertEquals((int)1, (int)Bytes.indexOf((byte[])new byte[]{2, 2, 3, 4, 2, 3, 4}, (byte[])new byte[]{2, 3, 4}));
        BytesTest.assertEquals((int)-1, (int)Bytes.indexOf((byte[])new byte[]{4, 3, 2}, (byte[])new byte[]{2, 3, 4}));
    }

    public void testLastIndexOf() {
        BytesTest.assertEquals((int)-1, (int)Bytes.lastIndexOf((byte[])EMPTY, (byte)1));
        BytesTest.assertEquals((int)-1, (int)Bytes.lastIndexOf((byte[])ARRAY1, (byte)2));
        BytesTest.assertEquals((int)-1, (int)Bytes.lastIndexOf((byte[])ARRAY234, (byte)1));
        BytesTest.assertEquals((int)0, (int)Bytes.lastIndexOf((byte[])new byte[]{-1}, (byte)-1));
        BytesTest.assertEquals((int)0, (int)Bytes.lastIndexOf((byte[])ARRAY234, (byte)2));
        BytesTest.assertEquals((int)1, (int)Bytes.lastIndexOf((byte[])ARRAY234, (byte)3));
        BytesTest.assertEquals((int)2, (int)Bytes.lastIndexOf((byte[])ARRAY234, (byte)4));
        BytesTest.assertEquals((int)3, (int)Bytes.lastIndexOf((byte[])new byte[]{2, 3, 2, 3}, (byte)3));
    }

    public void testConcat() {
        BytesTest.assertTrue((boolean)Arrays.equals(EMPTY, Bytes.concat((byte[][])new byte[0][])));
        BytesTest.assertTrue((boolean)Arrays.equals(EMPTY, Bytes.concat((byte[][])new byte[][]{EMPTY})));
        BytesTest.assertTrue((boolean)Arrays.equals(EMPTY, Bytes.concat((byte[][])new byte[][]{EMPTY, EMPTY, EMPTY})));
        BytesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Bytes.concat((byte[][])new byte[][]{ARRAY1})));
        BytesTest.assertNotSame((Object)ARRAY1, (Object)Bytes.concat((byte[][])new byte[][]{ARRAY1}));
        BytesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Bytes.concat((byte[][])new byte[][]{EMPTY, ARRAY1, EMPTY})));
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 1, 1}, Bytes.concat((byte[][])new byte[][]{ARRAY1, ARRAY1, ARRAY1})));
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4}, Bytes.concat((byte[][])new byte[][]{ARRAY1, ARRAY234})));
    }

    public void testEnsureCapacity() {
        BytesTest.assertSame((Object)EMPTY, (Object)Bytes.ensureCapacity((byte[])EMPTY, (int)0, (int)1));
        BytesTest.assertSame((Object)ARRAY1, (Object)Bytes.ensureCapacity((byte[])ARRAY1, (int)0, (int)1));
        BytesTest.assertSame((Object)ARRAY1, (Object)Bytes.ensureCapacity((byte[])ARRAY1, (int)1, (int)1));
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 0, 0}, Bytes.ensureCapacity((byte[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Bytes.ensureCapacity((byte[])ARRAY1, (int)-1, (int)1);
            BytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Bytes.ensureCapacity((byte[])ARRAY1, (int)1, (int)-1);
            BytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToArray() {
        List<Byte> none = Arrays.asList(new Byte[0]);
        BytesTest.assertTrue((boolean)Arrays.equals(EMPTY, Bytes.toArray(none)));
        List<Byte> one = Arrays.asList((byte)1);
        BytesTest.assertTrue((boolean)Arrays.equals(ARRAY1, Bytes.toArray(one)));
        byte[] array = new byte[]{0, 1, 85};
        List<Byte> three = Arrays.asList((byte)0, (byte)1, (byte)85);
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(three)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray((Collection)Bytes.asList((byte[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Bytes.asList((byte[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                byte[] arr = Bytes.toArray((Collection)misleadingSize);
                BytesTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    BytesTest.assertEquals((byte)VALUES[j], (byte)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Byte> list = Arrays.asList((byte)0, (byte)1, null);
        try {
            Bytes.toArray(list);
            BytesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        byte[] array = new byte[]{0, 1, 2};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(bytes)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(shorts)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(ints)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(floats)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(longs)));
        BytesTest.assertTrue((boolean)Arrays.equals(array, Bytes.toArray(doubles)));
    }

    public void testAsList_isAView() {
        byte[] array = new byte[]{0, 1};
        List list = Bytes.asList((byte[])array);
        list.set(0, (byte)2);
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, array));
        array[1] = 3;
        BytesTest.assertEquals(Arrays.asList((byte)2, (byte)3), (Object)list);
    }

    public void testAsList_toArray_roundTrip() {
        byte[] array = new byte[]{0, 1, 2};
        List list = Bytes.asList((byte[])array);
        byte[] newArray = Bytes.toArray((Collection)list);
        list.set(0, (byte)4);
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, newArray));
        newArray[1] = 5;
        BytesTest.assertEquals((byte)1, (byte)((Byte)list.get(1)));
    }

    public void testAsList_subList_toArray_roundTrip() {
        byte[] array = new byte[]{0, 1, 2, 3};
        List list = Bytes.asList((byte[])array);
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2}, Bytes.toArray(list.subList(1, 3))));
        BytesTest.assertTrue((boolean)Arrays.equals(new byte[0], Bytes.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        BytesTest.assertSame(Collections.emptyList(), (Object)Bytes.asList((byte[])EMPTY));
    }

    public void testReverse() {
        BytesTest.testReverse(new byte[0], new byte[0]);
        BytesTest.testReverse(new byte[]{1}, new byte[]{1});
        BytesTest.testReverse(new byte[]{1, 2}, new byte[]{2, 1});
        BytesTest.testReverse(new byte[]{3, 1, 1}, new byte[]{1, 1, 3});
        BytesTest.testReverse(new byte[]{-1, 1, -2, 2}, new byte[]{2, -2, 1, -1});
    }

    public void testReverseIndexed() {
        BytesTest.testReverse(new byte[0], 0, 0, new byte[0]);
        BytesTest.testReverse(new byte[]{1}, 0, 1, new byte[]{1});
        BytesTest.testReverse(new byte[]{1, 2}, 0, 2, new byte[]{2, 1});
        BytesTest.testReverse(new byte[]{3, 1, 1}, 0, 2, new byte[]{1, 3, 1});
        BytesTest.testReverse(new byte[]{3, 1, 1}, 0, 1, new byte[]{3, 1, 1});
        BytesTest.testReverse(new byte[]{-1, 1, -2, 2}, 1, 3, new byte[]{-1, -2, 1, 2});
    }

    private static void testReverse(byte[] input, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Bytes.reverse((byte[])input);
        BytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    private static void testReverse(byte[] input, int fromIndex, int toIndex, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Bytes.reverse((byte[])input, (int)fromIndex, (int)toIndex);
        BytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Bytes.class);
    }
}

