/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Chars;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class CharArrayAsListTest
extends TestCase {
    private static List<Character> asList(Character[] values) {
        char[] temp = new char[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = ((Character)Preconditions.checkNotNull((Object)values[i])).charValue();
        }
        return Chars.asList((char[])temp);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new CharsAsListGenerator()).named("Chars.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new CharsAsListHeadSubListGenerator()).named("Chars.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new CharsAsListTailSubListGenerator()).named("Chars.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new CharsAsListMiddleSubListGenerator()).named("Chars.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Character[] concat(Character[] left, Character[] right) {
        Character[] result = new Character[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static class SampleChars
    extends SampleElements<Character> {
        public SampleChars() {
            super((Object)Character.valueOf('\u0000'), (Object)Character.valueOf('\u0001'), (Object)Character.valueOf('\u0002'), (Object)Character.valueOf('\u0003'), (Object)Character.valueOf('\u0004'));
        }
    }

    public static abstract class TestCharListGenerator
    implements TestListGenerator<Character> {
        public SampleElements<Character> samples() {
            return new SampleChars();
        }

        public List<Character> create(Object ... elements) {
            Character[] array = new Character[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Character)e;
            }
            return this.create(array);
        }

        protected abstract List<Character> create(Character[] var1);

        public Character[] createArray(int length) {
            return new Character[length];
        }

        public List<Character> order(List<Character> insertionOrder) {
            return insertionOrder;
        }
    }

    public static final class CharsAsListMiddleSubListGenerator
    extends TestCharListGenerator {
        @Override
        protected List<Character> create(Character[] elements) {
            Character[] prefix = new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff')};
            Character[] suffix = new Character[]{Character.valueOf('V'), Character.valueOf('c')};
            Character[] all = CharArrayAsListTest.concat(CharArrayAsListTest.concat(prefix, elements), suffix);
            return CharArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class CharsAsListTailSubListGenerator
    extends TestCharListGenerator {
        @Override
        protected List<Character> create(Character[] elements) {
            Character[] prefix = new Character[]{Character.valueOf('V'), Character.valueOf('c')};
            Character[] all = CharArrayAsListTest.concat(prefix, elements);
            return CharArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class CharsAsListHeadSubListGenerator
    extends TestCharListGenerator {
        @Override
        protected List<Character> create(Character[] elements) {
            Character[] suffix = new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff')};
            Character[] all = CharArrayAsListTest.concat(elements, suffix);
            return CharArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    public static final class CharsAsListGenerator
    extends TestCharListGenerator {
        @Override
        protected List<Character> create(Character[] elements) {
            return CharArrayAsListTest.asList(elements);
        }
    }
}

