/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.primitives.ImmutableDoubleArray;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.DoubleStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableDoubleArrayTest
extends TestCase {
    private static final Random RANDOM = new Random(42L);

    public void testOf0() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of().asList()).isEmpty();
    }

    public void testOf1() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0).asList()).containsExactly(new Object[]{0.0});
    }

    public void testOf2() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double)1.0).asList()).containsExactly(new Object[]{0.0, 1.0}).inOrder();
    }

    public void testOf3() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testOf4() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0, (double)6.0).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0, 6.0}).inOrder();
    }

    public void testOf5() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)10.0).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0, 6.0, 10.0}).inOrder();
    }

    public void testOf6() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)10.0, (double)15.0).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0, 6.0, 10.0, 15.0}).inOrder();
    }

    public void testOf7() {
        Truth.assertThat((Iterable)ImmutableDoubleArray.of((double)0.0, (double[])new double[]{1.0, 3.0, 6.0, 10.0, 15.0, 21.0}).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0, 6.0, 10.0, 15.0, 21.0}).inOrder();
    }

    public void testCopyOf_array_empty() {
        Truth.assertThat((Object)ImmutableDoubleArray.copyOf((double[])new double[0])).isSameAs((Object)ImmutableDoubleArray.of());
    }

    public void testCopyOf_array_nonempty() {
        double[] array = new double[]{0.0, 1.0, 3.0};
        ImmutableDoubleArray iia = ImmutableDoubleArray.copyOf((double[])array);
        array[2] = 2.0;
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testCopyOf_iterable_notCollection_empty() {
        Iterable iterable = ImmutableDoubleArrayTest.iterable(Collections.emptySet());
        Truth.assertThat((Object)ImmutableDoubleArray.copyOf(iterable)).isSameAs((Object)ImmutableDoubleArray.of());
    }

    public void testCopyOf_iterable_notCollection_nonempty() {
        List<Double> list = Arrays.asList(0.0, 1.0, 3.0);
        ImmutableDoubleArray iia = ImmutableDoubleArray.copyOf(ImmutableDoubleArrayTest.iterable(list));
        list.set(2, 2.0);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testCopyOf_iterable_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableDoubleArray.copyOf(iterable)).isSameAs((Object)ImmutableDoubleArray.of());
    }

    public void testCopyOf_iterable_collection_nonempty() {
        List<Double> list = Arrays.asList(0.0, 1.0, 3.0);
        ImmutableDoubleArray iia = ImmutableDoubleArray.copyOf(list);
        list.set(2, 2.0);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testCopyOf_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableDoubleArray.copyOf(iterable)).isSameAs((Object)ImmutableDoubleArray.of());
    }

    public void testCopyOf_collection_nonempty() {
        List<Double> list = Arrays.asList(0.0, 1.0, 3.0);
        ImmutableDoubleArray iia = ImmutableDoubleArray.copyOf(list);
        list.set(2, 2.0);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testCopyOf_stream() {
        Truth.assertThat((Object)ImmutableDoubleArray.copyOf((DoubleStream)DoubleStream.empty())).isSameAs((Object)ImmutableDoubleArray.of());
        Truth.assertThat((Iterable)ImmutableDoubleArray.copyOf((DoubleStream)DoubleStream.of(0.0, 1.0, 3.0)).asList()).containsExactly(new Object[]{0.0, 1.0, 3.0}).inOrder();
    }

    public void testBuilder_presize_zero() {
        ImmutableDoubleArray.Builder builder = ImmutableDoubleArray.builder((int)0);
        builder.add(5.0);
        ImmutableDoubleArray array = builder.build();
        Truth.assertThat((Iterable)array.asList()).containsExactly(new Object[]{5.0});
    }

    public void testBuilder_presize_negative() {
        try {
            ImmutableDoubleArray.builder((int)-1);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilder_bruteForce() {
        for (double i = 0.0; i < 100.0; i += 1.0) {
            ImmutableDoubleArray.Builder builder = ImmutableDoubleArray.builder((int)RANDOM.nextInt(20));
            AtomicInteger counter = new AtomicInteger(0);
            while (counter.get() < 1000) {
                BuilderOp op = BuilderOp.randomOp();
                op.doIt(builder, counter);
            }
            ImmutableDoubleArray iia = builder.build();
            for (int j = 0; j < iia.length(); ++j) {
                Truth.assertThat((Double)iia.get(j)).isEqualTo(Double.valueOf(j));
            }
        }
    }

    public void testLength() {
        Truth.assertThat((Integer)ImmutableDoubleArray.of().length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)0.0).length()).isEqualTo((Object)1);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).length()).isEqualTo((Object)3);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 1).length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 2).length()).isEqualTo((Object)1);
    }

    public void testIsEmpty() {
        Truth.assertThat((Boolean)ImmutableDoubleArray.of().isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of((double)0.0).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 1).isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 2).isEmpty()).isFalse();
    }

    public void testGet_good() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0);
        Truth.assertThat((Double)iia.get(0)).isEqualTo(Double.valueOf(0.0));
        Truth.assertThat((Double)iia.get(2)).isEqualTo(Double.valueOf(3.0));
        Truth.assertThat((Double)iia.subArray(1, 3).get(1)).isEqualTo(Double.valueOf(3.0));
    }

    public void testGet_bad() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0);
        try {
            iia.get(-1);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia.get(3);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iia = iia.subArray(1, 2);
        try {
            iia.get(-1);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexOf() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)1.0, (double)1.0, (double)2.0, (double)3.0, (double)5.0, (double)8.0);
        Truth.assertThat((Integer)iia.indexOf(1.0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)iia.indexOf(8.0)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.indexOf(4.0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)13.0).indexOf(13.0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableDoubleArray.of().indexOf(21.0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).indexOf(1.0)).isEqualTo((Object)0);
    }

    public void testIndexOf_specialValues() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)-0.0, (double)0.0, (double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (double)Double.NaN);
        Truth.assertThat((Integer)iia.indexOf(-0.0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)iia.indexOf(0.0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)iia.indexOf(Double.MAX_VALUE)).isEqualTo((Object)2);
        Truth.assertThat((Integer)iia.indexOf(Double.POSITIVE_INFINITY)).isEqualTo((Object)3);
        Truth.assertThat((Integer)iia.indexOf(Double.NaN)).isEqualTo((Object)4);
    }

    public void testLastIndexOf() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)1.0, (double)1.0, (double)2.0, (double)3.0, (double)5.0, (double)8.0);
        Truth.assertThat((Integer)iia.lastIndexOf(1.0)).isEqualTo((Object)1);
        Truth.assertThat((Integer)iia.lastIndexOf(8.0)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.lastIndexOf(4.0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableDoubleArray.of((double)13.0).lastIndexOf(13.0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableDoubleArray.of().lastIndexOf(21.0)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).lastIndexOf(1.0)).isEqualTo((Object)0);
    }

    public void testContains() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)1.0, (double)1.0, (double)2.0, (double)3.0, (double)5.0, (double)8.0);
        Truth.assertThat((Boolean)iia.contains(1.0)).isTrue();
        Truth.assertThat((Boolean)iia.contains(8.0)).isTrue();
        Truth.assertThat((Boolean)iia.contains(4.0)).isFalse();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of((double)13.0).contains(13.0)).isTrue();
        Truth.assertThat((Boolean)ImmutableDoubleArray.of().contains(21.0)).isFalse();
        Truth.assertThat((Boolean)iia.subArray(1, 5).contains(1.0)).isTrue();
    }

    public void testForEach() {
        ImmutableDoubleArray.of().forEach(i -> ImmutableDoubleArrayTest.fail());
        ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 1).forEach(i -> ImmutableDoubleArrayTest.fail());
        AtomicInteger count = new AtomicInteger(0);
        ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)2.0, (double)3.0).forEach(i -> Truth.assertThat((Double)i).isEqualTo(Double.valueOf(count.getAndIncrement())));
        ImmutableDoubleArrayTest.assertEquals((int)4, (int)count.get());
    }

    public void testStream() {
        ImmutableDoubleArray.of().stream().forEach(i -> ImmutableDoubleArrayTest.fail());
        ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).subArray(1, 1).stream().forEach(i -> ImmutableDoubleArrayTest.fail());
        Truth.assertThat((double[])ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0).stream().toArray()).isEqualTo((Object)new double[]{0.0, 1.0, 3.0});
    }

    public void testSubArray() {
        ImmutableDoubleArray iia0 = ImmutableDoubleArray.of();
        ImmutableDoubleArray iia1 = ImmutableDoubleArray.of((double)5.0);
        ImmutableDoubleArray iia3 = ImmutableDoubleArray.of((double)5.0, (double)25.0, (double)125.0);
        Truth.assertThat((Object)iia0.subArray(0, 0)).isSameAs((Object)ImmutableDoubleArray.of());
        Truth.assertThat((Object)iia1.subArray(0, 0)).isSameAs((Object)ImmutableDoubleArray.of());
        Truth.assertThat((Object)iia1.subArray(1, 1)).isSameAs((Object)ImmutableDoubleArray.of());
        Truth.assertThat((Iterable)iia1.subArray(0, 1).asList()).containsExactly(new Object[]{5.0});
        Truth.assertThat((Iterable)iia3.subArray(0, 2).asList()).containsExactly(new Object[]{5.0, 25.0}).inOrder();
        Truth.assertThat((Iterable)iia3.subArray(1, 3).asList()).containsExactly(new Object[]{25.0, 125.0}).inOrder();
        try {
            iia3.subArray(-1, 1);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia3.subArray(1, 4);
            ImmutableDoubleArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static <T> Iterable<T> iterable(final Collection<T> collection) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return collection.iterator();
            }
        };
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableDoubleArray.of()}).addEqualityGroup(new Object[]{ImmutableDoubleArray.of((double)1.0, (double)2.0), SerializableTester.reserialize((Object)ImmutableDoubleArray.of((double)1.0, (double)2.0)), ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)2.0, (double)3.0).subArray(1, 3)}).addEqualityGroup(new Object[]{ImmutableDoubleArray.of((double)1.0, (double)3.0)}).addEqualityGroup(new Object[]{ImmutableDoubleArray.of((double)1.0, (double)2.0, (double)3.0)}).testEquals();
    }

    public void testTrimmed() {
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0);
        ImmutableDoubleArrayTest.assertDoesntActuallyTrim(iia);
        ImmutableDoubleArrayTest.assertDoesntActuallyTrim(iia.subArray(0, 3));
        ImmutableDoubleArrayTest.assertActuallyTrims(iia.subArray(0, 2));
        ImmutableDoubleArrayTest.assertActuallyTrims(iia.subArray(1, 3));
        ImmutableDoubleArray rightSized = ImmutableDoubleArray.builder((int)3).add(0.0).add(1.0).add(3.0).build();
        ImmutableDoubleArrayTest.assertDoesntActuallyTrim(rightSized);
        ImmutableDoubleArray overSized = ImmutableDoubleArray.builder((int)3).add(0.0).add(1.0).build();
        ImmutableDoubleArrayTest.assertActuallyTrims(overSized);
        ImmutableDoubleArray underSized = ImmutableDoubleArray.builder((int)2).add(0.0).add(1.0).add(3.0).build();
        ImmutableDoubleArrayTest.assertActuallyTrims(underSized);
    }

    @GwtIncompatible
    public void testSerialization() {
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableDoubleArray.of())).isSameAs((Object)ImmutableDoubleArray.of());
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableDoubleArray.of((double)0.0, (double)1.0).subArray(1, 1))).isSameAs((Object)ImmutableDoubleArray.of());
        ImmutableDoubleArray iia = ImmutableDoubleArray.of((double)0.0, (double)1.0, (double)3.0, (double)6.0).subArray(1, 3);
        ImmutableDoubleArray iia2 = (ImmutableDoubleArray)SerializableTester.reserialize((Object)iia);
        Truth.assertThat((Object)iia2).isEqualTo((Object)iia);
        ImmutableDoubleArrayTest.assertDoesntActuallyTrim(iia2);
    }

    private static void assertActuallyTrims(ImmutableDoubleArray iia) {
        ImmutableDoubleArray trimmed = iia.trimmed();
        Truth.assertThat((Object)trimmed).isNotSameAs((Object)iia);
        Truth.assertThat((double[])trimmed.toArray()).isEqualTo((Object)iia.toArray());
    }

    private static void assertDoesntActuallyTrim(ImmutableDoubleArray iia) {
        Truth.assertThat((Object)iia.trimmed()).isSameAs((Object)iia);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableDoubleArrayAsListGenerator()).named("ImmutableDoubleArray.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableDoubleArrayHeadSubListAsListGenerator()).named("ImmutableDoubleArray.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableDoubleArrayTailSubListAsListGenerator()).named("ImmutableDoubleArray.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableDoubleArrayMiddleSubListAsListGenerator()).named("ImmutableDoubleArray.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ZERO, CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.RESTRICTS_ELEMENTS, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})).createTestSuite());
        }
        suite.addTestSuite(ImmutableDoubleArrayTest.class);
        return suite;
    }

    @GwtIncompatible
    private static ImmutableDoubleArray makeArray(Double[] values) {
        return ImmutableDoubleArray.copyOf(Arrays.asList(values));
    }

    @GwtIncompatible
    private static Double[] concat(Double[] a, Double[] b) {
        return (Double[])ObjectArrays.concat((Object[])a, (Object[])b, Double.class);
    }

    @GwtIncompatible
    public static class SampleDoubles
    extends SampleElements<Double> {
        public SampleDoubles() {
            super((Object)-0.0, (Object)2.7670116110564327E19, (Object)Double.MAX_VALUE, (Object)Double.POSITIVE_INFINITY, (Object)Double.NaN);
        }
    }

    @GwtIncompatible
    public static abstract class TestDoubleListGenerator
    implements TestListGenerator<Double> {
        public SampleElements<Double> samples() {
            return new SampleDoubles();
        }

        public List<Double> create(Object ... elements) {
            Double[] array = new Double[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Double)e;
            }
            return this.create(array);
        }

        protected abstract List<Double> create(Double[] var1);

        public Double[] createArray(int length) {
            return new Double[length];
        }

        public List<Double> order(List<Double> insertionOrder) {
            return insertionOrder;
        }
    }

    @GwtIncompatible
    public static final class ImmutableDoubleArrayMiddleSubListAsListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] prefix = new Double[]{Double.MIN_VALUE, Double.MAX_VALUE};
            Double[] suffix = new Double[]{86.0, 99.0};
            Double[] all = ImmutableDoubleArrayTest.concat(ImmutableDoubleArrayTest.concat(prefix, elements), suffix);
            return ImmutableDoubleArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableDoubleArrayTailSubListAsListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] prefix = new Double[]{86.0, 99.0};
            Double[] all = ImmutableDoubleArrayTest.concat(prefix, elements);
            return ImmutableDoubleArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableDoubleArrayHeadSubListAsListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] suffix = new Double[]{Double.MIN_VALUE, Double.MAX_VALUE};
            Double[] all = ImmutableDoubleArrayTest.concat(elements, suffix);
            return ImmutableDoubleArrayTest.makeArray(all).subArray(0, elements.length).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableDoubleArrayAsListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            return ImmutableDoubleArrayTest.makeArray(elements).asList();
        }
    }

    private static enum BuilderOp {
        ADD_ONE{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                builder.add((double)counter.getAndIncrement());
            }
        }
        ,
        ADD_ARRAY{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                double[] array = new double[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        }
        ,
        ADD_COLLECTION{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                ArrayList<Double> list = new ArrayList<Double>();
                double num = RANDOM.nextInt(10);
                int i = 0;
                while ((double)i < num) {
                    list.add(Double.valueOf(counter.getAndIncrement()));
                    ++i;
                }
                builder.addAll(list);
            }
        }
        ,
        ADD_ITERABLE{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                ArrayList<Double> list = new ArrayList<Double>();
                double num = RANDOM.nextInt(10);
                int i = 0;
                while ((double)i < num) {
                    list.add(Double.valueOf(counter.getAndIncrement()));
                    ++i;
                }
                builder.addAll(ImmutableDoubleArrayTest.iterable(list));
            }
        }
        ,
        ADD_STREAM{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                double[] array = new double[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(Arrays.stream(array));
            }
        }
        ,
        ADD_IIA{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                double[] array = new double[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(ImmutableDoubleArray.copyOf((double[])array));
            }
        }
        ,
        ADD_LARGER_ARRAY{

            @Override
            void doIt(ImmutableDoubleArray.Builder builder, AtomicInteger counter) {
                double[] array = new double[RANDOM.nextInt(200) + 200];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        };

        static final BuilderOp[] values;

        static BuilderOp randomOp() {
            return values[RANDOM.nextInt(values.length)];
        }

        abstract void doIt(ImmutableDoubleArray.Builder var1, AtomicInteger var2);

        static {
            values = BuilderOp.values();
        }
    }
}

