/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableIntArrayTest
extends TestCase {
    private static final Random RANDOM = new Random(42L);

    public void testOf0() {
        Truth.assertThat((Iterable)ImmutableIntArray.of().asList()).isEmpty();
    }

    public void testOf1() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0).asList()).containsExactly(new Object[]{0});
    }

    public void testOf2() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int)1).asList()).containsExactly(new Object[]{0, 1}).inOrder();
    }

    public void testOf3() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int)1, (int)3).asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testOf4() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int)1, (int)3, (int)6).asList()).containsExactly(new Object[]{0, 1, 3, 6}).inOrder();
    }

    public void testOf5() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int)1, (int)3, (int)6, (int)10).asList()).containsExactly(new Object[]{0, 1, 3, 6, 10}).inOrder();
    }

    public void testOf6() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int)1, (int)3, (int)6, (int)10, (int)15).asList()).containsExactly(new Object[]{0, 1, 3, 6, 10, 15}).inOrder();
    }

    public void testOf7() {
        Truth.assertThat((Iterable)ImmutableIntArray.of((int)0, (int[])new int[]{1, 3, 6, 10, 15, 21}).asList()).containsExactly(new Object[]{0, 1, 3, 6, 10, 15, 21}).inOrder();
    }

    public void testCopyOf_array_empty() {
        Truth.assertThat((Object)ImmutableIntArray.copyOf((int[])new int[0])).isSameAs((Object)ImmutableIntArray.of());
    }

    public void testCopyOf_array_nonempty() {
        int[] array = new int[]{0, 1, 3};
        ImmutableIntArray iia = ImmutableIntArray.copyOf((int[])array);
        array[2] = 2;
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testCopyOf_iterable_notCollection_empty() {
        Iterable iterable = ImmutableIntArrayTest.iterable(Collections.emptySet());
        Truth.assertThat((Object)ImmutableIntArray.copyOf(iterable)).isSameAs((Object)ImmutableIntArray.of());
    }

    public void testCopyOf_iterable_notCollection_nonempty() {
        List<Integer> list = Arrays.asList(0, 1, 3);
        ImmutableIntArray iia = ImmutableIntArray.copyOf(ImmutableIntArrayTest.iterable(list));
        list.set(2, 2);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testCopyOf_iterable_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableIntArray.copyOf(iterable)).isSameAs((Object)ImmutableIntArray.of());
    }

    public void testCopyOf_iterable_collection_nonempty() {
        List<Integer> list = Arrays.asList(0, 1, 3);
        ImmutableIntArray iia = ImmutableIntArray.copyOf(list);
        list.set(2, 2);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testCopyOf_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableIntArray.copyOf(iterable)).isSameAs((Object)ImmutableIntArray.of());
    }

    public void testCopyOf_collection_nonempty() {
        List<Integer> list = Arrays.asList(0, 1, 3);
        ImmutableIntArray iia = ImmutableIntArray.copyOf(list);
        list.set(2, 2);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testCopyOf_stream() {
        Truth.assertThat((Object)ImmutableIntArray.copyOf((IntStream)IntStream.empty())).isSameAs((Object)ImmutableIntArray.of());
        Truth.assertThat((Iterable)ImmutableIntArray.copyOf((IntStream)IntStream.of(0, 1, 3)).asList()).containsExactly(new Object[]{0, 1, 3}).inOrder();
    }

    public void testBuilder_presize_zero() {
        ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)0);
        builder.add(5);
        ImmutableIntArray array = builder.build();
        Truth.assertThat((Iterable)array.asList()).containsExactly(new Object[]{5});
    }

    public void testBuilder_presize_negative() {
        try {
            ImmutableIntArray.builder((int)-1);
            ImmutableIntArrayTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilder_bruteForce() {
        for (int i = 0; i < 100; ++i) {
            ImmutableIntArray.Builder builder = ImmutableIntArray.builder((int)RANDOM.nextInt(20));
            AtomicInteger counter = new AtomicInteger(0);
            while (counter.get() < 1000) {
                BuilderOp op = BuilderOp.randomOp();
                op.doIt(builder, counter);
            }
            ImmutableIntArray iia = builder.build();
            for (int j = 0; j < iia.length(); ++j) {
                Truth.assertThat((Integer)iia.get(j)).isEqualTo((Object)j);
            }
        }
    }

    public void testLength() {
        Truth.assertThat((Integer)ImmutableIntArray.of().length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)0).length()).isEqualTo((Object)1);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)0, (int)1, (int)3).length()).isEqualTo((Object)3);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 1).length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 2).length()).isEqualTo((Object)1);
    }

    public void testIsEmpty() {
        Truth.assertThat((Boolean)ImmutableIntArray.of().isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableIntArray.of((int)0).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableIntArray.of((int)0, (int)1, (int)3).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 1).isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 2).isEmpty()).isFalse();
    }

    public void testGet_good() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)0, (int)1, (int)3);
        Truth.assertThat((Integer)iia.get(0)).isEqualTo((Object)0);
        Truth.assertThat((Integer)iia.get(2)).isEqualTo((Object)3);
        Truth.assertThat((Integer)iia.subArray(1, 3).get(1)).isEqualTo((Object)3);
    }

    public void testGet_bad() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)0, (int)1, (int)3);
        try {
            iia.get(-1);
            ImmutableIntArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia.get(3);
            ImmutableIntArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iia = iia.subArray(1, 2);
        try {
            iia.get(-1);
            ImmutableIntArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexOf() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)1, (int)1, (int)2, (int)3, (int)5, (int)8);
        Truth.assertThat((Integer)iia.indexOf(1)).isEqualTo((Object)0);
        Truth.assertThat((Integer)iia.indexOf(8)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.indexOf(4)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)13).indexOf(13)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableIntArray.of().indexOf(21)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).indexOf(1)).isEqualTo((Object)0);
    }

    public void testLastIndexOf() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)1, (int)1, (int)2, (int)3, (int)5, (int)8);
        Truth.assertThat((Integer)iia.lastIndexOf(1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)iia.lastIndexOf(8)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.lastIndexOf(4)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableIntArray.of((int)13).lastIndexOf(13)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableIntArray.of().lastIndexOf(21)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).lastIndexOf(1)).isEqualTo((Object)0);
    }

    public void testContains() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)1, (int)1, (int)2, (int)3, (int)5, (int)8);
        Truth.assertThat((Boolean)iia.contains(1)).isTrue();
        Truth.assertThat((Boolean)iia.contains(8)).isTrue();
        Truth.assertThat((Boolean)iia.contains(4)).isFalse();
        Truth.assertThat((Boolean)ImmutableIntArray.of((int)13).contains(13)).isTrue();
        Truth.assertThat((Boolean)ImmutableIntArray.of().contains(21)).isFalse();
        Truth.assertThat((Boolean)iia.subArray(1, 5).contains(1)).isTrue();
    }

    public void testForEach() {
        ImmutableIntArray.of().forEach(i -> ImmutableIntArrayTest.fail());
        ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 1).forEach(i -> ImmutableIntArrayTest.fail());
        AtomicInteger count = new AtomicInteger(0);
        ImmutableIntArray.of((int)0, (int)1, (int)2, (int)3).forEach(i -> Truth.assertThat((Integer)i).isEqualTo((Object)count.getAndIncrement()));
        ImmutableIntArrayTest.assertEquals((int)4, (int)count.get());
    }

    public void testStream() {
        ImmutableIntArray.of().stream().forEach(i -> ImmutableIntArrayTest.fail());
        ImmutableIntArray.of((int)0, (int)1, (int)3).subArray(1, 1).stream().forEach(i -> ImmutableIntArrayTest.fail());
        Truth.assertThat((int[])ImmutableIntArray.of((int)0, (int)1, (int)3).stream().toArray()).isEqualTo((Object)new int[]{0, 1, 3});
    }

    public void testSubArray() {
        ImmutableIntArray iia0 = ImmutableIntArray.of();
        ImmutableIntArray iia1 = ImmutableIntArray.of((int)5);
        ImmutableIntArray iia3 = ImmutableIntArray.of((int)5, (int)25, (int)125);
        Truth.assertThat((Object)iia0.subArray(0, 0)).isSameAs((Object)ImmutableIntArray.of());
        Truth.assertThat((Object)iia1.subArray(0, 0)).isSameAs((Object)ImmutableIntArray.of());
        Truth.assertThat((Object)iia1.subArray(1, 1)).isSameAs((Object)ImmutableIntArray.of());
        Truth.assertThat((Iterable)iia1.subArray(0, 1).asList()).containsExactly(new Object[]{5});
        Truth.assertThat((Iterable)iia3.subArray(0, 2).asList()).containsExactly(new Object[]{5, 25}).inOrder();
        Truth.assertThat((Iterable)iia3.subArray(1, 3).asList()).containsExactly(new Object[]{25, 125}).inOrder();
        try {
            iia3.subArray(-1, 1);
            ImmutableIntArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia3.subArray(1, 4);
            ImmutableIntArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static <T> Iterable<T> iterable(final Collection<T> collection) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return collection.iterator();
            }
        };
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableIntArray.of()}).addEqualityGroup(new Object[]{ImmutableIntArray.of((int)1, (int)2), SerializableTester.reserialize((Object)ImmutableIntArray.of((int)1, (int)2)), ImmutableIntArray.of((int)0, (int)1, (int)2, (int)3).subArray(1, 3)}).addEqualityGroup(new Object[]{ImmutableIntArray.of((int)1, (int)3)}).addEqualityGroup(new Object[]{ImmutableIntArray.of((int)1, (int)2, (int)3)}).testEquals();
    }

    public void testTrimmed() {
        ImmutableIntArray iia = ImmutableIntArray.of((int)0, (int)1, (int)3);
        ImmutableIntArrayTest.assertDoesntActuallyTrim(iia);
        ImmutableIntArrayTest.assertDoesntActuallyTrim(iia.subArray(0, 3));
        ImmutableIntArrayTest.assertActuallyTrims(iia.subArray(0, 2));
        ImmutableIntArrayTest.assertActuallyTrims(iia.subArray(1, 3));
        ImmutableIntArray rightSized = ImmutableIntArray.builder((int)3).add(0).add(1).add(3).build();
        ImmutableIntArrayTest.assertDoesntActuallyTrim(rightSized);
        ImmutableIntArray overSized = ImmutableIntArray.builder((int)3).add(0).add(1).build();
        ImmutableIntArrayTest.assertActuallyTrims(overSized);
        ImmutableIntArray underSized = ImmutableIntArray.builder((int)2).add(0).add(1).add(3).build();
        ImmutableIntArrayTest.assertActuallyTrims(underSized);
    }

    @GwtIncompatible
    public void testSerialization() {
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableIntArray.of())).isSameAs((Object)ImmutableIntArray.of());
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableIntArray.of((int)0, (int)1).subArray(1, 1))).isSameAs((Object)ImmutableIntArray.of());
        ImmutableIntArray iia = ImmutableIntArray.of((int)0, (int)1, (int)3, (int)6).subArray(1, 3);
        ImmutableIntArray iia2 = (ImmutableIntArray)SerializableTester.reserialize((Object)iia);
        Truth.assertThat((Object)iia2).isEqualTo((Object)iia);
        ImmutableIntArrayTest.assertDoesntActuallyTrim(iia2);
    }

    private static void assertActuallyTrims(ImmutableIntArray iia) {
        ImmutableIntArray trimmed = iia.trimmed();
        Truth.assertThat((Object)trimmed).isNotSameAs((Object)iia);
        Truth.assertThat((int[])trimmed.toArray()).isEqualTo((Object)iia.toArray());
    }

    private static void assertDoesntActuallyTrim(ImmutableIntArray iia) {
        Truth.assertThat((Object)iia.trimmed()).isSameAs((Object)iia);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableIntArrayAsListGenerator()).named("ImmutableIntArray.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableIntArrayHeadSubListAsListGenerator()).named("ImmutableIntArray.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableIntArrayTailSubListAsListGenerator()).named("ImmutableIntArray.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableIntArrayMiddleSubListAsListGenerator()).named("ImmutableIntArray.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ZERO, CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.RESTRICTS_ELEMENTS, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})).createTestSuite());
        }
        suite.addTestSuite(ImmutableIntArrayTest.class);
        return suite;
    }

    @GwtIncompatible
    private static ImmutableIntArray makeArray(Integer[] values) {
        return ImmutableIntArray.copyOf(Arrays.asList(values));
    }

    @GwtIncompatible
    private static Integer[] concat(Integer[] a, Integer[] b) {
        return (Integer[])ObjectArrays.concat((Object[])a, (Object[])b, Integer.class);
    }

    @GwtIncompatible
    public static class SampleIntegers
    extends SampleElements<Integer> {
        public SampleIntegers() {
            super((Object)1, (Object)3, (Object)6, (Object)10, (Object)15);
        }
    }

    @GwtIncompatible
    public static abstract class TestIntegerListGenerator
    implements TestListGenerator<Integer> {
        public SampleElements<Integer> samples() {
            return new SampleIntegers();
        }

        public List<Integer> create(Object ... elements) {
            Integer[] array = new Integer[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Integer)e;
            }
            return this.create(array);
        }

        protected abstract List<Integer> create(Integer[] var1);

        public Integer[] createArray(int length) {
            return new Integer[length];
        }

        public List<Integer> order(List<Integer> insertionOrder) {
            return insertionOrder;
        }
    }

    @GwtIncompatible
    public static final class ImmutableIntArrayMiddleSubListAsListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] prefix = new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            Integer[] suffix = new Integer[]{86, 99};
            Integer[] all = ImmutableIntArrayTest.concat(ImmutableIntArrayTest.concat(prefix, elements), suffix);
            return ImmutableIntArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableIntArrayTailSubListAsListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] prefix = new Integer[]{86, 99};
            Integer[] all = ImmutableIntArrayTest.concat(prefix, elements);
            return ImmutableIntArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableIntArrayHeadSubListAsListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] suffix = new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            Integer[] all = ImmutableIntArrayTest.concat(elements, suffix);
            return ImmutableIntArrayTest.makeArray(all).subArray(0, elements.length).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableIntArrayAsListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            return ImmutableIntArrayTest.makeArray(elements).asList();
        }
    }

    private static enum BuilderOp {
        ADD_ONE{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                builder.add(counter.getAndIncrement());
            }
        }
        ,
        ADD_ARRAY{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                int[] array = new int[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        }
        ,
        ADD_COLLECTION{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                int num = RANDOM.nextInt(10);
                for (int i = 0; i < num; ++i) {
                    list.add(counter.getAndIncrement());
                }
                builder.addAll(list);
            }
        }
        ,
        ADD_ITERABLE{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                int num = RANDOM.nextInt(10);
                for (int i = 0; i < num; ++i) {
                    list.add(counter.getAndIncrement());
                }
                builder.addAll(ImmutableIntArrayTest.iterable(list));
            }
        }
        ,
        ADD_STREAM{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                int[] array = new int[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(Arrays.stream(array));
            }
        }
        ,
        ADD_IIA{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                int[] array = new int[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(ImmutableIntArray.copyOf((int[])array));
            }
        }
        ,
        ADD_LARGER_ARRAY{

            @Override
            void doIt(ImmutableIntArray.Builder builder, AtomicInteger counter) {
                int[] array = new int[RANDOM.nextInt(200) + 200];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        };

        static final BuilderOp[] values;

        static BuilderOp randomOp() {
            return values[RANDOM.nextInt(values.length)];
        }

        abstract void doIt(ImmutableIntArray.Builder var1, AtomicInteger var2);

        static {
            values = BuilderOp.values();
        }
    }
}

