/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.LongStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableLongArrayTest
extends TestCase {
    private static final Random RANDOM = new Random(42L);

    public void testOf0() {
        Truth.assertThat((Iterable)ImmutableLongArray.of().asList()).isEmpty();
    }

    public void testOf1() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L).asList()).containsExactly(new Object[]{0L});
    }

    public void testOf2() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long)1L).asList()).containsExactly(new Object[]{0L, 1L}).inOrder();
    }

    public void testOf3() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testOf4() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long)1L, (long)3L, (long)6L).asList()).containsExactly(new Object[]{0L, 1L, 3L, 6L}).inOrder();
    }

    public void testOf5() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long)1L, (long)3L, (long)6L, (long)10L).asList()).containsExactly(new Object[]{0L, 1L, 3L, 6L, 10L}).inOrder();
    }

    public void testOf6() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long)1L, (long)3L, (long)6L, (long)10L, (long)15L).asList()).containsExactly(new Object[]{0L, 1L, 3L, 6L, 10L, 15L}).inOrder();
    }

    public void testOf7() {
        Truth.assertThat((Iterable)ImmutableLongArray.of((long)0L, (long[])new long[]{1L, 3L, 6L, 10L, 15L, 21L}).asList()).containsExactly(new Object[]{0L, 1L, 3L, 6L, 10L, 15L, 21L}).inOrder();
    }

    public void testCopyOf_array_empty() {
        Truth.assertThat((Object)ImmutableLongArray.copyOf((long[])new long[0])).isSameAs((Object)ImmutableLongArray.of());
    }

    public void testCopyOf_array_nonempty() {
        long[] array = new long[]{0L, 1L, 3L};
        ImmutableLongArray iia = ImmutableLongArray.copyOf((long[])array);
        array[2] = 2L;
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testCopyOf_iterable_notCollection_empty() {
        Iterable iterable = ImmutableLongArrayTest.iterable(Collections.emptySet());
        Truth.assertThat((Object)ImmutableLongArray.copyOf(iterable)).isSameAs((Object)ImmutableLongArray.of());
    }

    public void testCopyOf_iterable_notCollection_nonempty() {
        List<Long> list = Arrays.asList(0L, 1L, 3L);
        ImmutableLongArray iia = ImmutableLongArray.copyOf(ImmutableLongArrayTest.iterable(list));
        list.set(2, 2L);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testCopyOf_iterable_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableLongArray.copyOf(iterable)).isSameAs((Object)ImmutableLongArray.of());
    }

    public void testCopyOf_iterable_collection_nonempty() {
        List<Long> list = Arrays.asList(0L, 1L, 3L);
        ImmutableLongArray iia = ImmutableLongArray.copyOf(list);
        list.set(2, 2L);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testCopyOf_collection_empty() {
        Set iterable = Collections.emptySet();
        Truth.assertThat((Object)ImmutableLongArray.copyOf(iterable)).isSameAs((Object)ImmutableLongArray.of());
    }

    public void testCopyOf_collection_nonempty() {
        List<Long> list = Arrays.asList(0L, 1L, 3L);
        ImmutableLongArray iia = ImmutableLongArray.copyOf(list);
        list.set(2, 2L);
        Truth.assertThat((Iterable)iia.asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testCopyOf_stream() {
        Truth.assertThat((Object)ImmutableLongArray.copyOf((LongStream)LongStream.empty())).isSameAs((Object)ImmutableLongArray.of());
        Truth.assertThat((Iterable)ImmutableLongArray.copyOf((LongStream)LongStream.of(0L, 1L, 3L)).asList()).containsExactly(new Object[]{0L, 1L, 3L}).inOrder();
    }

    public void testBuilder_presize_zero() {
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder((int)0);
        builder.add(5L);
        ImmutableLongArray array = builder.build();
        Truth.assertThat((Iterable)array.asList()).containsExactly(new Object[]{5L});
    }

    public void testBuilder_presize_negative() {
        try {
            ImmutableLongArray.builder((int)-1);
            ImmutableLongArrayTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilder_bruteForce() {
        for (long i = 0L; i < 100L; ++i) {
            ImmutableLongArray.Builder builder = ImmutableLongArray.builder((int)RANDOM.nextInt(20));
            AtomicLong counter = new AtomicLong(0L);
            while (counter.get() < 1000L) {
                BuilderOp op = BuilderOp.randomOp();
                op.doIt(builder, counter);
            }
            ImmutableLongArray iia = builder.build();
            for (int j = 0; j < iia.length(); ++j) {
                Truth.assertThat((Long)iia.get(j)).isEqualTo((Object)j);
            }
        }
    }

    public void testLength() {
        Truth.assertThat((Integer)ImmutableLongArray.of().length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)0L).length()).isEqualTo((Object)1);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).length()).isEqualTo((Object)3);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 1).length()).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 2).length()).isEqualTo((Object)1);
    }

    public void testIsEmpty() {
        Truth.assertThat((Boolean)ImmutableLongArray.of().isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableLongArray.of((long)0L).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).isEmpty()).isFalse();
        Truth.assertThat((Boolean)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 1).isEmpty()).isTrue();
        Truth.assertThat((Boolean)ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 2).isEmpty()).isFalse();
    }

    public void testGet_good() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)0L, (long)1L, (long)3L);
        Truth.assertThat((Long)iia.get(0)).isEqualTo((Object)0L);
        Truth.assertThat((Long)iia.get(2)).isEqualTo((Object)3L);
        Truth.assertThat((Long)iia.subArray(1, 3).get(1)).isEqualTo((Object)3L);
    }

    public void testGet_bad() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)0L, (long)1L, (long)3L);
        try {
            iia.get(-1);
            ImmutableLongArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia.get(3);
            ImmutableLongArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        iia = iia.subArray(1, 2);
        try {
            iia.get(-1);
            ImmutableLongArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexOf() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)1L, (long)1L, (long)2L, (long)3L, (long)5L, (long)8L);
        Truth.assertThat((Integer)iia.indexOf(1L)).isEqualTo((Object)0);
        Truth.assertThat((Integer)iia.indexOf(8L)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.indexOf(4L)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)13L).indexOf(13L)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableLongArray.of().indexOf(21L)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).indexOf(1L)).isEqualTo((Object)0);
    }

    public void testLastIndexOf() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)1L, (long)1L, (long)2L, (long)3L, (long)5L, (long)8L);
        Truth.assertThat((Integer)iia.lastIndexOf(1L)).isEqualTo((Object)1);
        Truth.assertThat((Integer)iia.lastIndexOf(8L)).isEqualTo((Object)5);
        Truth.assertThat((Integer)iia.lastIndexOf(4L)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ImmutableLongArray.of((long)13L).lastIndexOf(13L)).isEqualTo((Object)0);
        Truth.assertThat((Integer)ImmutableLongArray.of().lastIndexOf(21L)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)iia.subArray(1, 5).lastIndexOf(1L)).isEqualTo((Object)0);
    }

    public void testContains() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)1L, (long)1L, (long)2L, (long)3L, (long)5L, (long)8L);
        Truth.assertThat((Boolean)iia.contains(1L)).isTrue();
        Truth.assertThat((Boolean)iia.contains(8L)).isTrue();
        Truth.assertThat((Boolean)iia.contains(4L)).isFalse();
        Truth.assertThat((Boolean)ImmutableLongArray.of((long)13L).contains(13L)).isTrue();
        Truth.assertThat((Boolean)ImmutableLongArray.of().contains(21L)).isFalse();
        Truth.assertThat((Boolean)iia.subArray(1, 5).contains(1L)).isTrue();
    }

    public void testForEach() {
        ImmutableLongArray.of().forEach(i -> ImmutableLongArrayTest.fail());
        ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 1).forEach(i -> ImmutableLongArrayTest.fail());
        AtomicLong count = new AtomicLong(0L);
        ImmutableLongArray.of((long)0L, (long)1L, (long)2L, (long)3L).forEach(i -> Truth.assertThat((Long)i).isEqualTo((Object)count.getAndIncrement()));
        ImmutableLongArrayTest.assertEquals((long)4L, (long)count.get());
    }

    public void testStream() {
        ImmutableLongArray.of().stream().forEach(i -> ImmutableLongArrayTest.fail());
        ImmutableLongArray.of((long)0L, (long)1L, (long)3L).subArray(1, 1).stream().forEach(i -> ImmutableLongArrayTest.fail());
        Truth.assertThat((long[])ImmutableLongArray.of((long)0L, (long)1L, (long)3L).stream().toArray()).isEqualTo((Object)new long[]{0L, 1L, 3L});
    }

    public void testSubArray() {
        ImmutableLongArray iia0 = ImmutableLongArray.of();
        ImmutableLongArray iia1 = ImmutableLongArray.of((long)5L);
        ImmutableLongArray iia3 = ImmutableLongArray.of((long)5L, (long)25L, (long)125L);
        Truth.assertThat((Object)iia0.subArray(0, 0)).isSameAs((Object)ImmutableLongArray.of());
        Truth.assertThat((Object)iia1.subArray(0, 0)).isSameAs((Object)ImmutableLongArray.of());
        Truth.assertThat((Object)iia1.subArray(1, 1)).isSameAs((Object)ImmutableLongArray.of());
        Truth.assertThat((Iterable)iia1.subArray(0, 1).asList()).containsExactly(new Object[]{5L});
        Truth.assertThat((Iterable)iia3.subArray(0, 2).asList()).containsExactly(new Object[]{5L, 25L}).inOrder();
        Truth.assertThat((Iterable)iia3.subArray(1, 3).asList()).containsExactly(new Object[]{25L, 125L}).inOrder();
        try {
            iia3.subArray(-1, 1);
            ImmutableLongArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iia3.subArray(1, 4);
            ImmutableLongArrayTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static <T> Iterable<T> iterable(final Collection<T> collection) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return collection.iterator();
            }
        };
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableLongArray.of()}).addEqualityGroup(new Object[]{ImmutableLongArray.of((long)1L, (long)2L), SerializableTester.reserialize((Object)ImmutableLongArray.of((long)1L, (long)2L)), ImmutableLongArray.of((long)0L, (long)1L, (long)2L, (long)3L).subArray(1, 3)}).addEqualityGroup(new Object[]{ImmutableLongArray.of((long)1L, (long)3L)}).addEqualityGroup(new Object[]{ImmutableLongArray.of((long)1L, (long)2L, (long)3L)}).testEquals();
    }

    public void testTrimmed() {
        ImmutableLongArray iia = ImmutableLongArray.of((long)0L, (long)1L, (long)3L);
        ImmutableLongArrayTest.assertDoesntActuallyTrim(iia);
        ImmutableLongArrayTest.assertDoesntActuallyTrim(iia.subArray(0, 3));
        ImmutableLongArrayTest.assertActuallyTrims(iia.subArray(0, 2));
        ImmutableLongArrayTest.assertActuallyTrims(iia.subArray(1, 3));
        ImmutableLongArray rightSized = ImmutableLongArray.builder((int)3).add(0L).add(1L).add(3L).build();
        ImmutableLongArrayTest.assertDoesntActuallyTrim(rightSized);
        ImmutableLongArray overSized = ImmutableLongArray.builder((int)3).add(0L).add(1L).build();
        ImmutableLongArrayTest.assertActuallyTrims(overSized);
        ImmutableLongArray underSized = ImmutableLongArray.builder((int)2).add(0L).add(1L).add(3L).build();
        ImmutableLongArrayTest.assertActuallyTrims(underSized);
    }

    @GwtIncompatible
    public void testSerialization() {
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableLongArray.of())).isSameAs((Object)ImmutableLongArray.of());
        Truth.assertThat((Object)SerializableTester.reserialize((Object)ImmutableLongArray.of((long)0L, (long)1L).subArray(1, 1))).isSameAs((Object)ImmutableLongArray.of());
        ImmutableLongArray iia = ImmutableLongArray.of((long)0L, (long)1L, (long)3L, (long)6L).subArray(1, 3);
        ImmutableLongArray iia2 = (ImmutableLongArray)SerializableTester.reserialize((Object)iia);
        Truth.assertThat((Object)iia2).isEqualTo((Object)iia);
        ImmutableLongArrayTest.assertDoesntActuallyTrim(iia2);
    }

    private static void assertActuallyTrims(ImmutableLongArray iia) {
        ImmutableLongArray trimmed = iia.trimmed();
        Truth.assertThat((Object)trimmed).isNotSameAs((Object)iia);
        Truth.assertThat((long[])trimmed.toArray()).isEqualTo((Object)iia.toArray());
    }

    private static void assertDoesntActuallyTrim(ImmutableLongArray iia) {
        Truth.assertThat((Object)iia.trimmed()).isSameAs((Object)iia);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableLongArrayAsListGenerator()).named("ImmutableLongArray.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableLongArrayHeadSubListAsListGenerator()).named("ImmutableLongArray.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableLongArrayTailSubListAsListGenerator()).named("ImmutableLongArray.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ImmutableLongArrayMiddleSubListAsListGenerator()).named("ImmutableLongArray.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ZERO, CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.RESTRICTS_ELEMENTS, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS})).createTestSuite());
        }
        suite.addTestSuite(ImmutableLongArrayTest.class);
        return suite;
    }

    @GwtIncompatible
    private static ImmutableLongArray makeArray(Long[] values) {
        return ImmutableLongArray.copyOf(Arrays.asList(values));
    }

    @GwtIncompatible
    private static Long[] concat(Long[] a, Long[] b) {
        return (Long[])ObjectArrays.concat((Object[])a, (Object[])b, Long.class);
    }

    @GwtIncompatible
    public static class SampleLongs
    extends SampleElements<Long> {
        public SampleLongs() {
            super((Object)0x80000000L, (Object)0x200000000L, (Object)0x1000000000L, (Object)0x10000000000L, (Object)0x200000000000L);
        }
    }

    @GwtIncompatible
    public static abstract class TestLongListGenerator
    implements TestListGenerator<Long> {
        public SampleElements<Long> samples() {
            return new SampleLongs();
        }

        public List<Long> create(Object ... elements) {
            Long[] array = new Long[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Long)e;
            }
            return this.create(array);
        }

        protected abstract List<Long> create(Long[] var1);

        public Long[] createArray(int length) {
            return new Long[length];
        }

        public List<Long> order(List<Long> insertionOrder) {
            return insertionOrder;
        }
    }

    @GwtIncompatible
    public static final class ImmutableLongArrayMiddleSubListAsListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] prefix = new Long[]{Long.MIN_VALUE, Long.MAX_VALUE};
            Long[] suffix = new Long[]{86L, 99L};
            Long[] all = ImmutableLongArrayTest.concat(ImmutableLongArrayTest.concat(prefix, elements), suffix);
            return ImmutableLongArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableLongArrayTailSubListAsListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] prefix = new Long[]{86L, 99L};
            Long[] all = ImmutableLongArrayTest.concat(prefix, elements);
            return ImmutableLongArrayTest.makeArray(all).subArray(2, elements.length + 2).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableLongArrayHeadSubListAsListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] suffix = new Long[]{Long.MIN_VALUE, Long.MAX_VALUE};
            Long[] all = ImmutableLongArrayTest.concat(elements, suffix);
            return ImmutableLongArrayTest.makeArray(all).subArray(0, elements.length).asList();
        }
    }

    @GwtIncompatible
    public static final class ImmutableLongArrayAsListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            return ImmutableLongArrayTest.makeArray(elements).asList();
        }
    }

    private static enum BuilderOp {
        ADD_ONE{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                builder.add(counter.getAndIncrement());
            }
        }
        ,
        ADD_ARRAY{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                long[] array = new long[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        }
        ,
        ADD_COLLECTION{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                ArrayList<Long> list = new ArrayList<Long>();
                long num = RANDOM.nextInt(10);
                int i = 0;
                while ((long)i < num) {
                    list.add(counter.getAndIncrement());
                    ++i;
                }
                builder.addAll(list);
            }
        }
        ,
        ADD_ITERABLE{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                ArrayList<Long> list = new ArrayList<Long>();
                long num = RANDOM.nextInt(10);
                int i = 0;
                while ((long)i < num) {
                    list.add(counter.getAndIncrement());
                    ++i;
                }
                builder.addAll(ImmutableLongArrayTest.iterable(list));
            }
        }
        ,
        ADD_STREAM{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                long[] array = new long[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(Arrays.stream(array));
            }
        }
        ,
        ADD_IIA{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                long[] array = new long[RANDOM.nextInt(10)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(ImmutableLongArray.copyOf((long[])array));
            }
        }
        ,
        ADD_LARGER_ARRAY{

            @Override
            void doIt(ImmutableLongArray.Builder builder, AtomicLong counter) {
                long[] array = new long[RANDOM.nextInt(200) + 200];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = counter.getAndIncrement();
                }
                builder.addAll(array);
            }
        };

        static final BuilderOp[] values;

        static BuilderOp randomOp() {
            return values[RANDOM.nextInt(values.length)];
        }

        abstract void doIt(ImmutableLongArray.Builder var1, AtomicLong var2);

        static {
            values = BuilderOp.values();
        }
    }
}

