/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Longs;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class LongsTest
extends TestCase {
    private static final long[] EMPTY = new long[0];
    private static final long[] ARRAY1 = new long[]{1L};
    private static final long[] ARRAY234 = new long[]{2L, 3L, 4L};
    private static final long[] VALUES = new long[]{Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE};

    @GwtIncompatible
    public void testHashCode() {
        for (long value : VALUES) {
            LongsTest.assertEquals((String)("hashCode for " + value), (int)Long.valueOf(value).hashCode(), (int)Longs.hashCode((long)value));
        }
    }

    public void testCompare() {
        for (long x : VALUES) {
            for (long y : VALUES) {
                LongsTest.assertEquals((String)(x + ", " + y), (int)Long.valueOf(x).compareTo(y), (int)Longs.compare((long)x, (long)y));
            }
        }
    }

    public void testContains() {
        LongsTest.assertFalse((boolean)Longs.contains((long[])EMPTY, (long)1L));
        LongsTest.assertFalse((boolean)Longs.contains((long[])ARRAY1, (long)2L));
        LongsTest.assertFalse((boolean)Longs.contains((long[])ARRAY234, (long)1L));
        LongsTest.assertTrue((boolean)Longs.contains((long[])new long[]{-1L}, (long)-1L));
        LongsTest.assertTrue((boolean)Longs.contains((long[])ARRAY234, (long)2L));
        LongsTest.assertTrue((boolean)Longs.contains((long[])ARRAY234, (long)3L));
        LongsTest.assertTrue((boolean)Longs.contains((long[])ARRAY234, (long)4L));
    }

    public void testIndexOf() {
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])EMPTY, (long)1L));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])ARRAY1, (long)2L));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])ARRAY234, (long)1L));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])new long[]{-1L}, (long)-1L));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])ARRAY234, (long)2L));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])ARRAY234, (long)3L));
        LongsTest.assertEquals((int)2, (int)Longs.indexOf((long[])ARRAY234, (long)4L));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])new long[]{2L, 3L, 2L, 3L}, (long)3L));
    }

    public void testIndexOf_arrayTarget() {
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])EMPTY, (long[])EMPTY));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])ARRAY234, (long[])EMPTY));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])EMPTY, (long[])ARRAY234));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])ARRAY234, (long[])ARRAY1));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])ARRAY1, (long[])ARRAY234));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])ARRAY1, (long[])ARRAY1));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])ARRAY234, (long[])ARRAY234));
        LongsTest.assertEquals((int)0, (int)Longs.indexOf((long[])ARRAY234, (long[])new long[]{2L, 3L}));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])ARRAY234, (long[])new long[]{3L, 4L}));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])ARRAY234, (long[])new long[]{3L}));
        LongsTest.assertEquals((int)2, (int)Longs.indexOf((long[])ARRAY234, (long[])new long[]{4L}));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])new long[]{2L, 3L, 3L, 3L, 3L}, (long[])new long[]{3L}));
        LongsTest.assertEquals((int)2, (int)Longs.indexOf((long[])new long[]{2L, 3L, 2L, 3L, 4L, 2L, 3L}, (long[])new long[]{2L, 3L, 4L}));
        LongsTest.assertEquals((int)1, (int)Longs.indexOf((long[])new long[]{2L, 2L, 3L, 4L, 2L, 3L, 4L}, (long[])new long[]{2L, 3L, 4L}));
        LongsTest.assertEquals((int)-1, (int)Longs.indexOf((long[])new long[]{4L, 3L, 2L}, (long[])new long[]{2L, 3L, 4L}));
    }

    public void testLastIndexOf() {
        LongsTest.assertEquals((int)-1, (int)Longs.lastIndexOf((long[])EMPTY, (long)1L));
        LongsTest.assertEquals((int)-1, (int)Longs.lastIndexOf((long[])ARRAY1, (long)2L));
        LongsTest.assertEquals((int)-1, (int)Longs.lastIndexOf((long[])ARRAY234, (long)1L));
        LongsTest.assertEquals((int)0, (int)Longs.lastIndexOf((long[])new long[]{-1L}, (long)-1L));
        LongsTest.assertEquals((int)0, (int)Longs.lastIndexOf((long[])ARRAY234, (long)2L));
        LongsTest.assertEquals((int)1, (int)Longs.lastIndexOf((long[])ARRAY234, (long)3L));
        LongsTest.assertEquals((int)2, (int)Longs.lastIndexOf((long[])ARRAY234, (long)4L));
        LongsTest.assertEquals((int)3, (int)Longs.lastIndexOf((long[])new long[]{2L, 3L, 2L, 3L}, (long)3L));
    }

    public void testMax_noArgs() {
        try {
            Longs.max((long[])new long[0]);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        LongsTest.assertEquals((long)Long.MIN_VALUE, (long)Longs.max((long[])new long[]{Long.MIN_VALUE}));
        LongsTest.assertEquals((long)Long.MAX_VALUE, (long)Longs.max((long[])new long[]{Long.MAX_VALUE}));
        LongsTest.assertEquals((long)9L, (long)Longs.max((long[])new long[]{8L, 6L, 7L, 5L, 3L, 0L, 9L}));
    }

    public void testMin_noArgs() {
        try {
            Longs.min((long[])new long[0]);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        LongsTest.assertEquals((long)Long.MIN_VALUE, (long)Longs.min((long[])new long[]{Long.MIN_VALUE}));
        LongsTest.assertEquals((long)Long.MAX_VALUE, (long)Longs.min((long[])new long[]{Long.MAX_VALUE}));
        LongsTest.assertEquals((long)0L, (long)Longs.min((long[])new long[]{8L, 6L, 7L, 5L, 3L, 0L, 9L}));
    }

    public void testConstrainToRange() {
        LongsTest.assertEquals((long)1L, (long)Longs.constrainToRange((long)1L, (long)0L, (long)5L));
        LongsTest.assertEquals((long)1L, (long)Longs.constrainToRange((long)1L, (long)1L, (long)5L));
        LongsTest.assertEquals((long)3L, (long)Longs.constrainToRange((long)1L, (long)3L, (long)5L));
        LongsTest.assertEquals((long)-1L, (long)Longs.constrainToRange((long)0L, (long)-5L, (long)-1L));
        LongsTest.assertEquals((long)2L, (long)Longs.constrainToRange((long)5L, (long)2L, (long)2L));
        try {
            Longs.constrainToRange((long)1L, (long)3L, (long)2L);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConcat() {
        LongsTest.assertTrue((boolean)Arrays.equals(EMPTY, Longs.concat((long[][])new long[0][])));
        LongsTest.assertTrue((boolean)Arrays.equals(EMPTY, Longs.concat((long[][])new long[][]{EMPTY})));
        LongsTest.assertTrue((boolean)Arrays.equals(EMPTY, Longs.concat((long[][])new long[][]{EMPTY, EMPTY, EMPTY})));
        LongsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Longs.concat((long[][])new long[][]{ARRAY1})));
        LongsTest.assertNotSame((Object)ARRAY1, (Object)Longs.concat((long[][])new long[][]{ARRAY1}));
        LongsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Longs.concat((long[][])new long[][]{EMPTY, ARRAY1, EMPTY})));
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 1L, 1L}, Longs.concat((long[][])new long[][]{ARRAY1, ARRAY1, ARRAY1})));
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 3L, 4L}, Longs.concat((long[][])new long[][]{ARRAY1, ARRAY234})));
    }

    private static void assertByteArrayEquals(byte[] expected, byte[] actual) {
        LongsTest.assertTrue((String)("Expected: " + Arrays.toString(expected) + ", but got: " + Arrays.toString(actual)), (boolean)Arrays.equals(expected, actual));
    }

    public void testToByteArray() {
        LongsTest.assertByteArrayEquals(new byte[]{18, 19, 20, 21, 22, 23, 24, 25}, Longs.toByteArray((long)1302406798037686297L));
        LongsTest.assertByteArrayEquals(new byte[]{-1, -18, -35, -52, -69, -86, -103, -120}, Longs.toByteArray((long)-4822678189205112L));
    }

    public void testFromByteArray() {
        LongsTest.assertEquals((long)1302406798037686297L, (long)Longs.fromByteArray((byte[])new byte[]{18, 19, 20, 21, 22, 23, 24, 25, 51}));
        LongsTest.assertEquals((long)-4822678189205112L, (long)Longs.fromByteArray((byte[])new byte[]{-1, -18, -35, -52, -69, -86, -103, -120}));
    }

    public void testFromByteArrayFails() {
        try {
            Longs.fromByteArray((byte[])new byte[7]);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromBytes() {
        LongsTest.assertEquals((long)1302406798037686297L, (long)Longs.fromBytes((byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23, (byte)24, (byte)25));
        LongsTest.assertEquals((long)-4822678189205112L, (long)Longs.fromBytes((byte)-1, (byte)-18, (byte)-35, (byte)-52, (byte)-69, (byte)-86, (byte)-103, (byte)-120));
    }

    public void testByteArrayRoundTrips() {
        Random r = new Random(5L);
        byte[] b = new byte[8];
        for (int i = 0; i < 10000; ++i) {
            long num = r.nextLong();
            LongsTest.assertEquals((long)num, (long)Longs.fromByteArray((byte[])Longs.toByteArray((long)num)));
            r.nextBytes(b);
            long value = Longs.fromByteArray((byte[])b);
            LongsTest.assertTrue((String)("" + value), (boolean)Arrays.equals(b, Longs.toByteArray((long)value)));
        }
    }

    public void testEnsureCapacity() {
        LongsTest.assertSame((Object)EMPTY, (Object)Longs.ensureCapacity((long[])EMPTY, (int)0, (int)1));
        LongsTest.assertSame((Object)ARRAY1, (Object)Longs.ensureCapacity((long[])ARRAY1, (int)0, (int)1));
        LongsTest.assertSame((Object)ARRAY1, (Object)Longs.ensureCapacity((long[])ARRAY1, (int)1, (int)1));
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 0L, 0L}, Longs.ensureCapacity((long[])ARRAY1, (int)2, (int)1)));
    }

    public void testEnsureCapacity_fail() {
        try {
            Longs.ensureCapacity((long[])ARRAY1, (int)-1, (int)1);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Longs.ensureCapacity((long[])ARRAY1, (int)1, (int)-1);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testJoin() {
        LongsTest.assertEquals((String)"", (String)Longs.join((String)",", (long[])EMPTY));
        LongsTest.assertEquals((String)"1", (String)Longs.join((String)",", (long[])ARRAY1));
        LongsTest.assertEquals((String)"1,2", (String)Longs.join((String)",", (long[])new long[]{1L, 2L}));
        LongsTest.assertEquals((String)"123", (String)Longs.join((String)"", (long[])new long[]{1L, 2L, 3L}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new long[0], {Long.MIN_VALUE}, {Long.MIN_VALUE, Long.MIN_VALUE}, {Long.MIN_VALUE, 1L}, {1L}, {1L, Long.MIN_VALUE}, {Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL}, {Long.MAX_VALUE, Long.MAX_VALUE}, {Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE});
        Comparator comparator = Longs.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = Longs.lexicographicalComparator();
        LongsTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    public void testReverse() {
        LongsTest.testReverse(new long[0], new long[0]);
        LongsTest.testReverse(new long[]{1L}, new long[]{1L});
        LongsTest.testReverse(new long[]{1L, 2L}, new long[]{2L, 1L});
        LongsTest.testReverse(new long[]{3L, 1L, 1L}, new long[]{1L, 1L, 3L});
        LongsTest.testReverse(new long[]{-1L, 1L, -2L, 2L}, new long[]{2L, -2L, 1L, -1L});
    }

    public void testReverseIndexed() {
        LongsTest.testReverse(new long[0], 0, 0, new long[0]);
        LongsTest.testReverse(new long[]{1L}, 0, 1, new long[]{1L});
        LongsTest.testReverse(new long[]{1L, 2L}, 0, 2, new long[]{2L, 1L});
        LongsTest.testReverse(new long[]{3L, 1L, 1L}, 0, 2, new long[]{1L, 3L, 1L});
        LongsTest.testReverse(new long[]{3L, 1L, 1L}, 0, 1, new long[]{3L, 1L, 1L});
        LongsTest.testReverse(new long[]{-1L, 1L, -2L, 2L}, 1, 3, new long[]{-1L, -2L, 1L, 2L});
    }

    private static void testReverse(long[] input, long[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Longs.reverse((long[])input);
        LongsTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    private static void testReverse(long[] input, int fromIndex, int toIndex, long[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Longs.reverse((long[])input, (int)fromIndex, (int)toIndex);
        LongsTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    public void testSortDescending() {
        LongsTest.testSortDescending(new long[0], new long[0]);
        LongsTest.testSortDescending(new long[]{1L}, new long[]{1L});
        LongsTest.testSortDescending(new long[]{1L, 2L}, new long[]{2L, 1L});
        LongsTest.testSortDescending(new long[]{1L, 3L, 1L}, new long[]{3L, 1L, 1L});
        LongsTest.testSortDescending(new long[]{-1L, 1L, -2L, 2L}, new long[]{2L, 1L, -1L, -2L});
    }

    public void testSortDescendingIndexed() {
        LongsTest.testSortDescending(new long[0], 0, 0, new long[0]);
        LongsTest.testSortDescending(new long[]{1L}, 0, 1, new long[]{1L});
        LongsTest.testSortDescending(new long[]{1L, 2L}, 0, 2, new long[]{2L, 1L});
        LongsTest.testSortDescending(new long[]{1L, 3L, 1L}, 0, 2, new long[]{3L, 1L, 1L});
        LongsTest.testSortDescending(new long[]{1L, 3L, 1L}, 0, 1, new long[]{1L, 3L, 1L});
        LongsTest.testSortDescending(new long[]{-1L, -2L, 1L, 2L}, 1, 3, new long[]{-1L, 1L, -2L, 2L});
    }

    private static void testSortDescending(long[] input, long[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Longs.sortDescending((long[])input);
        LongsTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    private static void testSortDescending(long[] input, int fromIndex, int toIndex, long[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        Longs.sortDescending((long[])input, (int)fromIndex, (int)toIndex);
        LongsTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    @GwtIncompatible
    public void testStringConverterSerialization() {
        SerializableTester.reserializeAndAssert((Object)Longs.stringConverter());
    }

    public void testToArray() {
        List<Long> none = Arrays.asList(new Long[0]);
        LongsTest.assertTrue((boolean)Arrays.equals(EMPTY, Longs.toArray(none)));
        List<Long> one = Arrays.asList(1L);
        LongsTest.assertTrue((boolean)Arrays.equals(ARRAY1, Longs.toArray(one)));
        long[] array = new long[]{0L, 1L, 16718874L};
        List<Long> three = Arrays.asList(0L, 1L, 16718874L);
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(three)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray((Collection)Longs.asList((long[])array))));
    }

    public void testToArray_threadSafe() {
        for (int delta : new int[]{1, 0, -1}) {
            for (int i = 0; i < VALUES.length; ++i) {
                List list = Longs.asList((long[])VALUES).subList(0, i);
                Collection misleadingSize = Helpers.misleadingSizeCollection((int)delta);
                misleadingSize.addAll(list);
                long[] arr = Longs.toArray((Collection)misleadingSize);
                LongsTest.assertEquals((int)i, (int)arr.length);
                for (int j = 0; j < i; ++j) {
                    LongsTest.assertEquals((long)VALUES[j], (long)arr[j]);
                }
            }
        }
    }

    public void testToArray_withNull() {
        List<Long> list = Arrays.asList(0L, 1L, null);
        try {
            Longs.toArray(list);
            LongsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray_withConversion() {
        long[] array = new long[]{0L, 1L, 2L};
        List<Byte> bytes = Arrays.asList((byte)0, (byte)1, (byte)2);
        List<Short> shorts = Arrays.asList((short)0, (short)1, (short)2);
        List<Integer> ints = Arrays.asList(0, 1, 2);
        List<Float> floats = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f));
        List<Long> longs = Arrays.asList(0L, 1L, 2L);
        List<Double> doubles = Arrays.asList(0.0, 1.0, 2.0);
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(bytes)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(shorts)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(ints)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(floats)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(longs)));
        LongsTest.assertTrue((boolean)Arrays.equals(array, Longs.toArray(doubles)));
    }

    public void testAsList_isAView() {
        long[] array = new long[]{0L, 1L};
        List list = Longs.asList((long[])array);
        list.set(0, 2L);
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, array));
        array[1] = 3L;
        LongsTest.assertEquals(Arrays.asList(2L, 3L), (Object)list);
    }

    public void testAsList_toArray_roundTrip() {
        long[] array = new long[]{0L, 1L, 2L};
        List list = Longs.asList((long[])array);
        long[] newArray = Longs.toArray((Collection)list);
        list.set(0, 4L);
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{0L, 1L, 2L}, newArray));
        newArray[1] = 5L;
        LongsTest.assertEquals((long)1L, (long)((Long)list.get(1)));
    }

    public void testAsList_subList_toArray_roundTrip() {
        long[] array = new long[]{0L, 1L, 2L, 3L};
        List list = Longs.asList((long[])array);
        LongsTest.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L}, Longs.toArray(list.subList(1, 3))));
        LongsTest.assertTrue((boolean)Arrays.equals(new long[0], Longs.toArray(list.subList(2, 2))));
    }

    public void testAsListEmpty() {
        LongsTest.assertSame(Collections.emptyList(), (Object)Longs.asList((long[])EMPTY));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(Longs.class);
    }

    public void testStringConverter_convert() {
        Converter converter = Longs.stringConverter();
        LongsTest.assertEquals((Object)1L, (Object)converter.convert((Object)"1"));
        LongsTest.assertEquals((Object)0L, (Object)converter.convert((Object)"0"));
        LongsTest.assertEquals((Object)-1L, (Object)converter.convert((Object)"-1"));
        LongsTest.assertEquals((Object)255L, (Object)converter.convert((Object)"0xff"));
        LongsTest.assertEquals((Object)255L, (Object)converter.convert((Object)"0xFF"));
        LongsTest.assertEquals((Object)-255L, (Object)converter.convert((Object)"-0xFF"));
        LongsTest.assertEquals((Object)255L, (Object)converter.convert((Object)"#0000FF"));
        LongsTest.assertEquals((Object)438L, (Object)converter.convert((Object)"0666"));
    }

    public void testStringConverter_convertError() {
        try {
            Longs.stringConverter().convert((Object)"notanumber");
            LongsTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testStringConverter_nullConversions() {
        LongsTest.assertNull((Object)Longs.stringConverter().convert(null));
        LongsTest.assertNull((Object)Longs.stringConverter().reverse().convert(null));
    }

    public void testStringConverter_reverse() {
        Converter converter = Longs.stringConverter();
        LongsTest.assertEquals((String)"1", (String)((String)converter.reverse().convert((Object)1L)));
        LongsTest.assertEquals((String)"0", (String)((String)converter.reverse().convert((Object)0L)));
        LongsTest.assertEquals((String)"-1", (String)((String)converter.reverse().convert((Object)-1L)));
        LongsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255L)));
        LongsTest.assertEquals((String)"255", (String)((String)converter.reverse().convert((Object)255L)));
        LongsTest.assertEquals((String)"-255", (String)((String)converter.reverse().convert((Object)-255L)));
        LongsTest.assertEquals((String)"438", (String)((String)converter.reverse().convert((Object)438L)));
    }

    @GwtIncompatible
    public void testStringConverter_nullPointerTester() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)Longs.stringConverter());
    }

    public void testTryParse() {
        LongsTest.tryParseAndAssertEquals(0L, "0");
        LongsTest.tryParseAndAssertEquals(0L, "-0");
        LongsTest.tryParseAndAssertEquals(1L, "1");
        LongsTest.tryParseAndAssertEquals(-1L, "-1");
        LongsTest.tryParseAndAssertEquals(8900L, "8900");
        LongsTest.tryParseAndAssertEquals(-8900L, "-8900");
        LongsTest.tryParseAndAssertEquals(Long.MAX_VALUE, Long.toString(Long.MAX_VALUE));
        LongsTest.tryParseAndAssertEquals(Long.MIN_VALUE, Long.toString(Long.MIN_VALUE));
        LongsTest.assertNull((Object)Longs.tryParse((String)""));
        LongsTest.assertNull((Object)Longs.tryParse((String)"-"));
        LongsTest.assertNull((Object)Longs.tryParse((String)"+1"));
        LongsTest.assertNull((Object)Longs.tryParse((String)"999999999999999999999999"));
        LongsTest.assertNull((String)"Max long + 1", (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).toString()));
        LongsTest.assertNull((String)"Max long * 10", (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.TEN).toString()));
        LongsTest.assertNull((String)"Min long - 1", (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE).toString()));
        LongsTest.assertNull((String)"Min long * 10", (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MIN_VALUE).multiply(BigInteger.TEN).toString()));
        LongsTest.assertNull((Object)Longs.tryParse((String)"\u0662\u06f3"));
    }

    private static void tryParseAndAssertEquals(Long expected, String value) {
        LongsTest.assertEquals((Object)expected, (Object)Longs.tryParse((String)value));
    }

    public void testTryParse_radix() {
        for (int radix = 2; radix <= 36; ++radix) {
            LongsTest.radixEncodeParseAndAssertEquals(0L, radix);
            LongsTest.radixEncodeParseAndAssertEquals(8000L, radix);
            LongsTest.radixEncodeParseAndAssertEquals(-8000L, radix);
            LongsTest.radixEncodeParseAndAssertEquals(Long.MAX_VALUE, radix);
            LongsTest.radixEncodeParseAndAssertEquals(Long.MIN_VALUE, radix);
            LongsTest.assertNull((String)("Radix: " + radix), (Object)Longs.tryParse((String)"999999999999999999999999", (int)radix));
            LongsTest.assertNull((String)("Radix: " + radix), (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).toString(), (int)radix));
            LongsTest.assertNull((String)("Radix: " + radix), (Object)Longs.tryParse((String)BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE).toString(), (int)radix));
        }
        LongsTest.assertNull((String)"Hex string and dec parm", (Object)Longs.tryParse((String)"FFFF", (int)10));
        LongsTest.assertEquals((String)"Mixed hex case", (long)65535L, (long)Longs.tryParse((String)"ffFF", (int)16));
    }

    private static void radixEncodeParseAndAssertEquals(Long value, int radix) {
        LongsTest.assertEquals((String)("Radix: " + radix), (Object)value, (Object)Longs.tryParse((String)Long.toString(value, radix), (int)radix));
    }

    public void testTryParse_radixTooBig() {
        try {
            Longs.tryParse((String)"0", (int)37);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTryParse_radixTooSmall() {
        try {
            Longs.tryParse((String)"0", (int)1);
            LongsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTryParse_withNullGwt() {
        LongsTest.assertNull((Object)Longs.tryParse((String)"null"));
        try {
            Longs.tryParse(null);
            LongsTest.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

