/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Shorts;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ShortArrayAsListTest
extends TestCase {
    private static List<Short> asList(Short[] values) {
        short[] temp = new short[values.length];
        for (int i = 0; i < values.length; i = (int)((short)(i + 1))) {
            temp[i] = (Short)Preconditions.checkNotNull((Object)values[i]);
        }
        return Shorts.asList((short[])temp);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new ShortsAsListGenerator()).named("Shorts.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ShortsAsListHeadSubListGenerator()).named("Shorts.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ShortsAsListTailSubListGenerator()).named("Shorts.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new ShortsAsListMiddleSubListGenerator()).named("Shorts.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Short[] concat(Short[] left, Short[] right) {
        Short[] result = new Short[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static class SampleShorts
    extends SampleElements<Short> {
        public SampleShorts() {
            super((Object)0, (Object)1, (Object)2, (Object)3, (Object)4);
        }
    }

    public static abstract class TestShortListGenerator
    implements TestListGenerator<Short> {
        public SampleElements<Short> samples() {
            return new SampleShorts();
        }

        public List<Short> create(Object ... elements) {
            Short[] array = new Short[elements.length];
            int i = 0;
            for (Object e : elements) {
                int n = i;
                i = (short)(i + 1);
                array[n] = (Short)e;
            }
            return this.create(array);
        }

        protected abstract List<Short> create(Short[] var1);

        public Short[] createArray(int length) {
            return new Short[length];
        }

        public List<Short> order(List<Short> insertionOrder) {
            return insertionOrder;
        }
    }

    public static final class ShortsAsListMiddleSubListGenerator
    extends TestShortListGenerator {
        @Override
        protected List<Short> create(Short[] elements) {
            Short[] prefix = new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE};
            Short[] suffix = new Short[]{(short)86, (short)99};
            Short[] all = ShortArrayAsListTest.concat(ShortArrayAsListTest.concat(prefix, elements), suffix);
            return ShortArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class ShortsAsListTailSubListGenerator
    extends TestShortListGenerator {
        @Override
        protected List<Short> create(Short[] elements) {
            Short[] prefix = new Short[]{(short)86, (short)99};
            Short[] all = ShortArrayAsListTest.concat(prefix, elements);
            return ShortArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class ShortsAsListHeadSubListGenerator
    extends TestShortListGenerator {
        @Override
        protected List<Short> create(Short[] elements) {
            Short[] suffix = new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE};
            Short[] all = ShortArrayAsListTest.concat(elements, suffix);
            return ShortArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    public static final class ShortsAsListGenerator
    extends TestShortListGenerator {
        @Override
        protected List<Short> create(Short[] elements) {
            return ShortArrayAsListTest.asList(elements);
        }
    }
}

