/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.SignedBytes;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class SignedBytesTest
extends TestCase {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] ARRAY1 = new byte[]{1};
    private static final byte LEAST = -128;
    private static final byte GREATEST = 127;
    private static final byte[] VALUES = new byte[]{-128, -1, 0, 1, 127};

    public void testCheckedCast() {
        for (byte value : VALUES) {
            SignedBytesTest.assertEquals((byte)value, (byte)SignedBytes.checkedCast((long)value));
        }
        SignedBytesTest.assertCastFails(128L);
        SignedBytesTest.assertCastFails(-129L);
        SignedBytesTest.assertCastFails(Long.MAX_VALUE);
        SignedBytesTest.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (byte value : VALUES) {
            SignedBytesTest.assertEquals((byte)value, (byte)SignedBytes.saturatedCast((long)value));
        }
        SignedBytesTest.assertEquals((byte)127, (byte)SignedBytes.saturatedCast((long)128L));
        SignedBytesTest.assertEquals((byte)-128, (byte)SignedBytes.saturatedCast((long)-129L));
        SignedBytesTest.assertEquals((byte)127, (byte)SignedBytes.saturatedCast((long)Long.MAX_VALUE));
        SignedBytesTest.assertEquals((byte)-128, (byte)SignedBytes.saturatedCast((long)Long.MIN_VALUE));
    }

    private static void assertCastFails(long value) {
        try {
            SignedBytes.checkedCast((long)value);
            SignedBytesTest.fail((String)("Cast to byte should have failed: " + value));
        }
        catch (IllegalArgumentException ex) {
            SignedBytesTest.assertTrue((String)(value + " not found in exception text: " + ex.getMessage()), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (byte x : VALUES) {
            for (byte y : VALUES) {
                int expected = Byte.valueOf(x).compareTo(y);
                int actual = SignedBytes.compare((byte)x, (byte)y);
                if (expected == 0) {
                    SignedBytesTest.assertEquals((String)(x + ", " + y), (int)expected, (int)actual);
                    continue;
                }
                if (expected < 0) {
                    SignedBytesTest.assertTrue((String)(x + ", " + y + " (expected: " + expected + ", actual" + actual + ")"), (actual < 0 ? 1 : 0) != 0);
                    continue;
                }
                SignedBytesTest.assertTrue((String)(x + ", " + y + " (expected: " + expected + ", actual" + actual + ")"), (actual > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testMax_noArgs() {
        try {
            SignedBytes.max((byte[])new byte[0]);
            SignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        SignedBytesTest.assertEquals((byte)-128, (byte)SignedBytes.max((byte[])new byte[]{-128}));
        SignedBytesTest.assertEquals((byte)127, (byte)SignedBytes.max((byte[])new byte[]{127}));
        SignedBytesTest.assertEquals((byte)127, (byte)SignedBytes.max((byte[])new byte[]{0, -128, -1, 127, 1}));
    }

    public void testMin_noArgs() {
        try {
            SignedBytes.min((byte[])new byte[0]);
            SignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        SignedBytesTest.assertEquals((byte)-128, (byte)SignedBytes.min((byte[])new byte[]{-128}));
        SignedBytesTest.assertEquals((byte)127, (byte)SignedBytes.min((byte[])new byte[]{127}));
        SignedBytesTest.assertEquals((byte)-128, (byte)SignedBytes.min((byte[])new byte[]{0, -128, -1, 127, 1}));
    }

    public void testJoin() {
        SignedBytesTest.assertEquals((String)"", (String)SignedBytes.join((String)",", (byte[])EMPTY));
        SignedBytesTest.assertEquals((String)"1", (String)SignedBytes.join((String)",", (byte[])ARRAY1));
        SignedBytesTest.assertEquals((String)"1,2", (String)SignedBytes.join((String)",", (byte[])new byte[]{1, 2}));
        SignedBytesTest.assertEquals((String)"123", (String)SignedBytes.join((String)"", (byte[])new byte[]{1, 2, 3}));
        SignedBytesTest.assertEquals((String)"-128,-1", (String)SignedBytes.join((String)",", (byte[])new byte[]{-128, -1}));
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new byte[0], {-128}, {-128, -128}, {-128, 1}, {1}, {1, -128}, {127, 126}, {127, 127}, {127, 127, 127});
        Comparator comparator = SignedBytes.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
    }

    @GwtIncompatible
    public void testLexicographicalComparatorSerializable() {
        Comparator comparator = SignedBytes.lexicographicalComparator();
        SignedBytesTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
    }

    public void testSortDescending() {
        SignedBytesTest.testSortDescending(new byte[0], new byte[0]);
        SignedBytesTest.testSortDescending(new byte[]{1}, new byte[]{1});
        SignedBytesTest.testSortDescending(new byte[]{1, 2}, new byte[]{2, 1});
        SignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, new byte[]{3, 1, 1});
        SignedBytesTest.testSortDescending(new byte[]{-1, 1, -2, 2}, new byte[]{2, 1, -1, -2});
    }

    public void testSortDescendingIndexed() {
        SignedBytesTest.testSortDescending(new byte[0], 0, 0, new byte[0]);
        SignedBytesTest.testSortDescending(new byte[]{1}, 0, 1, new byte[]{1});
        SignedBytesTest.testSortDescending(new byte[]{1, 2}, 0, 2, new byte[]{2, 1});
        SignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, 0, 2, new byte[]{3, 1, 1});
        SignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, 0, 1, new byte[]{1, 3, 1});
        SignedBytesTest.testSortDescending(new byte[]{-1, -2, 1, 2}, 1, 3, new byte[]{-1, 1, -2, 2});
    }

    private static void testSortDescending(byte[] input, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        SignedBytes.sortDescending((byte[])input);
        SignedBytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    private static void testSortDescending(byte[] input, int fromIndex, int toIndex, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        SignedBytes.sortDescending((byte[])input, (int)fromIndex, (int)toIndex);
        SignedBytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(SignedBytes.class);
    }
}

