/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class UnsignedBytesTest
extends TestCase {
    private static final byte LEAST = 0;
    private static final byte GREATEST = -1;
    private static final byte[] VALUES = new byte[]{0, 127, -128, -127, -1};

    public void testToInt() {
        UnsignedBytesTest.assertEquals((int)0, (int)UnsignedBytes.toInt((byte)0));
        UnsignedBytesTest.assertEquals((int)1, (int)UnsignedBytes.toInt((byte)1));
        UnsignedBytesTest.assertEquals((int)127, (int)UnsignedBytes.toInt((byte)127));
        UnsignedBytesTest.assertEquals((int)128, (int)UnsignedBytes.toInt((byte)-128));
        UnsignedBytesTest.assertEquals((int)129, (int)UnsignedBytes.toInt((byte)-127));
        UnsignedBytesTest.assertEquals((int)255, (int)UnsignedBytes.toInt((byte)-1));
    }

    public void testCheckedCast() {
        for (byte value : VALUES) {
            UnsignedBytesTest.assertEquals((byte)value, (byte)UnsignedBytes.checkedCast((long)UnsignedBytes.toInt((byte)value)));
        }
        UnsignedBytesTest.assertCastFails(256L);
        UnsignedBytesTest.assertCastFails(-1L);
        UnsignedBytesTest.assertCastFails(Long.MAX_VALUE);
        UnsignedBytesTest.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (byte value : VALUES) {
            UnsignedBytesTest.assertEquals((byte)value, (byte)UnsignedBytes.saturatedCast((long)UnsignedBytes.toInt((byte)value)));
        }
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.saturatedCast((long)256L));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.saturatedCast((long)-1L));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.saturatedCast((long)Long.MAX_VALUE));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.saturatedCast((long)Long.MIN_VALUE));
    }

    private static void assertCastFails(long value) {
        try {
            UnsignedBytes.checkedCast((long)value);
            UnsignedBytesTest.fail((String)("Cast to byte should have failed: " + value));
        }
        catch (IllegalArgumentException ex) {
            UnsignedBytesTest.assertTrue((String)(value + " not found in exception text: " + ex.getMessage()), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (int i = 0; i < VALUES.length; ++i) {
            for (int j = 0; j < VALUES.length; ++j) {
                byte x = VALUES[i];
                byte y = VALUES[j];
                UnsignedBytesTest.assertEquals((String)(x + ", " + y), (Object)Float.valueOf(Math.signum(UnsignedBytes.compare((byte)x, (byte)y))), (Object)Float.valueOf(Math.signum(Ints.compare((int)i, (int)j))));
            }
        }
    }

    public void testMax_noArgs() {
        try {
            UnsignedBytes.max((byte[])new byte[0]);
            UnsignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.max((byte[])new byte[]{0}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.max((byte[])new byte[]{-1}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.max((byte[])new byte[]{0, -128, -1, 127, 1}));
    }

    public void testMin_noArgs() {
        try {
            UnsignedBytes.min((byte[])new byte[0]);
            UnsignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{0}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.min((byte[])new byte[]{-1}));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{0, -128, -1, 127, 1}));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{-1, 127, 1, -128, 0}));
    }

    private static void assertParseFails(String value) {
        try {
            UnsignedBytes.parseUnsignedByte((String)value);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseUnsignedByte() {
        for (int i = 0; i <= 255; ++i) {
            UnsignedBytesTest.assertEquals((byte)((byte)i), (byte)UnsignedBytes.parseUnsignedByte((String)Integer.toString(i)));
        }
        UnsignedBytesTest.assertParseFails("1000");
        UnsignedBytesTest.assertParseFails("-1");
        UnsignedBytesTest.assertParseFails("-128");
        UnsignedBytesTest.assertParseFails("256");
    }

    public void testMaxValue() {
        UnsignedBytesTest.assertTrue((UnsignedBytes.compare((byte)-1, (byte)0) > 0 ? 1 : 0) != 0);
    }

    private static void assertParseFails(String value, int radix) {
        try {
            UnsignedBytes.parseUnsignedByte((String)value, (int)radix);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseUnsignedByteWithRadix() throws NumberFormatException {
        for (int radix = 2; radix <= 36; ++radix) {
            for (int i = 0; i <= 255; ++i) {
                UnsignedBytesTest.assertEquals((byte)((byte)i), (byte)UnsignedBytes.parseUnsignedByte((String)Integer.toString(i, radix), (int)radix));
            }
            UnsignedBytesTest.assertParseFails(Integer.toString(1000, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(-1, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(-128, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(256, radix), radix);
        }
    }

    public void testParseUnsignedByteThrowsExceptionForInvalidRadix() {
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)1);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)37);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)-1);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testToString() {
        for (int i = 0; i <= 255; ++i) {
            UnsignedBytesTest.assertEquals((String)Integer.toString(i), (String)UnsignedBytes.toString((byte)((byte)i)));
        }
    }

    public void testToStringWithRadix() {
        for (int radix = 2; radix <= 36; ++radix) {
            for (int i = 0; i <= 255; ++i) {
                UnsignedBytesTest.assertEquals((String)Integer.toString(i, radix), (String)UnsignedBytes.toString((byte)((byte)i), (int)radix));
            }
        }
    }

    public void testJoin() {
        UnsignedBytesTest.assertEquals((String)"", (String)UnsignedBytes.join((String)",", (byte[])new byte[0]));
        UnsignedBytesTest.assertEquals((String)"1", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{1}));
        UnsignedBytesTest.assertEquals((String)"1,2", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{1, 2}));
        UnsignedBytesTest.assertEquals((String)"123", (String)UnsignedBytes.join((String)"", (byte[])new byte[]{1, 2, 3}));
        UnsignedBytesTest.assertEquals((String)"128,255", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{-128, -1}));
    }

    private static String unsafeComparatorClassName() {
        return UnsignedBytes.LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
    }

    private static boolean unsafeComparatorAvailable() {
        try {
            Class.forName(UnsignedBytesTest.unsafeComparatorClassName());
            return true;
        }
        catch (ClassNotFoundException | Error tolerable) {
            return false;
        }
    }

    public void testLexicographicalComparatorChoice() throws Exception {
        Comparator defaultComparator = UnsignedBytes.lexicographicalComparator();
        UnsignedBytesTest.assertNotNull((Object)defaultComparator);
        UnsignedBytesTest.assertSame((Object)defaultComparator, (Object)UnsignedBytes.lexicographicalComparator());
        if (UnsignedBytesTest.unsafeComparatorAvailable()) {
            UnsignedBytesTest.assertSame(defaultComparator.getClass(), Class.forName(UnsignedBytesTest.unsafeComparatorClassName()));
        } else {
            UnsignedBytesTest.assertSame((Object)defaultComparator, (Object)UnsignedBytes.lexicographicalComparatorJavaImpl());
        }
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new byte[0], {0}, {0, 0}, {0, 1}, {1}, {1, 0}, {-1, -2}, {-1, -1}, {-1, -1, -1});
        Comparator comparator = UnsignedBytes.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
        UnsignedBytesTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
        Comparator javaImpl = UnsignedBytes.lexicographicalComparatorJavaImpl();
        Helpers.testComparator((Comparator)javaImpl, ordered);
        UnsignedBytesTest.assertSame((Object)javaImpl, (Object)SerializableTester.reserialize((Object)javaImpl));
    }

    public void testLexicographicalComparatorLongInputs() {
        Random rnd = new Random();
        for (Comparator comparator : Arrays.asList(UnsignedBytes.lexicographicalComparator(), UnsignedBytes.lexicographicalComparatorJavaImpl())) {
            int trials = 10;
            while (trials-- > 0) {
                int i;
                byte[] left = new byte[1 + rnd.nextInt(32)];
                rnd.nextBytes(left);
                byte[] right = (byte[])left.clone();
                UnsignedBytesTest.assertTrue((comparator.compare(left, right) == 0 ? 1 : 0) != 0);
                int n = i = rnd.nextInt(left.length);
                left[n] = (byte)(left[n] ^ (byte)(1 + rnd.nextInt(255)));
                UnsignedBytesTest.assertTrue((comparator.compare(left, right) != 0 ? 1 : 0) != 0);
                UnsignedBytesTest.assertEquals((comparator.compare(left, right) > 0 ? 1 : 0) != 0, (UnsignedBytes.compare((byte)left[i], (byte)right[i]) > 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testSort() {
        UnsignedBytesTest.testSort(new byte[0], new byte[0]);
        UnsignedBytesTest.testSort(new byte[]{2}, new byte[]{2});
        UnsignedBytesTest.testSort(new byte[]{2, 1, 0}, new byte[]{0, 1, 2});
        UnsignedBytesTest.testSort(new byte[]{2, -1, 1, 0}, new byte[]{0, 1, 2, -1});
    }

    static void testSort(byte[] input, byte[] expected) {
        input = Arrays.copyOf(input, input.length);
        UnsignedBytes.sort((byte[])input);
        UnsignedBytesTest.assertTrue((boolean)Arrays.equals(expected, input));
    }

    public void testSortIndexed() {
        UnsignedBytesTest.testSort(new byte[0], 0, 0, new byte[0]);
        UnsignedBytesTest.testSort(new byte[]{2}, 0, 1, new byte[]{2});
        UnsignedBytesTest.testSort(new byte[]{2, 1, 0}, 0, 2, new byte[]{1, 2, 0});
        UnsignedBytesTest.testSort(new byte[]{2, -1, 1, 0}, 1, 4, new byte[]{2, 0, 1, -1});
    }

    static void testSort(byte[] input, int from, int to, byte[] expected) {
        input = Arrays.copyOf(input, input.length);
        UnsignedBytes.sort((byte[])input, (int)from, (int)to);
        UnsignedBytesTest.assertTrue((boolean)Arrays.equals(expected, input));
    }

    public void testSortDescending() {
        UnsignedBytesTest.testSortDescending(new byte[0], new byte[0]);
        UnsignedBytesTest.testSortDescending(new byte[]{1}, new byte[]{1});
        UnsignedBytesTest.testSortDescending(new byte[]{1, 2}, new byte[]{2, 1});
        UnsignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, new byte[]{3, 1, 1});
        UnsignedBytesTest.testSortDescending(new byte[]{-2, 1, -3, 2}, new byte[]{-2, -3, 2, 1});
    }

    public void testSortDescendingIndexed() {
        UnsignedBytesTest.testSortDescending(new byte[0], 0, 0, new byte[0]);
        UnsignedBytesTest.testSortDescending(new byte[]{1}, 0, 1, new byte[]{1});
        UnsignedBytesTest.testSortDescending(new byte[]{1, 2}, 0, 2, new byte[]{2, 1});
        UnsignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, 0, 2, new byte[]{3, 1, 1});
        UnsignedBytesTest.testSortDescending(new byte[]{1, 3, 1}, 0, 1, new byte[]{1, 3, 1});
        UnsignedBytesTest.testSortDescending(new byte[]{-2, 1, -3, 2}, 1, 3, new byte[]{-2, -3, 1, 2});
    }

    private static void testSortDescending(byte[] input, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        UnsignedBytes.sortDescending((byte[])input);
        UnsignedBytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    private static void testSortDescending(byte[] input, int fromIndex, int toIndex, byte[] expectedOutput) {
        input = Arrays.copyOf(input, input.length);
        UnsignedBytes.sortDescending((byte[])input, (int)fromIndex, (int)toIndex);
        UnsignedBytesTest.assertTrue((boolean)Arrays.equals(expectedOutput, input));
    }

    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedBytes.class);
    }
}

