/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class ParameterTest
extends TestCase {
    public void testNulls() {
        for (Method method : ParameterTest.class.getDeclaredMethods()) {
            for (Parameter param : Invokable.from((Method)method).getParameters()) {
                new NullPointerTester().testAllPublicInstanceMethods((Object)param);
            }
        }
    }

    public void testEquals() {
        EqualsTester tester = new EqualsTester();
        for (Method method : ParameterTest.class.getDeclaredMethods()) {
            for (Parameter param : Invokable.from((Method)method).getParameters()) {
                tester.addEqualityGroup(new Object[]{param});
            }
        }
        tester.testEquals();
    }

    private void someMethod(int i, int j) {
    }

    private void anotherMethod(int i, String s) {
    }
}

