/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.Reflection;
import com.google.common.testing.NullPointerTester;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import junit.framework.TestCase;

public class ReflectionTest
extends TestCase {
    private static final InvocationHandler X_RETURNER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return "x";
        }
    };
    private static int classesInitialized = 0;

    public void testGetPackageName() throws Exception {
        ReflectionTest.assertEquals((String)"java.lang", (String)Reflection.getPackageName(Iterable.class));
        ReflectionTest.assertEquals((String)"java", (String)Reflection.getPackageName((String)"java.MyType"));
        ReflectionTest.assertEquals((String)"java.lang", (String)Reflection.getPackageName((String)Iterable.class.getName()));
        ReflectionTest.assertEquals((String)"", (String)Reflection.getPackageName((String)"NoPackage"));
        ReflectionTest.assertEquals((String)"java.util", (String)Reflection.getPackageName(Map.Entry.class));
    }

    public void testNewProxy() throws Exception {
        Runnable runnable = (Runnable)Reflection.newProxy(Runnable.class, (InvocationHandler)X_RETURNER);
        ReflectionTest.assertEquals((String)"x", (String)runnable.toString());
    }

    public void testNewProxyCantWorkOnAClass() throws Exception {
        try {
            Reflection.newProxy(Object.class, (InvocationHandler)X_RETURNER);
            ReflectionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInitialize() {
        ReflectionTest.assertEquals((String)"This test can't be included twice in the same suite.", (int)0, (int)classesInitialized);
        Reflection.initialize((Class[])new Class[]{A.class});
        ReflectionTest.assertEquals((int)1, (int)classesInitialized);
        Reflection.initialize((Class[])new Class[]{A.class, B.class, C.class});
        ReflectionTest.assertEquals((int)3, (int)classesInitialized);
    }

    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Reflection.class);
    }

    private static class C {
        private C() {
        }

        static {
            ++classesInitialized;
        }
    }

    private static class B {
        private B() {
        }

        static {
            ++classesInitialized;
        }
    }

    private static class A {
        private A() {
        }

        static {
            ++classesInitialized;
        }
    }
}

