/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.TypeToken;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.RequiredModifiers;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import javax.lang.model.element.Modifier;

@AndroidIncompatible
abstract class SubtypeTester
implements Cloneable {
    private Method method = null;

    SubtypeTester() {
    }

    final <T> T isSubtype(T sub) {
        Type returnType = this.method.getGenericReturnType();
        Type paramType = this.getOnlyParameterType();
        TestSubtype spec = this.method.getAnnotation(TestSubtype.class);
        ((BooleanSubject)Truth.assertThat((Boolean)TypeToken.of((Type)paramType).isSubtypeOf(returnType)).named("%s is subtype of %s", new Object[]{paramType, returnType})).isTrue();
        ((BooleanSubject)Truth.assertThat((Boolean)TypeToken.of((Type)returnType).isSupertypeOf(paramType)).named("%s is supertype of %s", new Object[]{returnType, paramType})).isTrue();
        if (!spec.suppressGetSubtype()) {
            Truth.assertThat((Object)SubtypeTester.getSubtype(returnType, TypeToken.of((Type)paramType).getRawType())).isEqualTo((Object)paramType);
        }
        if (!spec.suppressGetSupertype()) {
            Truth.assertThat((Object)SubtypeTester.getSupertype(paramType, TypeToken.of((Type)returnType).getRawType())).isEqualTo((Object)returnType);
        }
        return sub;
    }

    final <X> X notSubtype(Object sub) {
        Type returnType = this.method.getGenericReturnType();
        Type paramType = this.getOnlyParameterType();
        TestSubtype spec = this.method.getAnnotation(TestSubtype.class);
        ((BooleanSubject)Truth.assertThat((Boolean)TypeToken.of((Type)paramType).isSubtypeOf(returnType)).named("%s is subtype of %s", new Object[]{paramType, returnType})).isFalse();
        ((BooleanSubject)Truth.assertThat((Boolean)TypeToken.of((Type)returnType).isSupertypeOf(paramType)).named("%s is supertype of %s", new Object[]{returnType, paramType})).isFalse();
        if (!spec.suppressGetSubtype()) {
            try {
                Truth.assertThat((Object)SubtypeTester.getSubtype(returnType, TypeToken.of((Type)paramType).getRawType())).isNotEqualTo((Object)paramType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!spec.suppressGetSupertype()) {
            try {
                Truth.assertThat((Object)SubtypeTester.getSupertype(paramType, TypeToken.of((Type)returnType).getRawType())).isNotEqualTo((Object)returnType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    final void testAllDeclarations() throws Exception {
        Preconditions.checkState((this.method == null ? 1 : 0) != 0);
        Method[] methods = this.getClass().getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method a, Method b) {
                return a.getName().compareTo(b.getName());
            }
        });
        for (Method method : methods) {
            if (!method.isAnnotationPresent(TestSubtype.class)) continue;
            method.setAccessible(true);
            SubtypeTester tester = (SubtypeTester)this.clone();
            tester.method = method;
            method.invoke((Object)tester, new Object[]{null});
        }
    }

    private Type getOnlyParameterType() {
        Truth.assertThat((Object[])this.method.getGenericParameterTypes()).hasLength(1);
        return this.method.getGenericParameterTypes()[0];
    }

    private static Type getSupertype(Type type, Class<?> superclass) {
        Class<?> rawType = superclass;
        return TypeToken.of((Type)type).getSupertype(rawType).getType();
    }

    private static Type getSubtype(Type type, Class<?> subclass) {
        return TypeToken.of((Type)type).getSubtype(subclass).getType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @RequiredModifiers(value={Modifier.PUBLIC})
    static @interface TestSubtype {
        public boolean suppressGetSubtype() default false;

        public boolean suppressGetSupertype() default false;
    }
}

