/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ClassPathUtil;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URLClassLoader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import junit.framework.TestCase;

public class AbstractFutureCancellationCauseTest
extends TestCase {
    private ClassLoader oldClassLoader;
    private URLClassLoader classReloader;

    protected void setUp() throws Exception {
        SettableFuture unused = SettableFuture.create();
        System.setProperty("guava.concurrent.generate_cancellation_cause", "true");
        final String concurrentPackage = SettableFuture.class.getPackage().getName();
        this.classReloader = new URLClassLoader(ClassPathUtil.getClassPathUrls()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.startsWith(concurrentPackage)) {
                    return super.findClass(name);
                }
                return super.loadClass(name);
            }
        };
        this.oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classReloader);
    }

    protected void tearDown() throws Exception {
        this.classReloader.close();
        Thread.currentThread().setContextClassLoader(this.oldClassLoader);
        System.clearProperty("guava.concurrent.generate_cancellation_cause");
    }

    public void testCancel_notDoneNoInterrupt() throws Exception {
        Future<?> future = this.newFutureInstance();
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.cancel(false));
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.isDone());
        try {
            future.get();
            AbstractFutureCancellationCauseTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureCancellationCauseTest.assertNotNull((Object)e.getCause());
        }
    }

    public void testCancel_notDoneInterrupt() throws Exception {
        Future<?> future = this.newFutureInstance();
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.cancel(true));
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.isCancelled());
        AbstractFutureCancellationCauseTest.assertTrue((boolean)future.isDone());
        try {
            future.get();
            AbstractFutureCancellationCauseTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            AbstractFutureCancellationCauseTest.assertNotNull((Object)e.getCause());
        }
    }

    private Future<?> newFutureInstance() throws Exception {
        return (Future)this.classReloader.loadClass(SettableFuture.class.getName()).getMethod("create", new Class[0]).invoke(null, new Object[0]);
    }
}

