/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.testing.TestingExecutors;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class AbstractScheduledServiceTest
extends TestCase {
    volatile AbstractScheduledService.Scheduler configuration = AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
    volatile ScheduledFuture<?> future = null;
    volatile boolean atFixedRateCalled = false;
    volatile boolean withFixedDelayCalled = false;
    volatile boolean scheduleCalled = false;
    final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(10){

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            AbstractScheduledServiceTest.this.future = super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            return AbstractScheduledServiceTest.this.future;
        }
    };

    public void testServiceStartStop() throws Exception {
        NullService service = new NullService();
        service.startAsync().awaitRunning();
        AbstractScheduledServiceTest.assertFalse((boolean)this.future.isDone());
        service.stopAsync().awaitTerminated();
        AbstractScheduledServiceTest.assertTrue((boolean)this.future.isCancelled());
    }

    public void testFailOnExceptionFromRun() throws Exception {
        TestService service = new TestService();
        service.runException = new Exception();
        service.startAsync().awaitRunning();
        service.runFirstBarrier.await();
        service.runSecondBarrier.await();
        try {
            this.future.get();
            AbstractScheduledServiceTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        AbstractScheduledServiceTest.assertEquals((Object)service.runException, (Object)service.failureCause());
        AbstractScheduledServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testFailOnExceptionFromStartUp() {
        TestService service = new TestService();
        service.startUpException = new Exception();
        try {
            service.startAsync().awaitRunning();
            AbstractScheduledServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractScheduledServiceTest.assertEquals((Object)service.startUpException, (Object)e.getCause());
        }
        AbstractScheduledServiceTest.assertEquals((int)0, (int)service.numberOfTimesRunCalled.get());
        AbstractScheduledServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testFailOnErrorFromStartUpListener() throws InterruptedException {
        final Error error = new Error();
        final CountDownLatch latch = new CountDownLatch(1);
        TestService service = new TestService();
        service.addListener(new Service.Listener(){

            public void running() {
                throw error;
            }

            public void failed(Service.State from, Throwable failure) {
                TestCase.assertEquals((Object)Service.State.RUNNING, (Object)from);
                TestCase.assertEquals((Object)error, (Object)failure);
                latch.countDown();
            }
        }, MoreExecutors.directExecutor());
        service.startAsync();
        latch.await();
        AbstractScheduledServiceTest.assertEquals((int)0, (int)service.numberOfTimesRunCalled.get());
        AbstractScheduledServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testFailOnExceptionFromShutDown() throws Exception {
        TestService service = new TestService();
        service.shutDownException = new Exception();
        service.startAsync().awaitRunning();
        service.runFirstBarrier.await();
        service.stopAsync();
        service.runSecondBarrier.await();
        try {
            service.awaitTerminated();
            AbstractScheduledServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractScheduledServiceTest.assertEquals((Object)service.shutDownException, (Object)e.getCause());
        }
        AbstractScheduledServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
    }

    public void testRunOneIterationCalledMultipleTimes() throws Exception {
        TestService service = new TestService();
        service.startAsync().awaitRunning();
        for (int i = 1; i < 10; ++i) {
            service.runFirstBarrier.await();
            AbstractScheduledServiceTest.assertEquals((int)i, (int)service.numberOfTimesRunCalled.get());
            service.runSecondBarrier.await();
        }
        service.runFirstBarrier.await();
        service.stopAsync();
        service.runSecondBarrier.await();
        service.stopAsync().awaitTerminated();
    }

    public void testExecutorOnlyCalledOnce() throws Exception {
        TestService service = new TestService();
        service.startAsync().awaitRunning();
        AbstractScheduledServiceTest.assertEquals((int)1, (int)service.numberOfTimesExecutorCalled.get());
        for (int i = 1; i < 10; ++i) {
            service.runFirstBarrier.await();
            AbstractScheduledServiceTest.assertEquals((int)i, (int)service.numberOfTimesRunCalled.get());
            service.runSecondBarrier.await();
        }
        service.runFirstBarrier.await();
        service.stopAsync();
        service.runSecondBarrier.await();
        service.stopAsync().awaitTerminated();
        AbstractScheduledServiceTest.assertEquals((int)1, (int)service.numberOfTimesExecutorCalled.get());
    }

    public void testDefaultExecutorIsShutdownWhenServiceIsStopped() throws Exception {
        final AtomicReference executor = Atomics.newReference();
        AbstractScheduledService service = new AbstractScheduledService(){

            protected void runOneIteration() throws Exception {
            }

            protected ScheduledExecutorService executor() {
                executor.set(super.executor());
                return (ScheduledExecutorService)executor.get();
            }

            protected AbstractScheduledService.Scheduler scheduler() {
                return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        service.startAsync();
        AbstractScheduledServiceTest.assertFalse((boolean)service.executor().isShutdown());
        service.awaitRunning();
        service.stopAsync();
        service.awaitTerminated();
        AbstractScheduledServiceTest.assertTrue((boolean)((ScheduledExecutorService)executor.get()).awaitTermination(100L, TimeUnit.MILLISECONDS));
    }

    public void testDefaultExecutorIsShutdownWhenServiceFails() throws Exception {
        final AtomicReference executor = Atomics.newReference();
        AbstractScheduledService service = new AbstractScheduledService(){

            protected void startUp() throws Exception {
                throw new Exception("Failed");
            }

            protected void runOneIteration() throws Exception {
            }

            protected ScheduledExecutorService executor() {
                executor.set(super.executor());
                return (ScheduledExecutorService)executor.get();
            }

            protected AbstractScheduledService.Scheduler scheduler() {
                return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        try {
            service.startAsync().awaitRunning();
            AbstractScheduledServiceTest.fail((String)"Expected service to fail during startup");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractScheduledServiceTest.assertTrue((boolean)((ScheduledExecutorService)executor.get()).awaitTermination(100L, TimeUnit.MILLISECONDS));
    }

    public void testSchedulerOnlyCalledOnce() throws Exception {
        TestService service = new TestService();
        service.startAsync().awaitRunning();
        AbstractScheduledServiceTest.assertEquals((int)1, (int)service.numberOfTimesSchedulerCalled.get());
        for (int i = 1; i < 10; ++i) {
            service.runFirstBarrier.await();
            AbstractScheduledServiceTest.assertEquals((int)i, (int)service.numberOfTimesRunCalled.get());
            service.runSecondBarrier.await();
        }
        service.runFirstBarrier.await();
        service.stopAsync();
        service.runSecondBarrier.await();
        service.awaitTerminated();
        AbstractScheduledServiceTest.assertEquals((int)1, (int)service.numberOfTimesSchedulerCalled.get());
    }

    public void testTimeout() {
        AbstractScheduledService service = new AbstractScheduledService(){

            protected AbstractScheduledService.Scheduler scheduler() {
                return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS);
            }

            protected ScheduledExecutorService executor() {
                return TestingExecutors.noOpScheduledExecutor();
            }

            protected void runOneIteration() throws Exception {
            }

            protected String serviceName() {
                return "Foo";
            }
        };
        try {
            service.startAsync().awaitRunning(1L, TimeUnit.MILLISECONDS);
            AbstractScheduledServiceTest.fail((String)"Expected timeout");
        }
        catch (TimeoutException e) {
            Truth.assertThat((Throwable)e).hasMessage("Timed out waiting for Foo [STARTING] to reach the RUNNING state.");
        }
    }

    public static class SchedulerTest
    extends TestCase {
        private static final int initialDelay = 10;
        private static final int delay = 20;
        private static final TimeUnit unit = TimeUnit.MILLISECONDS;
        final Runnable testRunnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        boolean called = false;

        private void assertSingleCallWithCorrectParameters(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            SchedulerTest.assertFalse((boolean)this.called);
            this.called = true;
            SchedulerTest.assertEquals((long)10L, (long)initialDelay);
            SchedulerTest.assertEquals((long)20L, (long)delay);
            SchedulerTest.assertEquals((Object)((Object)SchedulerTest.unit), (Object)((Object)unit));
            SchedulerTest.assertEquals((Object)this.testRunnable, (Object)command);
        }

        public void testFixedRateSchedule() {
            AbstractScheduledService.Scheduler schedule = AbstractScheduledService.Scheduler.newFixedRateSchedule((long)10L, (long)20L, (TimeUnit)unit);
            Future unused = schedule.schedule(null, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1){

                @Override
                public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                    this.assertSingleCallWithCorrectParameters(command, initialDelay, 20L, unit);
                    return null;
                }
            }, this.testRunnable);
            SchedulerTest.assertTrue((boolean)this.called);
        }

        public void testFixedDelaySchedule() {
            AbstractScheduledService.Scheduler schedule = AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)10L, (long)20L, (TimeUnit)unit);
            Future unused = schedule.schedule(null, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(10){

                @Override
                public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                    this.assertSingleCallWithCorrectParameters(command, initialDelay, delay, unit);
                    return null;
                }
            }, this.testRunnable);
            SchedulerTest.assertTrue((boolean)this.called);
        }

        public void testFixedDelayScheduleFarFuturePotentiallyOverflowingScheduleIsNeverReached() throws Exception {
            TestAbstractScheduledCustomService service = new TestAbstractScheduledCustomService(){

                @Override
                protected AbstractScheduledService.Scheduler scheduler() {
                    return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)Long.MAX_VALUE, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS);
                }
            };
            service.startAsync().awaitRunning();
            try {
                service.firstBarrier.await(5L, TimeUnit.SECONDS);
                SchedulerTest.fail();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            SchedulerTest.assertEquals((int)0, (int)service.numIterations.get());
            service.stopAsync();
            service.awaitTerminated();
        }

        public void testCustomSchedulerFarFuturePotentiallyOverflowingScheduleIsNeverReached() throws Exception {
            TestAbstractScheduledCustomService service = new TestAbstractScheduledCustomService(){

                @Override
                protected AbstractScheduledService.Scheduler scheduler() {
                    return new AbstractScheduledService.CustomScheduler(){

                        protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                            return new AbstractScheduledService.CustomScheduler.Schedule(Long.MAX_VALUE, TimeUnit.SECONDS);
                        }
                    };
                }
            };
            service.startAsync().awaitRunning();
            try {
                service.firstBarrier.await(5L, TimeUnit.SECONDS);
                SchedulerTest.fail();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            SchedulerTest.assertEquals((int)0, (int)service.numIterations.get());
            service.stopAsync();
            service.awaitTerminated();
        }

        public void testCustomSchedule_startStop() throws Exception {
            final CyclicBarrier firstBarrier = new CyclicBarrier(2);
            final CyclicBarrier secondBarrier = new CyclicBarrier(2);
            final AtomicBoolean shouldWait = new AtomicBoolean(true);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (shouldWait.get()) {
                            firstBarrier.await();
                            secondBarrier.await();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            TestCustomScheduler scheduler = new TestCustomScheduler();
            Future future = scheduler.schedule(null, Executors.newScheduledThreadPool(10), task);
            firstBarrier.await();
            SchedulerTest.assertEquals((int)1, (int)scheduler.scheduleCounter.get());
            secondBarrier.await();
            firstBarrier.await();
            SchedulerTest.assertEquals((int)2, (int)scheduler.scheduleCounter.get());
            shouldWait.set(false);
            secondBarrier.await();
            future.cancel(false);
        }

        public void testCustomSchedulerServiceStop() throws Exception {
            TestAbstractScheduledCustomService service = new TestAbstractScheduledCustomService();
            service.startAsync().awaitRunning();
            service.firstBarrier.await();
            SchedulerTest.assertEquals((int)1, (int)service.numIterations.get());
            service.stopAsync();
            service.secondBarrier.await();
            service.awaitTerminated();
            Thread.sleep(unit.toMillis(60L));
            SchedulerTest.assertEquals((int)1, (int)service.numIterations.get());
        }

        public void testCustomScheduler_deadlock() throws InterruptedException, BrokenBarrierException {
            final CyclicBarrier inGetNextSchedule = new CyclicBarrier(2);
            for (int i = 0; i < 1000; ++i) {
                AbstractScheduledService service = new AbstractScheduledService(){

                    protected void runOneIteration() {
                    }

                    protected AbstractScheduledService.Scheduler scheduler() {
                        return new AbstractScheduledService.CustomScheduler(){

                            protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                                if (this.state() != Service.State.STARTING) {
                                    inGetNextSchedule.await();
                                    Thread.yield();
                                    throw new RuntimeException("boom");
                                }
                                return new AbstractScheduledService.CustomScheduler.Schedule(0L, TimeUnit.NANOSECONDS);
                            }
                        };
                    }
                };
                service.startAsync().awaitRunning();
                inGetNextSchedule.await();
                service.stopAsync();
            }
        }

        public void testBig() throws Exception {
            TestAbstractScheduledCustomService service = new TestAbstractScheduledCustomService(){

                @Override
                protected AbstractScheduledService.Scheduler scheduler() {
                    return new AbstractScheduledService.CustomScheduler(){

                        protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                            Thread.yield();
                            return new AbstractScheduledService.CustomScheduler.Schedule(0L, TimeUnit.SECONDS);
                        }
                    };
                }
            };
            service.useBarriers = false;
            service.startAsync().awaitRunning();
            Thread.sleep(50L);
            service.useBarriers = true;
            service.firstBarrier.await();
            int numIterations = service.numIterations.get();
            service.stopAsync();
            service.secondBarrier.await();
            service.awaitTerminated();
            SchedulerTest.assertEquals((int)numIterations, (int)service.numIterations.get());
        }

        public void testCustomSchedulerFailure() throws Exception {
            TestFailingCustomScheduledService service = new TestFailingCustomScheduledService();
            service.startAsync().awaitRunning();
            for (int i = 1; i < 4; ++i) {
                service.firstBarrier.await();
                SchedulerTest.assertEquals((int)i, (int)service.numIterations.get());
                service.secondBarrier.await();
            }
            Thread.sleep(1000L);
            try {
                service.stopAsync().awaitTerminated(100L, TimeUnit.SECONDS);
                SchedulerTest.fail();
            }
            catch (IllegalStateException e) {
                SchedulerTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
            }
        }

        private static class TestFailingCustomScheduledService
        extends AbstractScheduledService {
            final AtomicInteger numIterations = new AtomicInteger(0);
            final CyclicBarrier firstBarrier = new CyclicBarrier(2);
            final CyclicBarrier secondBarrier = new CyclicBarrier(2);

            private TestFailingCustomScheduledService() {
            }

            protected void runOneIteration() throws Exception {
                this.numIterations.incrementAndGet();
                this.firstBarrier.await();
                this.secondBarrier.await();
            }

            protected ScheduledExecutorService executor() {
                return Executors.newScheduledThreadPool(10);
            }

            protected AbstractScheduledService.Scheduler scheduler() {
                return new AbstractScheduledService.CustomScheduler(){

                    protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                        if (numIterations.get() > 2) {
                            throw new IllegalStateException("Failed");
                        }
                        return new AbstractScheduledService.CustomScheduler.Schedule(20L, unit);
                    }
                };
            }
        }

        private static class TestAbstractScheduledCustomService
        extends AbstractScheduledService {
            final AtomicInteger numIterations = new AtomicInteger(0);
            volatile boolean useBarriers = true;
            final CyclicBarrier firstBarrier = new CyclicBarrier(2);
            final CyclicBarrier secondBarrier = new CyclicBarrier(2);

            private TestAbstractScheduledCustomService() {
            }

            protected void runOneIteration() throws Exception {
                this.numIterations.incrementAndGet();
                if (this.useBarriers) {
                    this.firstBarrier.await();
                    this.secondBarrier.await();
                }
            }

            protected ScheduledExecutorService executor() {
                return Executors.newScheduledThreadPool(10);
            }

            protected AbstractScheduledService.Scheduler scheduler() {
                return new AbstractScheduledService.CustomScheduler(){

                    protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                        return new AbstractScheduledService.CustomScheduler.Schedule(20L, unit);
                    }
                };
            }
        }

        private class TestCustomScheduler
        extends AbstractScheduledService.CustomScheduler {
            public AtomicInteger scheduleCounter = new AtomicInteger(0);

            private TestCustomScheduler() {
            }

            protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                this.scheduleCounter.incrementAndGet();
                return new AbstractScheduledService.CustomScheduler.Schedule(0L, TimeUnit.SECONDS);
            }
        }
    }

    private class TestService
    extends AbstractScheduledService {
        CyclicBarrier runFirstBarrier = new CyclicBarrier(2);
        CyclicBarrier runSecondBarrier = new CyclicBarrier(2);
        volatile boolean startUpCalled = false;
        volatile boolean shutDownCalled = false;
        AtomicInteger numberOfTimesRunCalled = new AtomicInteger(0);
        AtomicInteger numberOfTimesExecutorCalled = new AtomicInteger(0);
        AtomicInteger numberOfTimesSchedulerCalled = new AtomicInteger(0);
        volatile Exception runException = null;
        volatile Exception startUpException = null;
        volatile Exception shutDownException = null;

        private TestService() {
        }

        protected void runOneIteration() throws Exception {
            TestCase.assertTrue((boolean)this.startUpCalled);
            TestCase.assertFalse((boolean)this.shutDownCalled);
            this.numberOfTimesRunCalled.incrementAndGet();
            TestCase.assertEquals((Object)Service.State.RUNNING, (Object)this.state());
            this.runFirstBarrier.await();
            this.runSecondBarrier.await();
            if (this.runException != null) {
                throw this.runException;
            }
        }

        protected void startUp() throws Exception {
            TestCase.assertFalse((boolean)this.startUpCalled);
            TestCase.assertFalse((boolean)this.shutDownCalled);
            this.startUpCalled = true;
            TestCase.assertEquals((Object)Service.State.STARTING, (Object)this.state());
            if (this.startUpException != null) {
                throw this.startUpException;
            }
        }

        protected void shutDown() throws Exception {
            TestCase.assertTrue((boolean)this.startUpCalled);
            TestCase.assertFalse((boolean)this.shutDownCalled);
            this.shutDownCalled = true;
            if (this.shutDownException != null) {
                throw this.shutDownException;
            }
        }

        protected ScheduledExecutorService executor() {
            this.numberOfTimesExecutorCalled.incrementAndGet();
            return AbstractScheduledServiceTest.this.executor;
        }

        protected AbstractScheduledService.Scheduler scheduler() {
            this.numberOfTimesSchedulerCalled.incrementAndGet();
            return AbstractScheduledServiceTest.this.configuration;
        }
    }

    private class NullService
    extends AbstractScheduledService {
        private NullService() {
        }

        protected void runOneIteration() throws Exception {
        }

        protected AbstractScheduledService.Scheduler scheduler() {
            return AbstractScheduledServiceTest.this.configuration;
        }

        protected ScheduledExecutorService executor() {
            return AbstractScheduledServiceTest.this.executor;
        }
    }
}

