/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReferenceArray;
import junit.framework.TestCase;

public class AtomicsTest
extends TestCase {
    private static final Object OBJECT = new Object();

    public void testNewReference() throws Exception {
        AtomicsTest.assertEquals(null, Atomics.newReference().get());
    }

    public void testNewReference_withInitialValue() throws Exception {
        AtomicsTest.assertEquals(null, Atomics.newReference(null).get());
        AtomicsTest.assertEquals((Object)OBJECT, Atomics.newReference((Object)OBJECT).get());
    }

    public void testNewReferenceArray_withLength() throws Exception {
        int length = 42;
        AtomicReferenceArray refArray = Atomics.newReferenceArray((int)length);
        for (int i = 0; i < length; ++i) {
            AtomicsTest.assertEquals(null, (String)((String)refArray.get(i)));
        }
        try {
            refArray.get(length);
            AtomicsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testNewReferenceArray_withNegativeLength() throws Exception {
        try {
            Atomics.newReferenceArray((int)-1);
            AtomicsTest.fail();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
    }

    public void testNewReferenceArray_withStringArray() throws Exception {
        Object[] array = new String[]{"foo", "bar", "baz"};
        AtomicReferenceArray refArray = Atomics.newReferenceArray((Object[])array);
        for (int i = 0; i < array.length; ++i) {
            AtomicsTest.assertEquals((String)array[i], (String)((String)refArray.get(i)));
        }
        try {
            refArray.get(array.length);
            AtomicsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testNewReferenceArray_withNullArray() throws Exception {
        try {
            Atomics.newReferenceArray(null);
            AtomicsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicConstructors(Atomics.class);
        tester.testAllPublicStaticMethods(Atomics.class);
    }
}

