/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

final class ClassPathUtil {
    private ClassPathUtil() {
    }

    static URL[] parseJavaClassPath() {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add((Object)new File(entry).toURI().toURL());
                }
                catch (SecurityException e) {
                    urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                AssertionError error = new AssertionError((Object)("malformed class path entry: " + entry));
                ((Throwable)((Object)error)).initCause(e);
                throw error;
            }
        }
        return (URL[])urls.build().toArray((Object[])new URL[0]);
    }

    static URL[] getClassPathUrls() {
        return ClassPathUtil.class.getClassLoader() instanceof URLClassLoader ? ((URLClassLoader)ClassPathUtil.class.getClassLoader()).getURLs() : ClassPathUtil.parseJavaClassPath();
    }
}

