/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.FakeTimeLimiter;
import com.google.common.util.concurrent.Runnables;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class FakeTimeLimiterTest
extends TestCase {
    private static final int DELAY_MS = 50;
    private static final String RETURN_VALUE = "abc";
    private TimeLimiter timeLimiter;

    protected void setUp() throws Exception {
        super.setUp();
        this.timeLimiter = new FakeTimeLimiter();
    }

    public void testCallWithTimeout_propagatesReturnValue() throws Exception {
        String result = (String)this.timeLimiter.callWithTimeout(Callables.returning((Object)RETURN_VALUE), 50L, TimeUnit.MILLISECONDS);
        Truth.assertThat((String)result).isEqualTo((Object)RETURN_VALUE);
    }

    public void testCallWithTimeout_wrapsCheckedException() throws Exception {
        SampleCheckedException exception = new SampleCheckedException();
        try {
            this.timeLimiter.callWithTimeout(FakeTimeLimiterTest.callableThrowing(exception), 50L, TimeUnit.MILLISECONDS);
            FakeTimeLimiterTest.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isEqualTo((Object)exception);
        }
    }

    public void testCallWithTimeout_wrapsUncheckedException() throws Exception {
        RuntimeException exception = new RuntimeException("test");
        try {
            this.timeLimiter.callWithTimeout(FakeTimeLimiterTest.callableThrowing(exception), 50L, TimeUnit.MILLISECONDS);
            FakeTimeLimiterTest.fail((String)"Expected UncheckedExecutionException");
        }
        catch (UncheckedExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isEqualTo((Object)exception);
        }
    }

    public void testCallUninterruptiblyWithTimeout_propagatesReturnValue() throws Exception {
        String result = (String)this.timeLimiter.callUninterruptiblyWithTimeout(Callables.returning((Object)RETURN_VALUE), 50L, TimeUnit.MILLISECONDS);
        Truth.assertThat((String)result).isEqualTo((Object)RETURN_VALUE);
    }

    public void testRunWithTimeout_returnsWithoutException() throws Exception {
        this.timeLimiter.runWithTimeout(Runnables.doNothing(), 50L, TimeUnit.MILLISECONDS);
    }

    public void testRunWithTimeout_wrapsUncheckedException() throws Exception {
        RuntimeException exception = new RuntimeException("test");
        try {
            this.timeLimiter.runWithTimeout(FakeTimeLimiterTest.runnableThrowing(exception), 50L, TimeUnit.MILLISECONDS);
            FakeTimeLimiterTest.fail((String)"Expected UncheckedExecutionException");
        }
        catch (UncheckedExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isEqualTo((Object)exception);
        }
    }

    public void testRunUninterruptiblyWithTimeout_wrapsUncheckedException() throws Exception {
        RuntimeException exception = new RuntimeException("test");
        try {
            this.timeLimiter.runUninterruptiblyWithTimeout(FakeTimeLimiterTest.runnableThrowing(exception), 50L, TimeUnit.MILLISECONDS);
            FakeTimeLimiterTest.fail((String)"Expected UncheckedExecutionException");
        }
        catch (UncheckedExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isEqualTo((Object)exception);
        }
    }

    public static <T> Callable<T> callableThrowing(final Exception exception) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                throw exception;
            }
        };
    }

    private static Runnable runnableThrowing(final RuntimeException e) {
        return new Runnable(){

            @Override
            public void run() {
                throw e;
            }
        };
    }

    private static class SampleCheckedException
    extends Exception {
        private SampleCheckedException() {
        }
    }
}

