/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Verify;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class FluentFutureTest
extends TestCase {
    public void testFromFluentFuture() {
        SettableFuture f = SettableFuture.create();
        Truth.assertThat((Object)FluentFuture.from((ListenableFuture)f)).isSameAs((Object)f);
    }

    public void testFromNonFluentFuture() throws Exception {
        ForwardingListenableFuture.SimpleForwardingListenableFuture<String> f = new ForwardingListenableFuture.SimpleForwardingListenableFuture<String>(Futures.immediateFuture((Object)"a")){};
        Verify.verify((!(f instanceof FluentFuture) ? 1 : 0) != 0);
        Truth.assertThat((String)((String)FluentFuture.from((ListenableFuture)f).get())).isEqualTo((Object)"a");
    }

    public void testAddCallback() {
        FluentFuture f = FluentFuture.from((ListenableFuture)Futures.immediateFuture((Object)"a"));
        final boolean[] called = new boolean[1];
        f.addCallback((FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String result) {
                called[0] = true;
            }

            public void onFailure(Throwable t) {
            }
        }, MoreExecutors.directExecutor());
        Truth.assertThat((Boolean)called[0]).isTrue();
    }

    public void testCatching() throws Exception {
        FluentFuture f = FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)new RuntimeException())).catching(Throwable.class, new Function<Throwable, Class<?>>(){

            public Class<?> apply(Throwable input) {
                return input.getClass();
            }
        }, MoreExecutors.directExecutor());
        Truth.assertThat((Object)f.get()).isEqualTo(RuntimeException.class);
    }

    public void testCatchingAsync() throws Exception {
        FluentFuture f = FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)new RuntimeException())).catchingAsync(Throwable.class, new AsyncFunction<Throwable, Class<?>>(){

            public ListenableFuture<Class<?>> apply(Throwable input) {
                return Futures.immediateFuture(input.getClass());
            }
        }, MoreExecutors.directExecutor());
        Truth.assertThat((Object)f.get()).isEqualTo(RuntimeException.class);
    }

    public void testTransform() throws Exception {
        FluentFuture f = FluentFuture.from((ListenableFuture)Futures.immediateFuture((Object)1)).transform((Function)new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input + 1;
            }
        }, MoreExecutors.directExecutor());
        Truth.assertThat((Integer)((Integer)f.get())).isEqualTo((Object)2);
    }

    public void testTransformAsync() throws Exception {
        FluentFuture f = FluentFuture.from((ListenableFuture)Futures.immediateFuture((Object)1)).transformAsync((AsyncFunction)new AsyncFunction<Integer, Integer>(){

            public ListenableFuture<Integer> apply(Integer input) {
                return Futures.immediateFuture((Object)(input + 1));
            }
        }, MoreExecutors.directExecutor());
        Truth.assertThat((Integer)((Integer)f.get())).isEqualTo((Object)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible
    public void testWithTimeout() throws Exception {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        try {
            FluentFuture f = SettableFuture.create().withTimeout(0L, TimeUnit.SECONDS, executor);
            try {
                f.get();
                FluentFutureTest.fail();
            }
            catch (ExecutionException e) {
                Truth.assertThat((Throwable)e.getCause()).isInstanceOf(TimeoutException.class);
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

