/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedThrowingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import junit.framework.TestCase;
import org.mockito.Mockito;

@GwtCompatible(emulated=true)
public class FutureCallbackTest
extends TestCase {
    public void testSameThreadSuccess() {
        SettableFuture f = SettableFuture.create();
        MockCallback callback = new MockCallback("foo");
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        f.set((Object)"foo");
    }

    public void testExecutorSuccess() {
        CountingSameThreadExecutor ex = new CountingSameThreadExecutor();
        SettableFuture f = SettableFuture.create();
        MockCallback callback = new MockCallback("foo");
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)ex);
        f.set((Object)"foo");
        FutureCallbackTest.assertEquals((int)1, (int)ex.runCount);
    }

    public void testSameThreadExecutionException() {
        SettableFuture f = SettableFuture.create();
        IllegalArgumentException e = new IllegalArgumentException("foo not found");
        MockCallback callback = new MockCallback(e);
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        f.setException((Throwable)e);
    }

    public void testCancel() {
        SettableFuture f = SettableFuture.create();
        FutureCallback<String> callback = new FutureCallback<String>(){
            private boolean called = false;

            public void onSuccess(String result) {
                TestCase.fail((String)"Was not expecting onSuccess() to be called.");
            }

            public synchronized void onFailure(Throwable t) {
                TestCase.assertFalse((boolean)this.called);
                Truth.assertThat((Throwable)t).isInstanceOf(CancellationException.class);
                this.called = true;
            }
        };
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        f.cancel(true);
    }

    public void testThrowErrorFromGet() {
        AssertionError error = new AssertionError((Object)"ASSERT!");
        ListenableFuture f = UncheckedThrowingFuture.throwingError((Error)((Object)error));
        MockCallback callback = new MockCallback((Throwable)((Object)error));
        Futures.addCallback(f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
    }

    public void testRuntimeExeceptionFromGet() {
        IllegalArgumentException e = new IllegalArgumentException("foo not found");
        ListenableFuture f = UncheckedThrowingFuture.throwingRuntimeException(e);
        MockCallback callback = new MockCallback(e);
        Futures.addCallback(f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
    }

    @GwtIncompatible
    public void testOnSuccessThrowsRuntimeException() throws Exception {
        RuntimeException exception = new RuntimeException();
        String result = "result";
        SettableFuture future = SettableFuture.create();
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        ((FutureCallback)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)callback)).onSuccess((Object)result);
        future.set((Object)result);
        FutureCallbackTest.assertEquals((String)result, (String)((String)future.get()));
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    @GwtIncompatible
    public void testOnSuccessThrowsError() throws Exception {
        class TestError
        extends Error {
            TestError() {
            }
        }
        TestError error = new TestError();
        String result = "result";
        SettableFuture future = SettableFuture.create();
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        ((FutureCallback)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)callback)).onSuccess((Object)result);
        try {
            future.set((Object)result);
            FutureCallbackTest.fail((String)"Should have thrown");
        }
        catch (TestError e) {
            FutureCallbackTest.assertSame((Object)error, (Object)e);
        }
        FutureCallbackTest.assertEquals((String)result, (String)((String)future.get()));
        ((FutureCallback)Mockito.verify((Object)callback)).onSuccess((Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callback});
    }

    public void testWildcardFuture() {
        SettableFuture settable;
        SettableFuture f = settable = SettableFuture.create();
        FutureCallback<Object> callback = new FutureCallback<Object>(){

            public void onSuccess(Object result) {
            }

            public void onFailure(Throwable t) {
            }
        };
        Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
    }

    private final class MockCallback
    implements FutureCallback<String> {
        @Nullable
        private String value = null;
        @Nullable
        private Throwable failure = null;
        private boolean wasCalled = false;

        MockCallback(String expectedValue) {
            this.value = expectedValue;
        }

        public MockCallback(Throwable expectedFailure) {
            this.failure = expectedFailure;
        }

        public synchronized void onSuccess(String result) {
            TestCase.assertFalse((boolean)this.wasCalled);
            this.wasCalled = true;
            TestCase.assertEquals((String)this.value, (String)result);
        }

        public synchronized void onFailure(Throwable t) {
            TestCase.assertFalse((boolean)this.wasCalled);
            this.wasCalled = true;
            TestCase.assertEquals((Object)this.failure, (Object)t);
        }
    }

    private class CountingSameThreadExecutor
    implements Executor {
        int runCount = 0;

        private CountingSameThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            ++this.runCount;
        }
    }
}

